/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.raid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class RaidManager
extends WorldSavedData {
    private final Map<Integer, Raid> byId = Maps.newHashMap();
    private final ServerWorld world;
    private int nextAvailableId;
    private int tick;

    public RaidManager(ServerWorld p_i50142_1_) {
        super(RaidManager.func_234620_a_(p_i50142_1_.getDimensionType()));
        this.world = p_i50142_1_;
        this.nextAvailableId = 1;
        this.markDirty();
    }

    public Raid get(int id) {
        return this.byId.get(id);
    }

    public void tick() {
        ++this.tick;
        Iterator<Raid> iterator = this.byId.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = iterator.next();
            if (this.world.getGameRules().getBoolean(GameRules.DISABLE_RAIDS)) {
                raid.stop();
            }
            if (raid.isStopped()) {
                iterator.remove();
                this.markDirty();
                continue;
            }
            raid.tick();
        }
        if (this.tick % 200 == 0) {
            this.markDirty();
        }
        DebugPacketSender.sendRaids(this.world, this.byId.values());
    }

    public static boolean canJoinRaid(AbstractRaiderEntity p_215165_0_, Raid p_215165_1_) {
        if (p_215165_0_ != null && p_215165_1_ != null && p_215165_1_.getWorld() != null) {
            return p_215165_0_.isAlive() && p_215165_0_.canJoinRaid() && p_215165_0_.getIdleTime() <= 2400 && p_215165_0_.world.getDimensionType() == p_215165_1_.getWorld().getDimensionType();
        }
        return false;
    }

    @Nullable
    public Raid badOmenTick(ServerPlayerEntity p_215170_1_) {
        BlockPos blockpos1;
        if (p_215170_1_.isSpectator()) {
            return null;
        }
        if (this.world.getGameRules().getBoolean(GameRules.DISABLE_RAIDS)) {
            return null;
        }
        DimensionType dimensiontype = p_215170_1_.world.getDimensionType();
        if (!dimensiontype.isHasRaids()) {
            return null;
        }
        BlockPos blockpos = p_215170_1_.getPosition();
        List list = this.world.getPointOfInterestManager().func_219146_b(PointOfInterestType.MATCH_ANY, blockpos, 64, PointOfInterestManager.Status.IS_OCCUPIED).collect(Collectors.toList());
        int i = 0;
        Vector3d vector3d = Vector3d.ZERO;
        for (PointOfInterest pointofinterest : list) {
            BlockPos blockpos2 = pointofinterest.getPos();
            vector3d = vector3d.add(blockpos2.getX(), blockpos2.getY(), blockpos2.getZ());
            ++i;
        }
        if (i > 0) {
            vector3d = vector3d.scale(1.0 / (double)i);
            blockpos1 = new BlockPos(vector3d);
        } else {
            blockpos1 = blockpos;
        }
        Raid raid = this.findOrCreateRaid(p_215170_1_.getServerWorld(), blockpos1);
        boolean flag = false;
        if (!raid.isStarted()) {
            if (!this.byId.containsKey(raid.getId())) {
                this.byId.put(raid.getId(), raid);
            }
            flag = true;
        } else if (raid.getBadOmenLevel() < raid.getMaxLevel()) {
            flag = true;
        } else {
            p_215170_1_.removePotionEffect(Effects.BAD_OMEN);
            p_215170_1_.connection.sendPacket(new SEntityStatusPacket(p_215170_1_, 43));
        }
        if (flag) {
            raid.increaseLevel(p_215170_1_);
            p_215170_1_.connection.sendPacket(new SEntityStatusPacket(p_215170_1_, 43));
            if (!raid.func_221297_c()) {
                p_215170_1_.addStat(Stats.RAID_TRIGGER);
                CriteriaTriggers.VOLUNTARY_EXILE.trigger(p_215170_1_);
            }
        }
        this.markDirty();
        return raid;
    }

    private Raid findOrCreateRaid(ServerWorld p_215168_1_, BlockPos p_215168_2_) {
        Raid raid = p_215168_1_.findRaid(p_215168_2_);
        return raid != null ? raid : new Raid(this.incrementNextId(), p_215168_1_, p_215168_2_);
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.nextAvailableId = nbt.getInt("NextAvailableID");
        this.tick = nbt.getInt("Tick");
        ListNBT listnbt = nbt.getList("Raids", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.getCompound(i);
            Raid raid = new Raid(this.world, compoundnbt);
            this.byId.put(raid.getId(), raid);
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound.putInt("NextAvailableID", this.nextAvailableId);
        compound.putInt("Tick", this.tick);
        ListNBT listnbt = new ListNBT();
        for (Raid raid : this.byId.values()) {
            CompoundNBT compoundnbt = new CompoundNBT();
            raid.write(compoundnbt);
            listnbt.add(compoundnbt);
        }
        compound.put("Raids", listnbt);
        return compound;
    }

    public static String func_234620_a_(DimensionType p_234620_0_) {
        return "raids" + p_234620_0_.getSuffix();
    }

    private int incrementNextId() {
        return ++this.nextAvailableId;
    }

    @Nullable
    public Raid findRaid(BlockPos p_215174_1_, int distance) {
        Raid raid = null;
        double d0 = distance;
        for (Raid raid1 : this.byId.values()) {
            double d1 = raid1.getCenter().distanceSq(p_215174_1_);
            if (!raid1.isActive() || !(d1 < d0)) continue;
            raid = raid1;
            d0 = d1;
        }
        return raid;
    }
}

