/*
 * Decompiled with CFR 0.152.
 */
package team.sdhq.eventBus;

import com.mentalfrostbyte.Client;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import team.sdhq.eventBus.Event;
import team.sdhq.eventBus.annotations.EventTarget;
import team.sdhq.eventBus.annotations.priority.HigherPriority;
import team.sdhq.eventBus.annotations.priority.HighestPriority;
import team.sdhq.eventBus.annotations.priority.LowerPriority;
import team.sdhq.eventBus.annotations.priority.LowestPriority;

public final class EventBus {
    private static final HashMap<Class<? extends Event>, HashMap<Method, Object>> REGISTERED_METHODS = new HashMap();

    public static void register(Object o) {
        for (Method method : o.getClass().getDeclaredMethods()) {
            Class<?> arg;
            Class<?>[] params;
            if (Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(EventTarget.class) || (params = method.getParameterTypes()).length != 1 || !EventBus.instanceofEvent(arg = params[0])) continue;
            EventBus.ensureHashmap(arg);
            REGISTERED_METHODS.get(arg).put(method, o);
        }
        EventBus.sortEventReceivers();
    }

    public static void unregister(Object o) {
        for (Method method : o.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(EventTarget.class)) continue;
            REGISTERED_METHODS.values().forEach(hm -> hm.remove(method));
        }
    }

    public static void call(Event e) {
        HashMap<Method, Object> map = REGISTERED_METHODS.get(e.getClass());
        if (map == null) {
            return;
        }
        try {
            for (Method m : map.keySet()) {
                Object instance = map.get(m);
                try {
                    m.setAccessible(true);
                    m.invoke(instance, e);
                }
                catch (IllegalAccessException ex) {
                    Client.logger.error("!!! PRIVATE EVENT LISTENER: {}#{}", (Object)instance.getClass().getName(), (Object)m.getName());
                }
                catch (InvocationTargetException ex) {
                    Client.logger.error("Exception from listener: {}#{}", (Object)instance.getClass().getName(), (Object)m.getName());
                }
                catch (Throwable ex) {
                    Client.logger.error((Object)ex);
                }
            }
        }
        catch (ConcurrentModificationException ex) {
            Client.logger.warn("Ignored concurrent modification exception because those are gay");
        }
    }

    private static boolean instanceofEvent(Class<?> arg) {
        while (!arg.isAssignableFrom(Event.class)) {
            if (arg.isAssignableFrom(Object.class)) {
                return false;
            }
            arg = arg.getSuperclass();
        }
        return true;
    }

    private static void ensureHashmap(Class<? extends Event> arg) {
        if (REGISTERED_METHODS.containsKey(arg)) {
            return;
        }
        REGISTERED_METHODS.put(arg, new HashMap());
    }

    private static int getPriority(Method method) {
        if (method.isAnnotationPresent(HighestPriority.class)) {
            return 1;
        }
        if (method.isAnnotationPresent(HigherPriority.class)) {
            return 2;
        }
        if (method.isAnnotationPresent(LowerPriority.class)) {
            return 4;
        }
        if (method.isAnnotationPresent(LowestPriority.class)) {
            return 5;
        }
        return 3;
    }

    public static void sortEventReceivers() {
        for (Class<? extends Event> eventClass : REGISTERED_METHODS.keySet()) {
            REGISTERED_METHODS.replace(eventClass, REGISTERED_METHODS.get(eventClass).entrySet().stream().sorted(Comparator.comparingInt(e -> EventBus.getPriority((Method)e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)));
        }
    }
}

