

<div align="center">
  <img width="300" src="https://astral.fan/_astro/%E6%9A%97%E8%89%B2.C9IdEQgX.svg" alt="Astral Logo">
  <h1 id="astral"></h1>

  [![Ask DeepWiki](https://deepwiki.com/badge.svg)](https://deepwiki.com/ldoubil/astral)
  ![License](https://img.shields.io/badge/License-CC%20BY--NC--ND%204.0-lightgrey.svg)
  ![Platforms](https://img.shields.io/badge/平台-Windows%20%7C%20macOS%20%7C%20Linux%20%7C%20Android%20%7C%20iOS-blue?style=flat-square)
  ![Languages](https://img.shields.io/badge/多语言支持-中文%7C英文%7C德文%7C西班牙文%7C法文%7C日文%7C韩文%7C俄文-orange?style=flat-square)
  
  ![访问次数](https://count.getloli.com/@astral?name=astral-home&theme=original-new&padding=7&offset=0&align=top&scale=1&pixelated=1&darkmode=auto)
  
  ![Repobeats](https://repobeats.axiom.co/api/embed/c8f00565120b9bd12bd4e50050e44b3515acb1cb.svg "Repobeats analytics image")
</div>

Astral 是一个基于 EasyTier 的跨平台网络应用，提供简单易用的 P2P 网络连接和 VPN 服务。通过 Flutter 构建的现代化界面，让用户能够轻松创建和管理虚拟网络。

## ✨ 主要特性

- 🌐 **P2P 网络连接** - 基于 EasyTier 的去中心化网络架构
- 🔒 **VPN 服务** - 安全的虚拟专用网络连接
- 🖥️ **跨平台支持** - 全面支持多种操作系统和设备
  - 💻 **桌面平台**: Windows、macOS、Linux
  - 📱 **移动平台**: Android、iOS
- 🌍 **多语言支持** - 提供多种语言界面
- 🎨 **现代化界面** - 基于 Flutter 的美观用户界面
- ⚡ **高性能** - Rust 后端确保高效的网络处理
- 🔧 **易于配置** - 简单的房间和服务器管理

## 🚀 快速开始

> 详细的安装和使用指南请参考我们的[项目文档](#)

## 🛠️ 技术栈

- **前端**: Flutter (Dart)
- **后端**: Rust (EasyTier)
- **网络**: P2P、VPN、WireGuard

## 📦 功能说明

- **房间管理** - 创建和加入网络房间
- **服务器配置** - 配置和管理网络服务器
- **用户管理** - 查看和管理网络用户
- **网络设置** - 自定义网络参数和配置

## 🌍 多语言支持


| 语言 | 语言代码 | 文件 |
|------|---------|------|
| 🇨🇳 简体中文 | zh | [zh.json](assets/translations/zh.json) |
| 🇹🇼 繁体中文 | zh-TW | [zh-TW.json](assets/translations/zh-TW.json) |
| 🇺🇸 英语 | en | [en.json](assets/translations/en.json) |
| 🇩🇪 德语 | de | [de.json](assets/translations/de.json) |
| 🇪🇸 西班牙语 | es | [es.json](assets/translations/es.json) |
| 🇫🇷 法语 | fr | [fr.json](assets/translations/fr.json) |
| 🇯🇵 日语 | ja | [ja.json](assets/translations/ja.json) |
| 🇰🇷 韩语 | ko | [ko.json](assets/translations/ko.json) |
| 🇷🇺 俄语 | ru | [ru.json](assets/translations/ru.json) |


## 📄 开源许可协议

本作品采用 [知识共享署名-非商业性使用-禁止演绎 4.0 国际许可协议](https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode.zh-hans) 进行许可。

<div align="center">
  <a href="https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode.zh-hans" target="_blank">
    <img src="https://licensebuttons.net/l/by-nc-nd/4.0/88x31.png" alt="CC BY-NC-ND 4.0 许可协议">
  </a>
</div>

### 使用限制说明
⚠️ 本软件仅供学习和非商业用途使用，使用时需遵守以下条款：
- ❌ **禁止商业使用** - 不得将本软件用于任何商业目的
- ❌ **禁止修改软件名称** - 不得更改 "Astral" 软件名称以混淆身份或进行二次售卖
- ✅ **保留原作者信息** - 必须完整保留所有原作者的版权信息
- ✅ **遵循开源协议** - 严格遵守上述开源许可协议的全部条款

## 🙏 鸣谢

<div align="center">
  <p>感谢浪浪云提供云服务器赞助</p>
  <a href="https://langlangy.cn/" target="_blank">
    <img src="https://astral.fan/images/%E8%B5%9E%E5%8A%A9/logo%20(1).png" 
         style="width: 200px; max-width: 100%; height: auto; border-radius: 6px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);"
         alt="浪浪云赞助">
  </a>
</div>

## 💝 赞助支持

<div align="center">
  <h3>🌟 支持 Astral 的发展 🌟</h3>
  <p><strong>如果 Astral 为您带来便利，请考虑支持我们的开发工作！</strong></p>
  <a href="https://afdian.com/a/AstralGame" target="_blank">
    <img src="https://img.shields.io/badge/爱发电-支持我们-EA4AAA?style=for-the-badge&logo=github-sponsors&logoColor=white" alt="在爱发电支持我们" />
  </a>
  <p>您的每一份支持都将帮助我们创造更好的软件体验！</p>
</div>

### 联系与资源
- 🔗 **QQ群**：808169040
- 📚 **项目文档**：[astral.fan](https://astral.fan)
- 🌐 **语言支持**：如需帮助翻译或报告翻译问题，请参考[多语言支持](#-多语言支持-1)章节并通过QQ群联系我们


