/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.fluid;

import com.hbm.blocks.ModBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class VolcanicBlock
extends BlockFluidClassic {
    @SideOnly(value=Side.CLIENT)
    public static IIcon stillIcon;
    @SideOnly(value=Side.CLIENT)
    public static IIcon flowingIcon;

    public VolcanicBlock(Fluid fluid, Material material) {
        super(fluid, material);
        this.func_149675_a(true);
        this.setQuantaPerBlock(4);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? stillIcon : flowingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        stillIcon = register.func_94245_a("hbm:volcanic_lava_still");
        flowingIcon = register.func_94245_a("hbm:volcanic_lava_flowing");
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Block b = this.getReaction(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (b == null) continue;
            world.func_147465_d(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, b, b == ModBlocks.ore_basalt ? 3 : 0, 3);
        }
    }

    public Block getReaction(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.func_149688_o() == Material.field_151586_h) {
            return Blocks.field_150348_b;
        }
        if (b == Blocks.field_150364_r || b == Blocks.field_150363_s) {
            return ModBlocks.waste_log;
        }
        if (b == Blocks.field_150344_f) {
            return ModBlocks.waste_planks;
        }
        if (b == Blocks.field_150362_t || b == Blocks.field_150361_u) {
            return Blocks.field_150480_ab;
        }
        if (b == Blocks.field_150482_ag) {
            return ModBlocks.ore_basalt;
        }
        return null;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        int lavaCount = 0;
        int basaltCount = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Block b = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (b == this) {
                ++lavaCount;
            }
            if (b != this.getBasaltForCheck()) continue;
            ++basaltCount;
        }
        if (!world.field_72995_K && (!this.isSourceBlock((IBlockAccess)world, x, y, z) && lavaCount < 2 || rand.nextInt(5) == 0 && lavaCount < 5) && world.func_147439_a(x, y - 1, z) != this) {
            this.onSolidify(world, x, y, z, lavaCount, basaltCount, rand);
        }
    }

    public Block getBasaltForCheck() {
        return ModBlocks.basalt;
    }

    public void onSolidify(World world, int x, int y, int z, int lavaCount, int basaltCount, Random rand) {
        boolean canMakeGem;
        int r = rand.nextInt(200);
        Block above = world.func_147439_a(x, y + 10, z);
        boolean bl = canMakeGem = lavaCount + basaltCount == 6 && lavaCount < 3 && (above == ModBlocks.basalt || above == ModBlocks.volcanic_lava_block);
        if (r < 2) {
            world.func_147465_d(x, y, z, ModBlocks.ore_basalt, 0, 3);
        } else if (r == 2) {
            world.func_147465_d(x, y, z, ModBlocks.ore_basalt, 1, 3);
        } else if (r == 3) {
            world.func_147465_d(x, y, z, ModBlocks.ore_basalt, 2, 3);
        } else if (r == 4) {
            world.func_147465_d(x, y, z, ModBlocks.ore_basalt, 4, 3);
        } else if (r < 15 && canMakeGem) {
            world.func_147465_d(x, y, z, ModBlocks.ore_basalt, 3, 3);
        } else {
            world.func_147449_b(x, y, z, ModBlocks.basalt);
        }
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (Blocks.field_150480_ab.getFlammability(b) > 0) {
            return true;
        }
        if (b.isReplaceable(world, x, y, z)) {
            return true;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        return super.displaceIfPossible(world, x, y, z) || this.canDisplace((IBlockAccess)world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        double dz;
        double dy;
        double dx;
        if (world.func_147439_a(x, y + 1, z).func_149688_o() == Material.field_151579_a && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
            if (rand.nextInt(100) == 0) {
                dx = (float)x + rand.nextFloat();
                dy = (double)y + this.field_149756_F;
                dz = (float)z + rand.nextFloat();
                world.func_72869_a("lava", dx, dy, dz, 0.0, 0.0, 0.0);
                world.func_72980_b(dx, dy, dz, "liquid.lavapop", 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                world.func_72980_b((double)x, (double)y, (double)z, "liquid.lava", 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        if (rand.nextInt(10) == 0 && World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !world.func_147439_a(x, y - 2, z).func_149688_o().func_76230_c()) {
            dx = (float)x + rand.nextFloat();
            dy = (double)y - 1.05;
            dz = (float)z + rand.nextFloat();
            world.func_72869_a("dripLava", dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }
}

