/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import com.hbm.blocks.gas.BlockGasBase;
import com.hbm.interfaces.Untested;
import com.hbm.util.Compat;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGasFlammable
extends BlockGasBase {
    public static HashSet<Block> fireSources = new HashSet();

    public BlockGasFlammable() {
        super(0.8f, 0.8f, 0.2f);
        if (fireSources.isEmpty()) {
            Block stoneTorch;
            fireSources.add((Block)Blocks.field_150480_ab);
            fireSources.add(Blocks.field_150353_l);
            fireSources.add(Blocks.field_150478_aa);
            fireSources.add(Blocks.field_150428_aP);
            if (Compat.isModLoaded("TConstruct") && (stoneTorch = Compat.tryLoadBlock("TConstruct", "decoration.stonetorch")) != null) {
                fireSources.add(stoneTorch);
            }
        }
    }

    @Override
    public ForgeDirection getFirstDirection(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(3) == 0) {
            return ForgeDirection.getOrientation((int)world.field_73012_v.nextInt(2));
        }
        return this.randomHorizontal(world);
    }

    @Override
    public ForgeDirection getSecondDirection(World world, int x, int y, int z) {
        return this.randomHorizontal(world);
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Block b = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                if (!this.isFireSource(b)) continue;
                this.combust(world, x, y, z);
                return;
            }
            if (rand.nextInt(20) == 0 && world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a) {
                world.func_147468_f(x, y, z);
                return;
            }
        }
        super.func_149674_a(world, x, y, z, rand);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity.func_70027_ad()) {
            this.combust(world, x, y, z);
        }
    }

    @Override
    @Untested
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Block b = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (!this.isFireSource(b)) continue;
            world.func_147464_a(x, y, z, (Block)this, 2);
        }
    }

    protected void combust(World world, int x, int y, int z) {
        world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
    }

    public boolean isFireSource(Block b) {
        return fireSources.contains(b);
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    @Override
    public int getDelay(World world) {
        return world.field_73012_v.nextInt(5) + 16;
    }
}

