/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.IBlockSideRotation;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.i18n.I18nUtil;
import com.hbm.world.gen.nbt.INBTBlockTransformable;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Keyboard;

public class BlockWandJigsaw
extends BlockContainer
implements IBlockSideRotation,
INBTBlockTransformable,
IGUIProvider,
ILookOverlay {
    private IIcon iconTop;
    private IIcon iconSide;
    private IIcon iconBack;

    public BlockWandJigsaw() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWandJigsaw();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, l, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("hbm:wand_jigsaw");
        this.iconTop = iconRegister.func_94245_a("hbm:wand_jigsaw_top");
        this.iconSide = iconRegister.func_94245_a("hbm:wand_jigsaw_side");
        this.iconBack = iconRegister.func_94245_a("hbm:wand_jigsaw_back");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == meta) {
            return this.field_149761_L;
        }
        if (IBlockSideRotation.isOpposite(side, meta)) {
            return this.iconBack;
        }
        if (side <= 1) {
            return this.iconTop;
        }
        if (side > 3 && meta <= 1) {
            return this.iconTop;
        }
        return this.iconSide;
    }

    @Override
    public int getRotationFromSide(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 0) {
            return IBlockSideRotation.topToBottom(this.getRotationFromSide(world, x, y, z, 1));
        }
        int meta = world.func_72805_g(x, y, z);
        if (side == meta || IBlockSideRotation.isOpposite(side, meta)) {
            return 0;
        }
        if (meta == 0) {
            return 0;
        }
        if (meta == 1) {
            return 3;
        }
        if (side == 1) {
            switch (meta) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
            }
        }
        if (meta == 2) {
            return side == 4 ? 2 : 1;
        }
        if (meta == 3) {
            return side == 4 ? 1 : 2;
        }
        if (meta == 4) {
            return side == 2 ? 1 : 2;
        }
        if (meta == 5) {
            return side == 2 ? 2 : 1;
        }
        return 0;
    }

    public int func_149645_b() {
        return IBlockSideRotation.getRenderType();
    }

    @Override
    public int transformMeta(int meta, int coordBaseMode) {
        return INBTBlockTransformable.transformMetaDeco(meta, coordBaseMode);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandJigsaw)) {
            return false;
        }
        TileEntityWandJigsaw jigsaw = (TileEntityWandJigsaw)te;
        if (!player.func_70093_af()) {
            Block block = this.getBlock(world, player.func_70694_bm());
            if (block == ModBlocks.wand_air) {
                block = Blocks.field_150350_a;
            }
            if (block != null && block != ModBlocks.wand_jigsaw && block != ModBlocks.wand_loot) {
                jigsaw.replaceBlock = block;
                jigsaw.replaceMeta = player.func_70694_bm().func_77960_j();
                return true;
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.wand_s) {
                return false;
            }
            if (world.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            }
            return true;
        }
        return false;
    }

    private Block getBlock(World world, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        return ((ItemBlock)stack.func_77973_b()).field_150939_a;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiWandJigsaw((TileEntityWandJigsaw)world.func_147438_o(x, y, z));
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandJigsaw)) {
            return;
        }
        TileEntityWandJigsaw jigsaw = (TileEntityWandJigsaw)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.GRAY + "Target pool: " + EnumChatFormatting.RESET + jigsaw.pool);
        text.add(EnumChatFormatting.GRAY + "Name: " + EnumChatFormatting.RESET + jigsaw.name);
        text.add(EnumChatFormatting.GRAY + "Target name: " + EnumChatFormatting.RESET + jigsaw.target);
        text.add(EnumChatFormatting.GRAY + "Turns into: " + EnumChatFormatting.RESET + GameRegistry.findUniqueIdentifierFor((Block)jigsaw.replaceBlock).toString());
        text.add(EnumChatFormatting.GRAY + "   with meta: " + EnumChatFormatting.RESET + jigsaw.replaceMeta);
        text.add(EnumChatFormatting.GRAY + "Selection/Placement priority: " + EnumChatFormatting.RESET + jigsaw.selectionPriority + "/" + jigsaw.placementPriority);
        text.add(EnumChatFormatting.GRAY + "Joint type: " + EnumChatFormatting.RESET + (jigsaw.isRollable ? "Rollable" : "Aligned"));
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public static class GuiWandJigsaw
    extends GuiScreen {
        private final TileEntityWandJigsaw jigsaw;
        private GuiTextField textPool;
        private GuiTextField textName;
        private GuiTextField textTarget;
        private GuiTextField textSelectionPriority;
        private GuiTextField textPlacementPriority;
        private GuiButton jointToggle;

        public GuiWandJigsaw(TileEntityWandJigsaw jigsaw) {
            this.jigsaw = jigsaw;
        }

        public void func_73866_w_() {
            Keyboard.enableRepeatEvents((boolean)true);
            this.textPool = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 50, 300, 20);
            this.textPool.func_146180_a(this.jigsaw.pool);
            this.textName = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 100, 140, 20);
            this.textName.func_146180_a(this.jigsaw.name);
            this.textTarget = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 + 10, 100, 140, 20);
            this.textTarget.func_146180_a(this.jigsaw.target);
            this.textSelectionPriority = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 150, 90, 20);
            this.textSelectionPriority.func_146180_a("" + this.jigsaw.selectionPriority);
            this.textPlacementPriority = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 40, 150, 90, 20);
            this.textPlacementPriority.func_146180_a("" + this.jigsaw.placementPriority);
            this.jointToggle = new GuiButton(0, this.field_146294_l / 2 + 60, 150, 90, 20, this.jigsaw.isRollable ? "Rollable" : "Aligned");
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            this.func_73731_b(this.field_146289_q, "Target pool:", this.field_146294_l / 2 - 150, 37, 0xA0A0A0);
            this.textPool.func_146194_f();
            this.func_73731_b(this.field_146289_q, "Name:", this.field_146294_l / 2 - 150, 87, 0xA0A0A0);
            this.textName.func_146194_f();
            this.func_73731_b(this.field_146289_q, "Target name:", this.field_146294_l / 2 + 10, 87, 0xA0A0A0);
            this.textTarget.func_146194_f();
            this.func_73731_b(this.field_146289_q, "Selection priority:", this.field_146294_l / 2 - 150, 137, 0xA0A0A0);
            this.textSelectionPriority.func_146194_f();
            this.func_73731_b(this.field_146289_q, "Placement priority:", this.field_146294_l / 2 - 40, 137, 0xA0A0A0);
            this.textPlacementPriority.func_146194_f();
            this.func_73731_b(this.field_146289_q, "Joint type:", this.field_146294_l / 2 + 60, 137, 0xA0A0A0);
            this.jointToggle.func_146112_a(this.field_146297_k, mouseX, mouseY);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        public void func_146281_b() {
            Keyboard.enableRepeatEvents((boolean)false);
            NBTTagCompound data = new NBTTagCompound();
            this.jigsaw.func_145841_b(data);
            data.func_74778_a("pool", this.textPool.func_146179_b());
            data.func_74778_a("name", this.textName.func_146179_b());
            data.func_74778_a("target", this.textTarget.func_146179_b());
            try {
                data.func_74768_a("selection", Integer.parseInt(this.textSelectionPriority.func_146179_b()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                data.func_74768_a("placement", Integer.parseInt(this.textPlacementPriority.func_146179_b()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            data.func_74757_a("roll", this.jointToggle.field_146126_j == "Rollable");
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.jigsaw.field_145851_c, this.jigsaw.field_145848_d, this.jigsaw.field_145849_e));
        }

        protected void func_73869_a(char typedChar, int keyCode) {
            super.func_73869_a(typedChar, keyCode);
            this.textPool.func_146201_a(typedChar, keyCode);
            this.textName.func_146201_a(typedChar, keyCode);
            this.textTarget.func_146201_a(typedChar, keyCode);
            this.textSelectionPriority.func_146201_a(typedChar, keyCode);
            this.textPlacementPriority.func_146201_a(typedChar, keyCode);
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            this.textPool.func_146192_a(mouseX, mouseY, mouseButton);
            this.textName.func_146192_a(mouseX, mouseY, mouseButton);
            this.textTarget.func_146192_a(mouseX, mouseY, mouseButton);
            this.textSelectionPriority.func_146192_a(mouseX, mouseY, mouseButton);
            this.textPlacementPriority.func_146192_a(mouseX, mouseY, mouseButton);
            if (this.jointToggle.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                System.out.println("displayString: " + this.jointToggle.field_146126_j);
                this.jointToggle.field_146126_j = this.jointToggle.field_146126_j == "Rollable" ? "Aligned" : "Rollable";
            }
        }
    }

    public static class TileEntityWandJigsaw
    extends TileEntityLoadedBase
    implements IControlReceiver {
        private int selectionPriority = 0;
        private int placementPriority = 0;
        private String pool = "default";
        private String name = "default";
        private String target = "default";
        private Block replaceBlock = Blocks.field_150350_a;
        private int replaceMeta = 0;
        private boolean isRollable = true;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                this.networkPackNT(15);
            }
        }

        @Override
        public void serialize(ByteBuf buf) {
            buf.writeInt(this.selectionPriority);
            buf.writeInt(this.placementPriority);
            BufferUtil.writeString(buf, this.pool);
            BufferUtil.writeString(buf, this.name);
            BufferUtil.writeString(buf, this.target);
            buf.writeInt(Block.func_149682_b((Block)this.replaceBlock));
            buf.writeInt(this.replaceMeta);
            buf.writeBoolean(this.isRollable);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.selectionPriority = buf.readInt();
            this.placementPriority = buf.readInt();
            this.pool = BufferUtil.readString(buf);
            this.name = BufferUtil.readString(buf);
            this.target = BufferUtil.readString(buf);
            this.replaceBlock = Block.func_149729_e((int)buf.readInt());
            this.replaceMeta = buf.readInt();
            this.isRollable = buf.readBoolean();
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("direction", this.func_145832_p());
            nbt.func_74768_a("selection", this.selectionPriority);
            nbt.func_74768_a("placement", this.placementPriority);
            nbt.func_74778_a("pool", this.pool);
            nbt.func_74778_a("name", this.name);
            nbt.func_74778_a("target", this.target);
            nbt.func_74778_a("block", GameRegistry.findUniqueIdentifierFor((Block)this.replaceBlock).toString());
            nbt.func_74768_a("meta", this.replaceMeta);
            nbt.func_74757_a("roll", this.isRollable);
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.selectionPriority = nbt.func_74762_e("selection");
            this.placementPriority = nbt.func_74762_e("placement");
            this.pool = nbt.func_74779_i("pool");
            this.name = nbt.func_74779_i("name");
            this.target = nbt.func_74779_i("target");
            this.replaceBlock = Block.func_149684_b((String)nbt.func_74779_i("block"));
            this.replaceMeta = nbt.func_74762_e("meta");
            this.isRollable = nbt.func_74767_n("roll");
        }

        @Override
        public boolean hasPermission(EntityPlayer player) {
            return true;
        }

        @Override
        public void receiveControl(NBTTagCompound nbt) {
            this.func_145839_a(nbt);
            this.func_70296_d();
        }
    }
}

