/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.redstoneoverradio.IRORValueProvider;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.IPersistentInfoProvider;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.CompatHandler;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class MachineCapacitor
extends BlockContainer
implements ILookOverlay,
IPersistentInfoProvider,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconInnerTop;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconInnerSide;
    protected long power;
    String name;
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public MachineCapacitor(Material mat, long power, String name) {
        super(mat);
        this.power = power;
        this.name = name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconTop = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_top");
        this.iconSide = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_side");
        this.iconBottom = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_bottom");
        this.iconInnerTop = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_inner_top");
        this.iconInnerSide = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_inner_side");
    }

    public int func_149645_b() {
        return renderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float fX, float fY, float fZ, int meta) {
        return side;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCapacitor(this.power);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCapacitor)) {
            return;
        }
        TileEntityCapacitor battery = (TileEntityCapacitor)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(BobMathUtil.getShortNumber(battery.getPower()) + " / " + BobMathUtil.getShortNumber(battery.getMaxPower()) + "HE");
        double percent = (double)battery.getPower() / (double)battery.getMaxPower();
        int charge = (int)Math.floor(percent * 10000.0);
        int color = (int)(255.0 - 255.0 * percent) << 16 | (int)(255.0 * percent) << 8;
        text.add("&[" + color + "&]" + (double)charge / 100.0 + "%");
        text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + "+" + BobMathUtil.getShortNumber(battery.powerReceived) + "HE/t");
        text.add(EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + "-" + BobMathUtil.getShortNumber(battery.powerSent) + "HE/t");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, NBTTagCompound persistentTag, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.GOLD + "Stores up to " + BobMathUtil.getShortNumber(this.power) + "HE");
        list.add(EnumChatFormatting.GOLD + "Charge speed: " + BobMathUtil.getShortNumber(this.power / 200L) + "HE");
        list.add(EnumChatFormatting.GOLD + "Discharge speed: " + BobMathUtil.getShortNumber(this.power / 600L) + "HE");
        list.add(EnumChatFormatting.YELLOW + "" + BobMathUtil.getShortNumber(persistentTag.func_74763_f("power")) + "/" + BobMathUtil.getShortNumber(persistentTag.func_74763_f("maxPower")) + "HE");
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        if (Keyboard.isKeyDown((int)42)) {
            for (String s : I18nUtil.resolveKeyArray("tile.capacitor.desc", new Object[0])) {
                list.add(EnumChatFormatting.YELLOW + s);
            }
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "Hold <" + EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + "LSHIFT" + EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "> to display more info");
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return IPersistentNBT.getDrops(world, x, y, z, (Block)this);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        IPersistentNBT.restoreData(world, x, y, z, itemStack);
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.harvesters.set(player);
            this.func_149697_b(world, x, y, z, meta, 0);
            this.harvesters.set(null);
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[MachineCapacitor.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
    }

    @Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
    public static class TileEntityCapacitor
    extends TileEntityLoadedBase
    implements IEnergyProviderMK2,
    IEnergyReceiverMK2,
    IPersistentNBT,
    IRORValueProvider,
    SimpleComponent,
    CompatHandler.OCComponent {
        public long power;
        protected long maxPower;
        public long powerReceived;
        public long powerSent;
        public long lastPowerReceived;
        public long lastPowerSent;

        public TileEntityCapacitor() {
        }

        public TileEntityCapacitor(long maxPower) {
            this.maxPower = maxPower;
        }

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                ForgeDirection opp = ForgeDirection.getOrientation((int)this.func_145832_p());
                ForgeDirection dir = opp.getOpposite();
                BlockPos pos = new BlockPos(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                boolean didStep = false;
                ForgeDirection last = null;
                while (this.field_145850_b.func_147439_a(pos.getX(), pos.getY(), pos.getZ()) == ModBlocks.capacitor_bus) {
                    ForgeDirection current = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(pos.getX(), pos.getY(), pos.getZ()));
                    if (!didStep) {
                        last = current;
                    }
                    didStep = true;
                    if (last != current) {
                        pos = null;
                        break;
                    }
                    pos = pos.offset(current);
                }
                if (pos != null && last != null) {
                    this.tryUnsubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ());
                    this.tryProvide(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), last);
                }
                this.trySubscribe(this.field_145850_b, this.field_145851_c + opp.offsetX, this.field_145848_d + opp.offsetY, this.field_145849_e + opp.offsetZ, opp);
                this.networkPackNT(15);
                this.lastPowerSent = this.powerSent;
                this.lastPowerReceived = this.powerReceived;
                this.powerSent = 0L;
                this.powerReceived = 0L;
            }
        }

        @Override
        public void serialize(ByteBuf buf) {
            buf.writeLong(this.power);
            buf.writeLong(this.maxPower);
            buf.writeLong(this.powerReceived);
            buf.writeLong(this.powerSent);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.power = buf.readLong();
            this.maxPower = buf.readLong();
            this.powerReceived = buf.readLong();
            this.powerSent = buf.readLong();
        }

        @Override
        public long transferPower(long power) {
            if (power + this.getPower() <= this.getMaxPower()) {
                this.setPower(power + this.getPower());
                this.powerReceived += power;
                return 0L;
            }
            long capacity = this.getMaxPower() - this.getPower();
            long overshoot = power - capacity;
            this.powerReceived += this.getMaxPower() - this.getPower();
            this.setPower(this.getMaxPower());
            return overshoot;
        }

        @Override
        public void usePower(long power) {
            this.powerSent += Math.min(this.getPower(), power);
            this.setPower(this.getPower() - power);
        }

        @Override
        public long getPower() {
            return this.power;
        }

        @Override
        public long getMaxPower() {
            return this.maxPower;
        }

        @Override
        public long getProviderSpeed() {
            return this.getMaxPower() / 300L;
        }

        @Override
        public long getReceiverSpeed() {
            return this.getMaxPower() / 100L;
        }

        @Override
        public IEnergyReceiverMK2.ConnectionPriority getPriority() {
            return IEnergyReceiverMK2.ConnectionPriority.LOW;
        }

        @Override
        public void setPower(long power) {
            this.power = power;
        }

        @Override
        public boolean canConnect(ForgeDirection dir) {
            return dir == ForgeDirection.getOrientation((int)this.func_145832_p());
        }

        @Override
        public void writeNBT(NBTTagCompound nbt) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74772_a("maxPower", this.maxPower);
            nbt.func_74782_a("persistent", (NBTBase)data);
        }

        @Override
        public void readNBT(NBTTagCompound nbt) {
            NBTTagCompound data = nbt.func_74775_l("persistent");
            this.power = data.func_74763_f("power");
            this.maxPower = data.func_74763_f("maxPower");
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.power = nbt.func_74763_f("power");
            this.maxPower = nbt.func_74763_f("maxPower");
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74772_a("power", this.power);
            nbt.func_74772_a("maxPower", this.maxPower);
        }

        @Override
        public String[] getFunctionInfo() {
            return new String[]{"VAL:fill", "VAL:fillpercent"};
        }

        @Override
        public String provideRORValue(String name) {
            if ("VAL:fill".equals(name)) {
                return "" + this.power;
            }
            if ("VAL:fillpercent".equals(name)) {
                return "" + this.power * 100L / this.maxPower;
            }
            return null;
        }

        @Override
        @Optional.Method(modid="OpenComputers")
        public String getComponentName() {
            return "capacitor";
        }

        @Callback(direct=true)
        @Optional.Method(modid="OpenComputers")
        public Object[] getEnergy(Context context, Arguments args) {
            return new Object[]{this.power};
        }

        @Callback(direct=true)
        @Optional.Method(modid="OpenComputers")
        public Object[] getMaxEnergy(Context context, Arguments args) {
            return new Object[]{this.maxPower};
        }

        @Callback(direct=true)
        @Optional.Method(modid="OpenComputers")
        public Object[] getEnergySent(Context context, Arguments args) {
            return new Object[]{this.lastPowerReceived};
        }

        @Callback(direct=true)
        @Optional.Method(modid="OpenComputers")
        public Object[] getEnergyReceived(Context context, Arguments args) {
            return new Object[]{this.lastPowerSent};
        }

        @Callback(direct=true)
        @Optional.Method(modid="OpenComputers")
        public Object[] getInfo(Context context, Arguments args) {
            return new Object[]{this.power, this.maxPower, this.lastPowerReceived, this.lastPowerSent};
        }

        @Override
        @Optional.Method(modid="OpenComputers")
        public String[] methods() {
            return new String[]{"getEnergy", "getMaxEnergy", "getEnergySent", "getEnergyReceived", "getInfo"};
        }

        @Override
        @Optional.Method(modid="OpenComputers")
        public Object[] invoke(String method, Context context, Arguments args) throws Exception {
            switch (method) {
                case "getEnergy": {
                    return this.getEnergy(context, args);
                }
                case "getMaxEnergy": {
                    return this.getMaxEnergy(context, args);
                }
                case "getEnergySent": {
                    return this.getEnergySent(context, args);
                }
                case "getEnergyReceived": {
                    return this.getEnergyReceived(context, args);
                }
                case "getInfo": {
                    return this.getEnergyReceived(context, args);
                }
            }
            throw new NoSuchMethodException();
        }
    }
}

