/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.conveyor.IConveyorItem;
import api.hbm.conveyor.IConveyorPackage;
import api.hbm.conveyor.IEnterableBlock;
import com.hbm.blocks.network.BlockCraneBase;
import com.hbm.blocks.network.CraneInserter;
import com.hbm.tileentity.network.TileEntityCraneBase;
import com.hbm.tileentity.network.TileEntityCraneUnboxer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CraneUnboxer
extends BlockCraneBase
implements IEnterableBlock {
    public CraneUnboxer() {
        super(Material.field_151573_f);
    }

    @Override
    public TileEntityCraneBase createNewTileEntity(World world, int meta) {
        return new TileEntityCraneUnboxer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconOut = iconRegister.func_94245_a("hbm:crane_box");
        this.iconSideOut = iconRegister.func_94245_a("hbm:crane_side_box");
        this.iconDirectional = iconRegister.func_94245_a("hbm:crane_unboxer_top");
        this.iconDirectionalUp = iconRegister.func_94245_a("hbm:crane_unboxer_side_down");
        this.iconDirectionalDown = iconRegister.func_94245_a("hbm:crane_unboxer_side_up");
        this.iconDirectionalTurnLeft = iconRegister.func_94245_a("hbm:crane_unboxer_top_right");
        this.iconDirectionalTurnRight = iconRegister.func_94245_a("hbm:crane_unboxer_top_left");
        this.iconDirectionalSideLeftTurnUp = iconRegister.func_94245_a("hbm:crane_unboxer_side_up_turn_left");
        this.iconDirectionalSideRightTurnUp = iconRegister.func_94245_a("hbm:crane_unboxer_side_up_turn_right");
        this.iconDirectionalSideLeftTurnDown = iconRegister.func_94245_a("hbm:crane_unboxer_side_down_turn_left");
        this.iconDirectionalSideRightTurnDown = iconRegister.func_94245_a("hbm:crane_unboxer_side_down_turn_right");
        this.iconDirectionalSideUpTurnLeft = iconRegister.func_94245_a("hbm:crane_unboxer_side_left_turn_up");
        this.iconDirectionalSideUpTurnRight = iconRegister.func_94245_a("hbm:crane_unboxer_side_right_turn_up");
        this.iconDirectionalSideDownTurnLeft = iconRegister.func_94245_a("hbm:crane_unboxer_side_left_turn_down");
        this.iconDirectionalSideDownTurnRight = iconRegister.func_94245_a("hbm:crane_unboxer_side_right_turn_down");
    }

    @Override
    public int getRotationFromSide(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 1 && side == 1) {
            ForgeDirection leftHandDirection = this.getOutputSide(world, x, y, z).getRotation(this.getInputSide(world, x, y, z));
            if (leftHandDirection == ForgeDirection.UP) {
                if (meta == 2) {
                    return 2;
                }
                if (meta == 3) {
                    return 1;
                }
                if (meta == 4) {
                    return 3;
                }
                if (meta == 5) {
                    return 0;
                }
            }
            if (leftHandDirection == ForgeDirection.DOWN) {
                if (meta == 2) {
                    return 1;
                }
                if (meta == 3) {
                    return 2;
                }
                if (meta == 4) {
                    return 0;
                }
                if (meta == 5) {
                    return 3;
                }
            }
            if (meta == 2) {
                return 0;
            }
            if (meta == 3) {
                return 3;
            }
            if (meta == 4) {
                return 2;
            }
            if (meta == 5) {
                return 1;
            }
        }
        return 0;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.dropContents(world, x, y, z, block, meta, 0, 23);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @Override
    public boolean canItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        return false;
    }

    @Override
    public void onItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
    }

    @Override
    public boolean canPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
        return this.getOutputSide((IBlockAccess)world, x, y, z) == dir;
    }

    @Override
    public void onPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
        TileEntityCraneUnboxer unboxer = (TileEntityCraneUnboxer)world.func_147438_o(x, y, z);
        ForgeDirection accessedSide = this.getOutputSide((IBlockAccess)world, x, y, z).getOpposite();
        for (ItemStack stack : entity.getItemStacks()) {
            ItemStack remainder = CraneInserter.addToInventory((IInventory)unboxer, unboxer.func_94128_d(accessedSide.ordinal()), stack, accessedSide.ordinal());
            if (remainder == null || remainder.field_77994_a <= 0) continue;
            EntityItem drop = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, remainder.func_77946_l());
            world.func_72838_d((Entity)drop);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return Container.func_94526_b((IInventory)((TileEntityCraneUnboxer)world.func_147438_o(x, y, z)));
    }
}

