/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.itempool.ItemPool;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;

public class ItemPoolConfigJSON {
    public static final Gson gson = new Gson();

    public static void initialize() {
        ItemPool.initialize();
        File folder = MainRegistry.configHbmDir;
        File config = new File(folder.getAbsolutePath() + File.separatorChar + "hbmItemPools.json");
        File template = new File(folder.getAbsolutePath() + File.separatorChar + "_hbmItemPools.json");
        if (!config.exists()) {
            ItemPoolConfigJSON.writeDefault(template);
        } else {
            ItemPoolConfigJSON.readConfig(config);
        }
    }

    private static void writeDefault(File file) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("description").value("Format is as follows: First object is an array representing the itemstack in question, same rules apply here as they do for recipe configs but with one difference: Stacks accept NBT. NBT is contained in {curly brackets}, the format is the same as it is for the /give command. After the stack comes the minimum amount of items, then the maximum (the stack's own stacksize value is ignored). The final number is the weight, an item with a weight of 3 is 3x as likely to appear than an item with a weight of 1.");
            writer.name("pools").beginObject();
            for (Map.Entry<String, ItemPool> entry : ItemPool.pools.entrySet()) {
                writer.name(entry.getKey()).beginArray();
                for (WeightedRandomChestContent content : entry.getValue().pool) {
                    writer.setIndent("  ");
                    writer.beginArray();
                    writer.setIndent("");
                    ItemPoolConfigJSON.writeItemStack(content.field_76297_b, writer);
                    writer.setIndent("");
                    writer.value((long)content.field_76295_d);
                    writer.value((long)content.field_76296_e);
                    writer.value((long)content.field_76292_a);
                    writer.endArray();
                }
                writer.setIndent("  ");
                writer.endArray();
            }
            writer.endObject();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readConfig(File file) {
        HashMap<String, ItemPool> newPools = new HashMap<String, ItemPool>();
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            JsonObject pools = json.get("pools").getAsJsonObject();
            for (Map.Entry entry : pools.entrySet()) {
                String poolName = (String)entry.getKey();
                ItemPool pool = new ItemPool();
                pool.name = poolName;
                for (JsonElement poolEntry : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    JsonArray array = poolEntry.getAsJsonArray();
                    ItemStack stack = ItemPoolConfigJSON.readItemStack(array.get(0).getAsJsonArray());
                    int min = array.get(1).getAsInt();
                    int max = array.get(2).getAsInt();
                    int weight = array.get(3).getAsInt();
                    pool.add(stack, min, max, weight);
                }
                pool.build();
                newPools.put(poolName, pool);
            }
            ItemPool.pools = newPools;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void writeItemStack(ItemStack stack, JsonWriter writer) throws IOException {
        writer.beginArray();
        writer.setIndent("");
        writer.value(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        if (stack.field_77994_a != 1 || stack.func_77960_j() != 0 || stack.func_77942_o()) {
            writer.value((long)stack.field_77994_a);
        }
        if (stack.func_77960_j() != 0 || stack.func_77942_o()) {
            writer.value((long)stack.func_77960_j());
        }
        if (stack.func_77942_o()) {
            writer.value(stack.field_77990_d.toString());
        }
        writer.endArray();
        writer.setIndent("  ");
    }

    public static ItemStack readItemStack(JsonArray array) {
        try {
            int meta;
            Item item = (Item)Item.field_150901_e.func_82594_a(array.get(0).getAsString());
            int stacksize = array.size() > 1 ? array.get(1).getAsInt() : 1;
            int n = meta = array.size() > 2 ? array.get(2).getAsInt() : 0;
            if (item != null) {
                String tag;
                NBTBase nbt;
                ItemStack stack = new ItemStack(item, stacksize, meta);
                if (array.size() > 3 && (nbt = JsonToNBT.func_150315_a((String)(tag = array.get(3).getAsString()))) instanceof NBTTagCompound) {
                    stack.field_77990_d = (NBTTagCompound)nbt;
                }
                return stack;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainRegistry.logger.error("Error reading stack array " + array.toString() + " - defaulting to NOTHING item!");
        return new ItemStack(ModItems.nothing);
    }
}

