/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.interfaces.NotableComments;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.TileMappings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;

@NotableComments
public class MachineDynConfig {
    public static final Gson gson = new Gson();

    public static void initialize() {
        File dir = new File(MainRegistry.configDir.getAbsolutePath() + File.separatorChar + "hbmConfig");
        if (!dir.exists() && !dir.mkdir()) {
            throw new IllegalStateException("Unable to make recipe directory " + dir.getAbsolutePath());
        }
        ArrayList dummies = new ArrayList();
        TileMappings.configurables.forEach(x -> {
            try {
                dummies.add(x.newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        File file = new File(dir.getAbsolutePath() + File.separatorChar + "hbmMachines.json");
        try {
            if (file.exists()) {
                JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
                for (IConfigurableMachine dummy : dummies) {
                    try {
                        JsonElement element = json.get(dummy.getConfigName());
                        JsonObject obj = element != null ? element.getAsJsonObject() : new JsonObject();
                        dummy.readIfPresent(obj);
                    }
                    catch (Exception exception) {}
                }
            }
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("info").beginArray();
            for (String line : MachineDynConfig.getComment()) {
                writer.value(line);
            }
            writer.endArray();
            for (IConfigurableMachine dummy : dummies) {
                try {
                    writer.name(dummy.getConfigName()).beginObject();
                    dummy.writeConfig(writer);
                    writer.endObject();
                }
                catch (Exception exception) {}
            }
            writer.endObject();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String[] getComment() {
        return new String[]{"Unlike other JSON configs, this one does not use a variable amount of options (like recipes), rather all config options are fixed.", "This means that there is no distinction between template and used config, you can simply edit this file and it will use the new values.", "If you wish to reset one or multiple values to default, simply delete them, the file is re-created every time the game starts (but changed values persist!)", "How this works in detail:", "- Machines have default values on init", "- The config system will try to read the config file. It will replace the default values where applicable, and keep them when an option is missing.", "- The config system will then use the full set of values - configured or default if missing - and re-create the config file to include any missing entries.", "This final step also means that any custom non-config values added to the JSON, while not causing errors, will be deleted when the config is re-created.", "It also means that should an update add more values to an existing machines, those will be retroactively added to the config using the default value."};
    }
}

