/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.handler.ability.IBaseAbility;
import com.hbm.handler.ability.IToolAreaAbility;
import com.hbm.handler.ability.IToolHarvestAbility;
import com.hbm.handler.ability.IWeaponAbility;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.EnumChatFormatting;

public class AvailableAbilities {
    private HashMap<IBaseAbility, Integer> abilities = new HashMap();

    public AvailableAbilities addAbility(IBaseAbility ability, int level) {
        if (level < 0 || level >= ability.levels()) {
            MainRegistry.logger.warn("Illegal level " + level + " for ability " + ability.getName());
            level = ability.levels() - 1;
        }
        if (this.abilities.containsKey(ability)) {
            MainRegistry.logger.warn("Ability " + ability.getName() + " already had level " + this.abilities.get(ability) + ", overwriting with level " + level);
        }
        if (ability.isAllowed()) {
            this.abilities.put(ability, level);
        }
        return this;
    }

    public AvailableAbilities addToolAbilities() {
        this.addAbility(IToolAreaAbility.NONE, 0);
        this.addAbility(IToolHarvestAbility.NONE, 0);
        return this;
    }

    public AvailableAbilities removeAbility(IBaseAbility ability) {
        this.abilities.remove(ability);
        return this;
    }

    public boolean supportsAbility(IBaseAbility ability) {
        return this.abilities.containsKey(ability);
    }

    public int maxLevel(IBaseAbility ability) {
        return this.abilities.getOrDefault(ability, -1);
    }

    public Map<IBaseAbility, Integer> get() {
        return Collections.unmodifiableMap(this.abilities);
    }

    public Map<IWeaponAbility, Integer> getWeaponAbilities() {
        return this.abilities.keySet().stream().filter(a -> a instanceof IWeaponAbility).collect(Collectors.toMap(a -> (IWeaponAbility)a, a -> this.abilities.get(a)));
    }

    public Map<IBaseAbility, Integer> getToolAbilities() {
        return this.abilities.keySet().stream().filter(a -> a instanceof IToolAreaAbility || a instanceof IToolHarvestAbility).collect(Collectors.toMap(a -> a, a -> this.abilities.get(a)));
    }

    public Map<IToolAreaAbility, Integer> getToolAreaAbilities() {
        return this.abilities.keySet().stream().filter(a -> a instanceof IToolAreaAbility).collect(Collectors.toMap(a -> (IToolAreaAbility)a, a -> this.abilities.get(a)));
    }

    public Map<IToolHarvestAbility, Integer> getToolHarvestAbilities() {
        return this.abilities.keySet().stream().filter(a -> a instanceof IToolHarvestAbility).collect(Collectors.toMap(a -> (IToolHarvestAbility)a, a -> this.abilities.get(a)));
    }

    public int size() {
        return this.abilities.size();
    }

    public boolean isEmpty() {
        return this.abilities.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List list) {
        List<Map.Entry> weaponAbilities;
        List<Map.Entry> toolAbilities = this.abilities.entrySet().stream().filter(entry -> entry.getKey() instanceof IToolAreaAbility && entry.getKey() != IToolAreaAbility.NONE || entry.getKey() instanceof IToolHarvestAbility && entry.getKey() != IToolHarvestAbility.NONE).sorted(Comparator.comparing(Map.Entry::getKey).thenComparing(Map.Entry::getValue)).collect(Collectors.toList());
        if (!toolAbilities.isEmpty()) {
            list.add("Abilities: ");
            toolAbilities.forEach(entry -> {
                IBaseAbility ability = (IBaseAbility)entry.getKey();
                int level = (Integer)entry.getValue();
                list.add("  " + EnumChatFormatting.GOLD + ability.getFullName(level));
            });
            list.add("Right click to cycle through presets!");
            list.add("Sneak-click to go to first preset!");
            list.add("Alt-click to open customization GUI!");
        }
        if (!(weaponAbilities = this.abilities.entrySet().stream().filter(entry -> entry.getKey() instanceof IWeaponAbility && entry.getKey() != IWeaponAbility.NONE).sorted(Comparator.comparing(Map.Entry::getKey).thenComparing(Map.Entry::getValue)).collect(Collectors.toList())).isEmpty()) {
            list.add("Weapon modifiers: ");
            weaponAbilities.forEach(entry -> {
                IBaseAbility ability = (IBaseAbility)entry.getKey();
                int level = (Integer)entry.getValue();
                list.add("  " + EnumChatFormatting.RED + ability.getFullName(level));
            });
        }
    }
}

