/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import com.hbm.handler.nei.NEIUniversalHandler;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.machine.ItemRBMKRod;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RBMKRodDisassemblyHandler
extends NEIUniversalHandler {
    public RBMKRodDisassemblyHandler() {
        super("RBMK Rod Disassembly", Blocks.field_150462_ai, RBMKRodDisassemblyHandler.getRecipes());
    }

    @Override
    public String getKey() {
        return "ntmRBMKDisassembly";
    }

    public static HashMap<RecipesCommon.ComparableStack, ItemStack> getRecipes() {
        HashMap<RecipesCommon.ComparableStack, ItemStack> map = new HashMap<RecipesCommon.ComparableStack, ItemStack>();
        for (ItemRBMKRod rod : ItemRBMKRod.craftableRods) {
            for (int enrichment = 0; enrichment <= 4; ++enrichment) {
                ItemStack result = new ItemStack((Item)rod.pellet, 8, enrichment);
                map.put(new ComparableStackHeat(rod, false, enrichment, false), result);
                if (!rod.pellet.isXenonEnabled()) continue;
                ItemStack resultPoison = new ItemStack((Item)rod.pellet, 8, enrichment + 5);
                map.put(new ComparableStackHeat(rod, false, enrichment, true), resultPoison);
            }
        }
        return map;
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient != null && ingredient.func_77973_b() != null && ingredient.func_77973_b() instanceof ItemRBMKRod && (ItemRBMKRod.getCoreHeat(ingredient) > 50.0 || ItemRBMKRod.getHullHeat(ingredient) > 50.0)) {
            return;
        }
        super.loadUsageRecipes(ingredient);
    }

    public static class ComparableStackHeat
    extends RecipesCommon.ComparableStack {
        private final boolean isHot;
        private final int enrichment;
        private final boolean hasPoison;

        public ComparableStackHeat(Item item, boolean isHot) {
            this(item, isHot, -1, false);
        }

        public ComparableStackHeat(Item item, boolean isHot, int enrichment, boolean hasPoison) {
            super(item);
            this.isHot = isHot;
            this.enrichment = enrichment;
            this.hasPoison = hasPoison;
        }

        @Override
        public ItemStack toStack() {
            ItemStack stack = super.toStack();
            ItemRBMKRod rod = (ItemRBMKRod)stack.func_77973_b();
            if (this.enrichment >= 0) {
                ItemRBMKRod.setYield(stack, Math.min(1.0 - (double)this.enrichment / 5.0, 0.99) * rod.yield);
            } else {
                ItemRBMKRod.setYield(stack, 0.2 * rod.yield);
            }
            if (this.hasPoison) {
                ItemRBMKRod.setPoison(stack, 50.0);
            }
            if (!this.isHot) {
                return stack;
            }
            ItemRBMKRod.setCoreHeat(stack, 100.0);
            ItemRBMKRod.setHullHeat(stack, 50.0);
            return stack;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.enrichment;
            result = 31 * result + (this.hasPoison ? 1 : 0);
            return result;
        }
    }
}

