/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.neutron;

import com.hbm.handler.neutron.NeutronNode;
import com.hbm.handler.neutron.NeutronNodeWorld;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.Iterator;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class NeutronStream {
    public NeutronNode origin;
    public double fluxQuantity;
    public double fluxRatio;
    public NeutronType type = NeutronType.DUMMY;
    public Vec3 vector;
    protected BlockPos posInstance;
    private int i;

    public NeutronStream(NeutronNode origin, Vec3 vector) {
        this.origin = origin;
        this.vector = vector;
        this.posInstance = origin.pos.clone();
    }

    public NeutronStream(NeutronNode origin, Vec3 vector, double flux, double ratio, NeutronType type) {
        this.origin = origin;
        this.vector = vector;
        this.posInstance = origin.pos.clone();
        this.fluxQuantity = flux;
        this.fluxRatio = ratio;
        this.type = type;
        NeutronNodeWorld.getOrAddWorld(origin.tile.func_145831_w()).addStream(this);
    }

    public Iterator<BlockPos> getBlocks(final int range) {
        this.i = 1;
        return new Iterator<BlockPos>(){

            @Override
            public boolean hasNext() {
                return NeutronStream.this.i <= range;
            }

            @Override
            public BlockPos next() {
                int x = (int)Math.floor(0.5 + NeutronStream.this.vector.field_72450_a * (double)NeutronStream.this.i);
                int z = (int)Math.floor(0.5 + NeutronStream.this.vector.field_72449_c * (double)NeutronStream.this.i);
                NeutronStream.this.i++;
                return NeutronStream.this.posInstance.mutate(NeutronStream.this.origin.tile.field_145851_c + x, NeutronStream.this.origin.tile.field_145848_d, NeutronStream.this.origin.tile.field_145849_e + z);
            }
        };
    }

    public abstract void runStreamInteraction(World var1, NeutronNodeWorld.StreamWorld var2);

    public static enum NeutronType {
        DUMMY,
        RBMK,
        PILE;

    }
}

