/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.blocks.IRadResistantBlock;
import com.hbm.handler.radiation.ChunkRadiationHandler;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkRadiationHandlerNT
extends ChunkRadiationHandler {
    private static HashMap<World, WorldRadiationData> worldMap = new HashMap();
    private static RadPocket[] pocketsByBlock = null;
    private static Queue<BlockPos> stack = new ArrayDeque<BlockPos>(1024);

    @Override
    public void clearSystem(World world) {
        WorldRadiationData radWorld = worldMap.get(world);
        if (radWorld != null) {
            radWorld.data.clear();
            radWorld.activePockets.clear();
            radWorld.dirtyChunks.clear();
            radWorld.dirtyChunks2.clear();
        }
    }

    @Override
    public void incrementRad(World world, int x, int y, int z, float rad) {
        if (!world.func_72899_e(x, y, z)) {
            return;
        }
        RadPocket p = ChunkRadiationHandlerNT.getPocket(world, x, y, z);
        p.radiation += rad;
        if (rad > 0.0f) {
            WorldRadiationData data = ChunkRadiationHandlerNT.getWorldRadData(world);
            data.activePockets.add(p);
        }
    }

    @Override
    public void decrementRad(World world, int x, int y, int z, float rad) {
        if (y < 0 || y > 255 || !ChunkRadiationHandlerNT.isSubChunkLoaded(world, x, y, z)) {
            return;
        }
        RadPocket p = ChunkRadiationHandlerNT.getPocket(world, x, y, z);
        p.radiation -= Math.max(rad, 0.0f);
        if (p.radiation < 0.0f) {
            p.radiation = 0.0f;
        }
    }

    @Override
    public void setRadiation(World world, int x, int y, int z, float rad) {
        RadPocket p = ChunkRadiationHandlerNT.getPocket(world, x, y, z);
        p.radiation = Math.max(rad, 0.0f);
        if (rad > 0.0f) {
            WorldRadiationData data = ChunkRadiationHandlerNT.getWorldRadData(world);
            data.activePockets.add(p);
        }
    }

    @Override
    public float getRadiation(World world, int x, int y, int z) {
        if (!ChunkRadiationHandlerNT.isSubChunkLoaded(world, x, y, z)) {
            return 0.0f;
        }
        return ChunkRadiationHandlerNT.getPocket((World)world, (int)x, (int)y, (int)z).radiation;
    }

    public static void jettisonData(World world) {
        WorldRadiationData data = ChunkRadiationHandlerNT.getWorldRadData(world);
        data.data.clear();
        data.activePockets.clear();
    }

    public static RadPocket getPocket(World world, int x, int y, int z) {
        return ChunkRadiationHandlerNT.getSubChunkStorage(world, x, y, z).getPocket(x, y, z);
    }

    public static Collection<RadPocket> getActiveCollection(World world) {
        return ChunkRadiationHandlerNT.getWorldRadData((World)world).activePockets;
    }

    public static boolean isSubChunkLoaded(World world, int x, int y, int z) {
        if (y < 0 || y > 255) {
            return false;
        }
        WorldRadiationData worldRadData = worldMap.get(world);
        if (worldRadData == null) {
            return false;
        }
        ChunkRadiationStorage st = worldRadData.data.get(new ChunkCoordIntPair(x >> 4, z >> 4));
        if (st == null) {
            return false;
        }
        SubChunkRadiationStorage sc = st.getForYLevel(y);
        return sc != null;
    }

    public static SubChunkRadiationStorage getSubChunkStorage(World world, int x, int y, int z) {
        ChunkRadiationStorage st = ChunkRadiationHandlerNT.getChunkStorage(world, x, y, z);
        SubChunkRadiationStorage sc = st.getForYLevel(y);
        if (sc == null) {
            ChunkRadiationHandlerNT.rebuildChunkPockets(world.func_72938_d(x, z), y >> 4);
        }
        sc = st.getForYLevel(y);
        return sc;
    }

    public static ChunkRadiationStorage getChunkStorage(World world, int x, int y, int z) {
        WorldRadiationData worldRadData = ChunkRadiationHandlerNT.getWorldRadData(world);
        ChunkRadiationStorage st = worldRadData.data.get(new ChunkCoordIntPair(x >> 4, z >> 4));
        if (st == null) {
            st = new ChunkRadiationStorage(worldRadData, world.func_72938_d(x, z));
            worldRadData.data.put(new ChunkCoordIntPair(x >> 4, z >> 4), st);
        }
        return st;
    }

    private static WorldRadiationData getWorldRadData(World world) {
        WorldRadiationData worldRadData = worldMap.get(world);
        if (worldRadData == null) {
            worldRadData = new WorldRadiationData(world);
            worldMap.put(world, worldRadData);
        }
        return worldRadData;
    }

    @Override
    public void updateSystem() {
        ChunkRadiationHandlerNT.updateRadiation();
    }

    @Override
    public void receiveWorldTick(TickEvent.ServerTickEvent event) {
        ChunkRadiationHandlerNT.rebuildDirty();
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        if (!event.world.field_72995_K) {
            WorldRadiationData data = ChunkRadiationHandlerNT.getWorldRadData(event.world);
            if (data.data.containsKey(event.getChunk().func_76632_l())) {
                data.data.get(event.getChunk().func_76632_l()).unload();
                data.data.remove(event.getChunk().func_76632_l());
            }
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        if (!event.world.field_72995_K && event.getData().func_74764_b("hbmRadDataNT")) {
            WorldRadiationData data = ChunkRadiationHandlerNT.getWorldRadData(event.world);
            ChunkRadiationStorage cData = new ChunkRadiationStorage(data, event.getChunk());
            cData.readFromNBT(event.getData().func_74775_l("hbmRadDataNT"));
            data.data.put(event.getChunk().func_76632_l(), cData);
        }
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        if (!event.world.field_72995_K) {
            WorldRadiationData data = ChunkRadiationHandlerNT.getWorldRadData(event.world);
            if (data.data.containsKey(event.getChunk().func_76632_l())) {
                NBTTagCompound tag = new NBTTagCompound();
                data.data.get(event.getChunk().func_76632_l()).writeToNBT(tag);
                event.getData().func_74782_a("hbmRadDataNT", (NBTBase)tag);
            }
        }
    }

    @Override
    public void receiveWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            worldMap.put(event.world, new WorldRadiationData(event.world));
        }
    }

    @Override
    public void receiveWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            worldMap.remove(event.world);
        }
    }

    public static void updateRadiation() {
        long time = System.currentTimeMillis();
        for (WorldRadiationData w : worldMap.values()) {
            RadPocket p;
            ArrayList<RadPocket> itrActive = new ArrayList<RadPocket>(w.activePockets);
            Iterator<Object> itr = itrActive.iterator();
            while (itr.hasNext()) {
                p = (RadPocket)itr.next();
                BlockPos pos = p.parent.parent.getWorldPos(p.parent.yLevel);
                p.radiation *= 0.999f;
                p.radiation -= 0.05f;
                ((ChunkRadiationStorage)p.parent.parent).chunk.field_76643_l = true;
                if (p.radiation <= 0.0f) {
                    p.radiation = 0.0f;
                    p.accumulatedRads = 0.0f;
                    itr.remove();
                    ((ChunkRadiationStorage)p.parent.parent).chunk.field_76643_l = true;
                    continue;
                }
                float count = 0.0f;
                for (ForgeDirection e : ForgeDirection.VALID_DIRECTIONS) {
                    count += (float)p.connectionIndices[e.ordinal()].size();
                }
                float amountPer = 0.7f / count;
                if (count == 0.0f || p.radiation < 1.0f) {
                    amountPer = 0.0f;
                }
                if (p.radiation > 0.0f && amountPer > 0.0f) {
                    for (ForgeDirection e : ForgeDirection.VALID_DIRECTIONS) {
                        BlockPos nPos = pos.offset(e, 16);
                        if (!((ChunkRadiationStorage)p.parent.parent).chunk.field_76637_e.func_72899_e(nPos.getX(), nPos.getY(), nPos.getZ()) || nPos.getY() < 0 || nPos.getY() > 255) continue;
                        if (p.connectionIndices[e.ordinal()].size() == 1 && p.connectionIndices[e.ordinal()].get(0) == -1) {
                            ChunkRadiationHandlerNT.rebuildChunkPockets(((ChunkRadiationStorage)p.parent.parent).chunk.field_76637_e.func_72938_d(nPos.getX(), nPos.getZ()), nPos.getY() >> 4);
                            continue;
                        }
                        SubChunkRadiationStorage sc2 = ChunkRadiationHandlerNT.getSubChunkStorage(((ChunkRadiationStorage)p.parent.parent).chunk.field_76637_e, nPos.getX(), nPos.getY(), nPos.getZ());
                        for (int idx : p.connectionIndices[e.ordinal()]) {
                            RadPocket radPocket = sc2.pockets[idx];
                            radPocket.accumulatedRads = radPocket.accumulatedRads + p.radiation * amountPer;
                            w.activePockets.add(sc2.pockets[idx]);
                        }
                    }
                }
                if (amountPer != 0.0f) {
                    RadPocket radPocket = p;
                    radPocket.accumulatedRads = radPocket.accumulatedRads + p.radiation * 0.3f;
                }
                if (System.currentTimeMillis() - time <= 20L) continue;
                break;
            }
            itr = w.activePockets.iterator();
            while (itr.hasNext()) {
                p = (RadPocket)itr.next();
                p.radiation = p.accumulatedRads;
                p.accumulatedRads = 0.0f;
                if (!(p.radiation <= 0.0f)) continue;
                itr.remove();
            }
        }
        if (System.currentTimeMillis() - time > 50L) {
            System.out.println("Rads took too long: " + (System.currentTimeMillis() - time));
        }
    }

    public static void markChunkForRebuild(World world, int x, int y, int z) {
        BlockPos chunkPos = new BlockPos(x >> 4, y >> 4, z >> 4);
        WorldRadiationData r = ChunkRadiationHandlerNT.getWorldRadData(world);
        if (r.iteratingDirty) {
            r.dirtyChunks2.add(chunkPos);
        } else {
            r.dirtyChunks.add(chunkPos);
        }
    }

    private static void rebuildDirty() {
        for (WorldRadiationData r : worldMap.values()) {
            r.iteratingDirty = true;
            for (BlockPos b : r.dirtyChunks) {
                ChunkRadiationHandlerNT.rebuildChunkPockets(r.world.func_72964_e(b.getX(), b.getZ()), b.getY());
            }
            r.iteratingDirty = false;
            r.dirtyChunks.clear();
            r.dirtyChunks.addAll(r.dirtyChunks2);
            r.dirtyChunks2.clear();
        }
    }

    private static void rebuildChunkPockets(Chunk chunk, int yIndex) {
        BlockPos subChunkPos = new BlockPos(chunk.func_76632_l().field_77276_a << 4, yIndex << 4, chunk.func_76632_l().field_77275_b << 4);
        ArrayList<RadPocket> pockets = new ArrayList<RadPocket>();
        ExtendedBlockStorage blocks = chunk.func_76587_i()[yIndex];
        if (pocketsByBlock == null) {
            pocketsByBlock = new RadPocket[4096];
        } else {
            Arrays.fill(pocketsByBlock, null);
        }
        ChunkRadiationStorage st = ChunkRadiationHandlerNT.getChunkStorage(chunk.field_76637_e, subChunkPos.getX(), subChunkPos.getY(), subChunkPos.getZ());
        SubChunkRadiationStorage subChunk = new SubChunkRadiationStorage(st, subChunkPos.getY(), null, null);
        if (blocks != null) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        Block block;
                        if (pocketsByBlock[x * 16 * 16 + y * 16 + z] != null || (block = blocks.func_150819_a(x, y, z)) instanceof IRadResistantBlock && ((IRadResistantBlock)block).getResistance() == 1) continue;
                        pockets.add(ChunkRadiationHandlerNT.buildPocket(subChunk, chunk.field_76637_e, new BlockPos(x, y, z), subChunkPos, blocks, pocketsByBlock, pockets.size()));
                    }
                }
            }
        } else {
            RadPocket pocket = new RadPocket(subChunk, 0);
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    ChunkRadiationHandlerNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, 0, y), pocket, ForgeDirection.DOWN);
                    ChunkRadiationHandlerNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, 15, y), pocket, ForgeDirection.UP);
                    ChunkRadiationHandlerNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, y, 0), pocket, ForgeDirection.NORTH);
                    ChunkRadiationHandlerNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, y, 15), pocket, ForgeDirection.SOUTH);
                    ChunkRadiationHandlerNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(0, y, x), pocket, ForgeDirection.WEST);
                    ChunkRadiationHandlerNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(15, y, x), pocket, ForgeDirection.EAST);
                }
            }
            pockets.add(pocket);
        }
        RadPocket[] radPocketArray = subChunk.pocketsByBlock = pockets.size() == 1 ? null : pocketsByBlock;
        if (subChunk.pocketsByBlock != null) {
            pocketsByBlock = null;
        }
        subChunk.pockets = pockets.toArray(new RadPocket[pockets.size()]);
        st.setForYLevel(yIndex << 4, subChunk);
    }

    private static void doEmptyChunk(Chunk chunk, BlockPos subChunkPos, BlockPos pos, RadPocket pocket, ForgeDirection facing) {
        BlockPos newPos = pos.offset(facing);
        BlockPos outPos = newPos.add(subChunkPos);
        Block block = chunk.field_76637_e.func_147439_a(outPos.getX(), outPos.getY(), outPos.getZ());
        if (!(block instanceof IRadResistantBlock) || ((IRadResistantBlock)block).getResistance() != 1) {
            if (!ChunkRadiationHandlerNT.isSubChunkLoaded(chunk.field_76637_e, outPos.getX(), outPos.getY(), outPos.getZ())) {
                if (!pocket.connectionIndices[facing.ordinal()].contains(-1)) {
                    pocket.connectionIndices[facing.ordinal()].add(-1);
                }
            } else {
                RadPocket outPocket = ChunkRadiationHandlerNT.getPocket(chunk.field_76637_e, outPos.getX(), outPos.getY(), outPos.getZ());
                if (!pocket.connectionIndices[facing.ordinal()].contains(outPocket.index)) {
                    pocket.connectionIndices[facing.ordinal()].add(outPocket.index);
                }
            }
        }
    }

    private static RadPocket buildPocket(SubChunkRadiationStorage subChunk, World world, BlockPos start, BlockPos subChunkWorldPos, ExtendedBlockStorage chunk, RadPocket[] pocketsByBlock, int index) {
        RadPocket pocket = new RadPocket(subChunk, index);
        stack.clear();
        stack.add(start);
        while (!stack.isEmpty()) {
            BlockPos pos = stack.poll();
            Block block = chunk.func_150819_a(pos.getX(), pos.getY(), pos.getZ());
            if (pocketsByBlock[pos.getX() * 16 * 16 + pos.getY() * 16 + pos.getZ()] != null || block instanceof IRadResistantBlock && ((IRadResistantBlock)block).getResistance() == 1) continue;
            pocketsByBlock[pos.getX() * 16 * 16 + pos.getY() * 16 + pos.getZ()] = pocket;
            for (ForgeDirection facing : ForgeDirection.VALID_DIRECTIONS) {
                BlockPos newPos = pos.offset(facing);
                if (Math.max(Math.max(newPos.getX(), newPos.getY()), newPos.getZ()) > 15 || Math.min(Math.min(newPos.getX(), newPos.getY()), newPos.getZ()) < 0) {
                    BlockPos outPos = newPos.add(subChunkWorldPos);
                    if (outPos.getY() < 0 || outPos.getY() > 255 || (block = world.func_147439_a(outPos.getX(), outPos.getY(), outPos.getZ())) instanceof IRadResistantBlock && ((IRadResistantBlock)block).getResistance() == 1) continue;
                    if (!ChunkRadiationHandlerNT.isSubChunkLoaded(world, outPos.getX(), outPos.getY(), outPos.getZ())) {
                        if (pocket.connectionIndices[facing.ordinal()].contains(-1)) continue;
                        pocket.connectionIndices[facing.ordinal()].add(-1);
                        continue;
                    }
                    RadPocket outPocket = ChunkRadiationHandlerNT.getPocket(world, outPos.getX(), outPos.getY(), outPos.getZ());
                    if (pocket.connectionIndices[facing.ordinal()].contains(outPocket.index)) continue;
                    pocket.connectionIndices[facing.ordinal()].add(outPocket.index);
                    continue;
                }
                stack.add(newPos);
            }
        }
        return pocket;
    }

    public static class WorldRadiationData {
        public World world;
        private Set<BlockPos> dirtyChunks = new HashSet<BlockPos>();
        private Set<BlockPos> dirtyChunks2 = new HashSet<BlockPos>();
        private boolean iteratingDirty = false;
        public Set<RadPocket> activePockets = new HashSet<RadPocket>();
        public HashMap<ChunkCoordIntPair, ChunkRadiationStorage> data = new HashMap();

        public WorldRadiationData(World world) {
            this.world = world;
        }
    }

    public static class ChunkRadiationStorage {
        private static ByteBuffer buf = ByteBuffer.allocate(524288);
        public WorldRadiationData parent;
        private Chunk chunk;
        private SubChunkRadiationStorage[] chunks = new SubChunkRadiationStorage[16];

        public ChunkRadiationStorage(WorldRadiationData parent, Chunk chunk) {
            this.parent = parent;
            this.chunk = chunk;
        }

        public SubChunkRadiationStorage getForYLevel(int y) {
            int idx = y >> 4;
            if (idx < 0 || idx > this.chunks.length) {
                return null;
            }
            return this.chunks[y >> 4];
        }

        public BlockPos getWorldPos(int y) {
            return new BlockPos(this.chunk.func_76632_l().field_77276_a << 4, y, this.chunk.func_76632_l().field_77275_b << 4);
        }

        public void setForYLevel(int y, SubChunkRadiationStorage sc) {
            if (this.chunks[y >> 4] != null) {
                this.chunks[y >> 4].remove(this.chunk.field_76637_e, this.getWorldPos(y));
                if (sc != null) {
                    sc.setRad(this.chunks[y >> 4]);
                }
            }
            if (sc != null) {
                sc.add(this.chunk.field_76637_e, this.getWorldPos(y));
            }
            this.chunks[y >> 4] = sc;
        }

        public void unload() {
            for (int y = 0; y < this.chunks.length; ++y) {
                if (this.chunks[y] == null) continue;
                for (RadPocket p : this.chunks[y].pockets) {
                    this.parent.activePockets.remove(p);
                }
                this.chunks[y] = null;
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            for (SubChunkRadiationStorage st : this.chunks) {
                if (st == null) {
                    buf.put((byte)0);
                    continue;
                }
                buf.put((byte)1);
                buf.putShort((short)st.yLevel);
                buf.putShort((short)st.pockets.length);
                for (RadPocket p : st.pockets) {
                    this.writePocket(buf, p);
                }
                if (st.pocketsByBlock == null) {
                    buf.put((byte)0);
                    continue;
                }
                buf.put((byte)1);
                for (RadPocket p : st.pocketsByBlock) {
                    buf.putShort(this.arrayIndex(p, st.pockets));
                }
            }
            buf.flip();
            byte[] data = new byte[buf.limit()];
            buf.get(data);
            tag.func_74773_a("chunkRadData", data);
            buf.clear();
            return tag;
        }

        public short arrayIndex(RadPocket p, RadPocket[] pockets) {
            for (short i = 0; i < pockets.length; i = (short)(i + 1)) {
                if (p != pockets[i]) continue;
                return i;
            }
            return -1;
        }

        public void writePocket(ByteBuffer buf, RadPocket p) {
            buf.putInt(p.index);
            buf.putFloat(p.radiation);
            for (ForgeDirection e : ForgeDirection.VALID_DIRECTIONS) {
                List<Integer> indc = p.connectionIndices[e.ordinal()];
                buf.putShort((short)indc.size());
                for (int idx : indc) {
                    buf.putShort((short)idx);
                }
            }
        }

        public void readFromNBT(NBTTagCompound tag) {
            ByteBuffer data = ByteBuffer.wrap(tag.func_74770_j("chunkRadData"));
            for (int i = 0; i < this.chunks.length; ++i) {
                boolean subChunkExists;
                boolean bl = subChunkExists = data.get() == 1;
                if (subChunkExists) {
                    boolean perBlockDataExists;
                    short yLevel = data.getShort();
                    SubChunkRadiationStorage st = new SubChunkRadiationStorage(this, yLevel, null, null);
                    int pocketsLength = data.getShort();
                    st.pockets = new RadPocket[pocketsLength];
                    for (int j = 0; j < pocketsLength; ++j) {
                        st.pockets[j] = this.readPocket(data, st);
                        if (!(st.pockets[j].radiation > 0.0f)) continue;
                        this.parent.activePockets.add(st.pockets[j]);
                    }
                    boolean bl2 = perBlockDataExists = data.get() == 1;
                    if (perBlockDataExists) {
                        st.pocketsByBlock = new RadPocket[4096];
                        for (int j = 0; j < 4096; ++j) {
                            short idx = data.getShort();
                            if (idx < 0) continue;
                            st.pocketsByBlock[j] = st.pockets[idx];
                        }
                    }
                    this.chunks[i] = st;
                    continue;
                }
                this.chunks[i] = null;
            }
        }

        public RadPocket readPocket(ByteBuffer buf, SubChunkRadiationStorage parent) {
            int index = buf.getInt();
            RadPocket p = new RadPocket(parent, index);
            p.radiation = buf.getFloat();
            for (ForgeDirection e : ForgeDirection.VALID_DIRECTIONS) {
                List<Integer> indc = p.connectionIndices[e.ordinal()];
                int size = buf.getShort();
                for (int i = 0; i < size; ++i) {
                    indc.add(Integer.valueOf(buf.getShort()));
                }
            }
            return p;
        }
    }

    public static class SubChunkRadiationStorage {
        public ChunkRadiationStorage parent;
        public int yLevel;
        public RadPocket[] pocketsByBlock;
        public RadPocket[] pockets;

        public SubChunkRadiationStorage(ChunkRadiationStorage parent, int yLevel, RadPocket[] pocketsByBlock, RadPocket[] pockets) {
            this.parent = parent;
            this.yLevel = yLevel;
            this.pocketsByBlock = pocketsByBlock;
            this.pockets = pockets;
        }

        public RadPocket getPocket(int x, int y, int z) {
            if (this.pocketsByBlock == null) {
                return this.pockets[0];
            }
            RadPocket p = this.pocketsByBlock[(x &= 0xF) * 16 * 16 + (y &= 0xF) * 16 + (z &= 0xF)];
            return p == null ? this.pockets[0] : p;
        }

        public void setRad(SubChunkRadiationStorage other) {
            float total = 0.0f;
            for (RadPocket p : other.pockets) {
                total += p.radiation;
            }
            float radPer = total / (float)this.pockets.length;
            for (RadPocket p : this.pockets) {
                p.radiation = radPer;
                if (!(radPer > 0.0f)) continue;
                p.parent.parent.parent.activePockets.add(p);
            }
        }

        public void remove(World world, BlockPos pos) {
            for (RadPocket radPocket : this.pockets) {
                radPocket.remove(world, pos);
            }
            for (RadPocket radPocket : ForgeDirection.VALID_DIRECTIONS) {
                IChunkProvider provider = world.func_72863_F();
                provider.func_73158_c(pos.getX() + 16 >> 4, pos.getZ() + 16 >> 4);
                BlockPos offPos = pos.offset((ForgeDirection)radPocket, 16);
                if (!ChunkRadiationHandlerNT.isSubChunkLoaded(world, offPos.getX(), offPos.getY(), offPos.getZ())) continue;
                SubChunkRadiationStorage sc = ChunkRadiationHandlerNT.getSubChunkStorage(world, offPos.getX(), offPos.getY(), offPos.getZ());
                for (RadPocket p : sc.pockets) {
                    p.connectionIndices[radPocket.getOpposite().ordinal()].clear();
                }
            }
        }

        public void add(World world, BlockPos pos) {
            for (ForgeDirection e : ForgeDirection.VALID_DIRECTIONS) {
                IChunkProvider provider = world.func_72863_F();
                provider.func_73158_c(pos.getX() + 16 >> 4, pos.getZ() + 16 >> 4);
                BlockPos offPos = pos.offset(e, 16);
                if (!ChunkRadiationHandlerNT.isSubChunkLoaded(world, offPos.getX(), offPos.getY(), offPos.getZ())) continue;
                SubChunkRadiationStorage sc = ChunkRadiationHandlerNT.getSubChunkStorage(world, offPos.getX(), offPos.getY(), offPos.getZ());
                for (RadPocket p : sc.pockets) {
                    p.connectionIndices[e.getOpposite().ordinal()].clear();
                }
                for (RadPocket p : this.pockets) {
                    List<Integer> indc = p.connectionIndices[e.ordinal()];
                    for (int idx : indc) {
                        sc.pockets[idx].connectionIndices[e.getOpposite().ordinal()].add(p.index);
                    }
                }
            }
        }
    }

    public static class RadPocket {
        public SubChunkRadiationStorage parent;
        public int index;
        public float radiation;
        private float accumulatedRads = 0.0f;
        public List<Integer>[] connectionIndices = new List[ForgeDirection.VALID_DIRECTIONS.length];

        public RadPocket(SubChunkRadiationStorage parent, int index) {
            this.parent = parent;
            this.index = index;
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                this.connectionIndices[i] = new ArrayList<Integer>(1);
            }
        }

        protected void remove(World world, BlockPos pos) {
            for (ForgeDirection e : ForgeDirection.VALID_DIRECTIONS) {
                this.connectionIndices[e.ordinal()].clear();
            }
            this.parent.parent.parent.activePockets.remove(this);
        }

        public BlockPos getSubChunkPos() {
            return this.parent.parent.getWorldPos(this.parent.yLevel);
        }
    }
}

