/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.trait;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FluidTrait;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class FT_Polluting
extends FluidTrait {
    public HashMap<PollutionHandler.PollutionType, Float> releaseMap = new HashMap();
    public HashMap<PollutionHandler.PollutionType, Float> burnMap = new HashMap();

    public FT_Polluting release(PollutionHandler.PollutionType type, float amount) {
        this.releaseMap.put(type, Float.valueOf(amount));
        return this;
    }

    public FT_Polluting burn(PollutionHandler.PollutionType type, float amount) {
        this.burnMap.put(type, Float.valueOf(amount));
        return this;
    }

    @Override
    public void addInfo(List<String> info) {
        info.add(EnumChatFormatting.GOLD + "[Polluting]");
    }

    @Override
    public void addInfoHidden(List<String> info) {
        if (!this.releaseMap.isEmpty()) {
            info.add(EnumChatFormatting.GREEN + "When spilled:");
            for (Map.Entry<PollutionHandler.PollutionType, Float> entry : this.releaseMap.entrySet()) {
                info.add(EnumChatFormatting.GREEN + " - " + entry.getValue() + " " + (Object)((Object)entry.getKey()) + " per mB");
            }
        }
        if (!this.burnMap.isEmpty()) {
            info.add(EnumChatFormatting.RED + "When burned:");
            for (Map.Entry<PollutionHandler.PollutionType, Float> entry : this.burnMap.entrySet()) {
                info.add(EnumChatFormatting.RED + " - " + entry.getValue() + " " + (Object)((Object)entry.getKey()) + " per mB");
            }
        }
    }

    @Override
    public void onFluidRelease(World world, int x, int y, int z, FluidTank tank, int overflowAmount, FluidTrait.FluidReleaseType type) {
        if (type == FluidTrait.FluidReleaseType.SPILL) {
            for (Map.Entry<PollutionHandler.PollutionType, Float> entry : this.releaseMap.entrySet()) {
                PollutionHandler.incrementPollution(world, x, y, z, entry.getKey(), entry.getValue().floatValue());
            }
        }
        if (type == FluidTrait.FluidReleaseType.BURN) {
            for (Map.Entry<PollutionHandler.PollutionType, Float> entry : this.burnMap.entrySet()) {
                PollutionHandler.incrementPollution(world, x, y, z, entry.getKey(), entry.getValue().floatValue());
            }
        }
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("release").beginObject();
        for (Map.Entry<PollutionHandler.PollutionType, Float> entry : this.releaseMap.entrySet()) {
            writer.name(entry.getKey().name()).value((Number)entry.getValue());
        }
        writer.endObject();
        writer.name("burn").beginObject();
        for (Map.Entry<PollutionHandler.PollutionType, Float> entry : this.burnMap.entrySet()) {
            writer.name(entry.getKey().name()).value((Number)entry.getValue());
        }
        writer.endObject();
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        JsonObject release;
        if (obj.has("release")) {
            release = obj.get("release").getAsJsonObject();
            for (PollutionHandler.PollutionType type : PollutionHandler.PollutionType.values()) {
                if (!release.has(type.name())) continue;
                this.releaseMap.put(type, Float.valueOf(release.get(type.name()).getAsFloat()));
            }
        }
        if (obj.has("burn")) {
            release = obj.get("burn").getAsJsonObject();
            for (PollutionHandler.PollutionType type : PollutionHandler.PollutionType.values()) {
                if (!release.has(type.name())) continue;
                this.burnMap.put(type, Float.valueOf(release.get(type.name()).getAsFloat()));
            }
        }
    }

    public static void pollute(World world, int x, int y, int z, FluidType type, FluidTrait.FluidReleaseType release, float mB) {
        FT_Polluting trait = type.getTrait(FT_Polluting.class);
        if (trait == null) {
            return;
        }
        if (release == FluidTrait.FluidReleaseType.VOID) {
            return;
        }
        HashMap<PollutionHandler.PollutionType, Float> map = release == FluidTrait.FluidReleaseType.BURN ? trait.burnMap : trait.releaseMap;
        for (Map.Entry<PollutionHandler.PollutionType, Float> entry : map.entrySet()) {
            PollutionHandler.incrementPollution(world, x, y, z, entry.getKey(), entry.getValue().floatValue() * mB);
        }
    }
}

