/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.handler.ability.AvailableAbilities;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.handler.ability.IToolAreaAbility;
import com.hbm.handler.ability.IToolHarvestAbility;
import com.hbm.handler.ability.ToolPreset;
import com.hbm.items.tool.ItemToolAbility;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTItemControlPacket;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GUIScreenToolAbility
extends GuiScreen {
    public static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/tool/gui_tool_ability.png");
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected int insetWidth;
    public static final List<AbilityInfo> abilitiesArea = new ArrayList<AbilityInfo>();
    public static final List<AbilityInfo> abilitiesHarvest = new ArrayList<AbilityInfo>();
    protected ItemStack toolStack;
    protected AvailableAbilities availableAbilities;
    protected ItemToolAbility.Configuration config;
    protected int hoverIdxHarvest = -1;
    protected int hoverIdxArea = -1;
    protected int hoverIdxExtraBtn = -1;

    public GUIScreenToolAbility(AvailableAbilities availableAbilities) {
        this.availableAbilities = availableAbilities;
        this.xSize = 186;
        this.ySize = 76;
        this.insetWidth = 20 * Math.max(abilitiesArea.size() - 4, abilitiesHarvest.size() - 8);
        this.xSize += this.insetWidth;
    }

    public void func_73866_w_() {
        this.toolStack = this.field_146297_k.field_71439_g.func_70694_bm();
        if (this.toolStack == null) {
            this.doClose();
        }
        this.config = ((ItemToolAbility)this.toolStack.func_77973_b()).getConfiguration(this.toolStack);
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        int level;
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.drawStretchedRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.xSize - this.insetWidth, this.ySize, 74, 87);
        ToolPreset activePreset = this.config.getActivePreset();
        this.hoverIdxArea = this.drawSwitches(abilitiesArea, activePreset.areaAbility, activePreset.areaAbilityLevel, this.guiLeft + 15, this.guiTop + 25, mouseX, mouseY);
        this.hoverIdxHarvest = this.drawSwitches(abilitiesHarvest, activePreset.harvestAbility, activePreset.harvestAbilityLevel, this.guiLeft + 15, this.guiTop + 45, mouseX, mouseY);
        this.drawNumber(this.config.currentPreset + 1, this.guiLeft + this.insetWidth + 115, this.guiTop + 25);
        this.drawNumber(this.config.presets.size(), this.guiLeft + this.insetWidth + 149, this.guiTop + 25);
        int extraBtnsX = this.guiLeft + this.xSize - 86;
        this.hoverIdxExtraBtn = -1;
        for (int i = 0; i < 7; ++i) {
            if (!this.isInAABB(mouseX, mouseY, extraBtnsX + i * 11, this.guiTop + 11, 9, 9)) continue;
            this.hoverIdxExtraBtn = i;
            this.func_73729_b(extraBtnsX + i * 11, this.guiTop + 11, 193 + i * 9, 0, 9, 9);
        }
        String tooltipValue = "";
        if (this.hoverIdxArea != -1) {
            level = 0;
            if (GUIScreenToolAbility.abilitiesArea.get((int)this.hoverIdxArea).ability == activePreset.areaAbility) {
                level = activePreset.areaAbilityLevel;
            }
            tooltipValue = GUIScreenToolAbility.abilitiesArea.get((int)this.hoverIdxArea).ability.getFullName(level);
        } else if (this.hoverIdxHarvest != -1) {
            level = 0;
            if (GUIScreenToolAbility.abilitiesHarvest.get((int)this.hoverIdxHarvest).ability == activePreset.harvestAbility) {
                level = activePreset.harvestAbilityLevel;
            }
            tooltipValue = GUIScreenToolAbility.abilitiesHarvest.get((int)this.hoverIdxHarvest).ability.getFullName(level);
        } else if (this.hoverIdxExtraBtn != -1) {
            switch (this.hoverIdxExtraBtn) {
                case 0: {
                    tooltipValue = "Reset all presets";
                    break;
                }
                case 1: {
                    tooltipValue = "Delete current preset";
                    break;
                }
                case 2: {
                    tooltipValue = "Add new preset";
                    break;
                }
                case 3: {
                    tooltipValue = "Select first preset";
                    break;
                }
                case 4: {
                    tooltipValue = "Next preset";
                    break;
                }
                case 5: {
                    tooltipValue = "Previous preset";
                    break;
                }
                case 6: {
                    tooltipValue = "Close window";
                }
            }
        }
        if (!tooltipValue.isEmpty()) {
            int tooltipWidth = Math.max(6, this.field_146289_q.func_78256_a(tooltipValue));
            int tooltipX = this.guiLeft + this.xSize / 2 - tooltipWidth / 2;
            int tooltipY = this.guiTop + this.ySize + 1 + 4;
            this.drawStretchedRect(tooltipX - 5, tooltipY - 4, 0, 76, tooltipWidth + 10, 186, 15, 3, 3);
            this.field_146289_q.func_78276_b(tooltipValue, tooltipX, tooltipY, -1);
        }
    }

    protected void drawStretchedRect(int x, int y, int u, int v, int realWidth, int width, int height, int keepLeft, int keepRight) {
        int midWidth = width - keepLeft - keepRight;
        int realMidWidth = realWidth - keepLeft - keepRight;
        this.func_73729_b(x, y, u, v, keepLeft, height);
        for (int i = 0; i < realMidWidth; i += midWidth) {
            this.func_73729_b(x + keepLeft + i, y, u + keepLeft, v, Math.min(midWidth, realMidWidth - i), height);
        }
        this.func_73729_b(x + keepLeft + realMidWidth, y, u + keepLeft + midWidth, v, keepRight, height);
    }

    protected int drawSwitches(List<AbilityInfo> abilities, IBaseAbility selectedAbility, int selectedLevel, int x, int y, int mouseX, int mouseY) {
        int hoverIdx = -1;
        for (int i = 0; i < abilities.size(); ++i) {
            boolean isHovered;
            AbilityInfo abilityInfo = abilities.get(i);
            boolean available = this.abilityAvailable(abilityInfo.ability);
            boolean selected = abilityInfo.ability == selectedAbility;
            this.func_73729_b(x + 20 * i, y, abilityInfo.textureU + (available ? 16 : 0), abilityInfo.textureV, 16, 16);
            if (abilityInfo.ability.levels() > 1) {
                int level = 0;
                if (selected) {
                    level = selectedLevel + 1;
                }
                int maxLevel = 5;
                if (level > 10 || level < 0) {
                    level = -1;
                }
                this.func_73729_b(x + 20 * i + 17, y + 1, 188 + level * 2, maxLevel * 14, 2, 14);
            }
            if (isHovered = this.isInAABB(mouseX, mouseY, x + 20 * i, y, 16, 16)) {
                hoverIdx = i;
            }
            if (selected) {
                this.func_73729_b(x + 20 * i - 1, y - 1, 220, 9, 18, 18);
                continue;
            }
            if (!available || !isHovered) continue;
            this.func_73729_b(x + 20 * i - 1, y - 1, 238, 9, 18, 18);
        }
        return hoverIdx;
    }

    protected void drawNumber(int number, int x, int y) {
        this.drawDigit((number += 100) / 10 % 10, x, y);
        this.drawDigit(number % 10, x + 12, y);
    }

    protected void drawDigit(int digit, int x, int y) {
        this.func_73729_b(x, y, digit * 10, 123, 10, 15);
    }

    private boolean isInAABB(int mouseX, int mouseY, int x, int y, int width, int height) {
        return x <= mouseX && x + width > mouseX && y <= mouseY && y + height > mouseY;
    }

    private boolean abilityAvailable(IBaseAbility ability) {
        if (!this.availableAbilities.supportsAbility(ability)) {
            return false;
        }
        ToolPreset activePreset = this.config.getActivePreset();
        return !(ability instanceof IToolHarvestAbility) || ability == IToolHarvestAbility.NONE || activePreset.areaAbility.allowsHarvest(activePreset.areaAbilityLevel);
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (Mouse.getEventButton() == -1) {
            int scroll = Mouse.getEventDWheel();
            if (scroll < 0) {
                this.doPrevPreset(true);
            }
            if (scroll > 0) {
                this.doNextPreset(true);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        ToolPreset activePreset = this.config.getActivePreset();
        Tuple.Pair<IBaseAbility, Integer> clickResult = this.handleSwitchesClicked(abilitiesArea, activePreset.areaAbility, activePreset.areaAbilityLevel, this.hoverIdxArea, mouseX, mouseY);
        activePreset.areaAbility = (IToolAreaAbility)clickResult.key;
        activePreset.areaAbilityLevel = (Integer)clickResult.value;
        clickResult = this.handleSwitchesClicked(abilitiesHarvest, activePreset.harvestAbility, activePreset.harvestAbilityLevel, this.hoverIdxHarvest, mouseX, mouseY);
        activePreset.harvestAbility = (IToolHarvestAbility)clickResult.key;
        activePreset.harvestAbilityLevel = (Integer)clickResult.value;
        if (!activePreset.areaAbility.allowsHarvest(activePreset.areaAbilityLevel)) {
            activePreset.harvestAbility = IToolHarvestAbility.NONE;
            activePreset.harvestAbilityLevel = 0;
        }
        if (this.hoverIdxExtraBtn != -1) {
            switch (this.hoverIdxExtraBtn) {
                case 0: {
                    this.doResetPresets();
                    break;
                }
                case 1: {
                    this.doDelPreset();
                    break;
                }
                case 2: {
                    this.doAddPreset();
                    break;
                }
                case 3: {
                    this.doZeroPreset();
                    break;
                }
                case 4: {
                    this.doNextPreset(false);
                    break;
                }
                case 5: {
                    this.doPrevPreset(false);
                    break;
                }
                case 6: {
                    this.doClose();
                }
            }
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)0.5f));
        }
        if (!this.isInAABB(mouseX, mouseY, this.guiLeft, this.guiTop, this.xSize, this.ySize)) {
            this.doClose();
        }
    }

    protected Tuple.Pair<IBaseAbility, Integer> handleSwitchesClicked(List<AbilityInfo> abilities, IBaseAbility selectedAbility, int selectedLevel, int hoverIdx, int mouseX, int mouseY) {
        IBaseAbility hoveredAbility;
        boolean available;
        if (hoverIdx != -1 && (available = this.abilityAvailable(hoveredAbility = abilities.get((int)hoverIdx).ability))) {
            int availableLevels = this.availableAbilities.maxLevel(hoveredAbility) + 1;
            if (hoveredAbility != selectedAbility || availableLevels > 1) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("hbm:item.techBoop"), (float)2.0f));
            }
            selectedLevel = hoveredAbility == selectedAbility ? (selectedLevel + 1) % availableLevels : 0;
            selectedAbility = hoveredAbility;
        }
        return new Tuple.Pair<IBaseAbility, Integer>(selectedAbility, selectedLevel);
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.doClose();
            return;
        }
        super.func_73869_a(c, key);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void doResetPresets() {
        this.config.reset(this.availableAbilities);
    }

    protected void doDelPreset() {
        if (this.config.presets.size() <= 1) {
            return;
        }
        this.config.presets.remove(this.config.currentPreset);
        this.config.currentPreset = Math.min(this.config.currentPreset, this.config.presets.size() - 1);
    }

    protected void doAddPreset() {
        if (this.config.presets.size() >= 99) {
            return;
        }
        this.config.presets.add(this.config.currentPreset + 1, new ToolPreset());
        ++this.config.currentPreset;
    }

    protected void doZeroPreset() {
        this.config.currentPreset = 0;
    }

    protected void doNextPreset(boolean bound) {
        if (bound) {
            if (this.config.currentPreset < this.config.presets.size() - 1) {
                ++this.config.currentPreset;
            }
        } else {
            this.config.currentPreset = (this.config.currentPreset + 1) % this.config.presets.size();
        }
    }

    protected void doPrevPreset(boolean bound) {
        if (bound) {
            if (this.config.currentPreset > 0) {
                --this.config.currentPreset;
            }
        } else {
            this.config.currentPreset = (this.config.currentPreset + this.config.presets.size() - 1) % this.config.presets.size();
        }
    }

    protected void doClose() {
        ((ItemToolAbility)this.toolStack.func_77973_b()).setConfiguration(this.toolStack, this.config);
        PacketDispatcher.wrapper.sendToServer(new NBTItemControlPacket(this.toolStack.func_77978_p()));
        this.field_146297_k.field_71439_g.func_71053_j();
        MainRegistry.proxy.displayTooltip(this.config.getActivePreset().getMessage().func_150254_d(), 11);
        this.field_146297_k.field_71441_e.func_72956_a((Entity)this.field_146297_k.field_71439_g, "random.orb", 0.25f, this.config.getActivePreset().isNone() ? 0.75f : 1.25f);
    }

    static {
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.NONE, 0, 91));
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.RECURSION, 32, 91));
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.HAMMER, 64, 91));
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.HAMMER_FLAT, 96, 91));
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.EXPLOSION, 128, 91));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.NONE, 0, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.SILK, 32, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.LUCK, 64, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.SMELTER, 96, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.SHREDDER, 128, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.CENTRIFUGE, 160, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.CRYSTALLIZER, 192, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.MERCURY, 224, 107));
    }

    public static class AbilityInfo {
        public IBaseAbility ability;
        public int textureU;
        public int textureV;

        public AbilityInfo(IBaseAbility ability, int textureU, int textureV) {
            this.ability = ability;
            this.textureU = textureU;
            this.textureV = textureV;
        }
    }
}

