/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.network.TileEntityRadioTelex;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiScreenRadioTelex
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/machine/gui_telex.png");
    protected TileEntityRadioTelex telex;
    protected int xSize = 256;
    protected int ySize = 244;
    protected int guiLeft;
    protected int guiTop;
    protected GuiTextField txFrequency;
    protected GuiTextField rxFrequency;
    protected boolean textFocus = false;
    protected String[] txBuffer;
    protected int cursorPos = 0;

    public GuiScreenRadioTelex(TileEntityRadioTelex tile) {
        int i;
        this.telex = tile;
        this.txBuffer = new String[tile.txBuffer.length];
        for (i = 0; i < this.txBuffer.length; ++i) {
            this.txBuffer[i] = tile.txBuffer[i];
        }
        for (i = 4; i > 0; --i) {
            if (this.txBuffer[i].isEmpty()) continue;
            this.cursorPos = i;
            break;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.txFrequency = new GuiTextField(this.field_146289_q, this.guiLeft + 29, this.guiTop + 110, 90, 14);
        this.txFrequency.func_146193_g(65280);
        this.txFrequency.func_146204_h(65280);
        this.txFrequency.func_146185_a(false);
        this.txFrequency.func_146203_f(10);
        this.txFrequency.func_146180_a(this.telex.txChannel == null ? "" : this.telex.txChannel);
        this.rxFrequency = new GuiTextField(this.field_146289_q, this.guiLeft + 29, this.guiTop + 224, 90, 14);
        this.rxFrequency.func_146193_g(65280);
        this.rxFrequency.func_146204_h(65280);
        this.rxFrequency.func_146185_a(false);
        this.rxFrequency.func_146203_f(10);
        this.rxFrequency.func_146180_a(this.telex.rxChannel == null ? "" : this.telex.rxChannel);
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
    }

    private void drawGuiContainerForegroundLayer(int x, int y) {
        if (this.checkClick(x, y, 7, 85, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.GOLD + "BELL", "Plays a bell when this character is received"), x, y);
        }
        if (this.checkClick(x, y, 27, 85, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.GOLD + "PRINT", "Forces recipient to print message after transmission ends"), x, y);
        }
        if (this.checkClick(x, y, 47, 85, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.GOLD + "CLEAR SCREEN", "Wipes message buffer when this character is received"), x, y);
        }
        if (this.checkClick(x, y, 67, 85, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.GOLD + "FORMAT", "Inserts format character for message formatting"), x, y);
        }
        if (this.checkClick(x, y, 87, 85, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.GOLD + "PAUSE", "Pauses message transmission for one second"), x, y);
        }
        if (this.checkClick(x, y, 127, 105, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.GREEN + "SAVE ID"), x, y);
        }
        if (this.checkClick(x, y, 147, 105, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.YELLOW + "SEND MESSAGE"), x, y);
        }
        if (this.checkClick(x, y, 167, 105, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.RED + "DELETE MESSAGE BUFFER"), x, y);
        }
        if (this.checkClick(x, y, 127, 219, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.GREEN + "SAVE ID"), x, y);
        }
        if (this.checkClick(x, y, 147, 219, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.AQUA + "PRINT MESSAGE"), x, y);
        }
        if (this.checkClick(x, y, 167, 219, 18, 18)) {
            this.func_146283_a(Arrays.asList(EnumChatFormatting.RED + "CLEAR SCREEN"), x, y);
        }
    }

    private void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        int x;
        String glyph;
        int c;
        String format;
        int y;
        String text;
        int line;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.txFrequency.func_146194_f();
        this.rxFrequency.func_146194_f();
        for (line = 0; line < 5; ++line) {
            text = this.txBuffer[line];
            y = 11 + 14 * line;
            format = EnumChatFormatting.RESET + "";
            for (int index = 0; index < text.length(); ++index) {
                int x2 = 11 + 7 * index;
                c = text.charAt(index);
                x2 += (7 - this.field_146289_q.func_78263_a((char)c)) / 2;
                if (c == 167 && text.length() > index + 1) {
                    format = "\u00a7" + text.charAt(index + 1);
                    x2 -= 3;
                }
                glyph = format + (char)c;
                if (c == 7) {
                    glyph = EnumChatFormatting.RED + "B";
                }
                if (c == 12) {
                    glyph = EnumChatFormatting.RED + "P";
                }
                if (c == 127) {
                    glyph = EnumChatFormatting.RED + "<";
                }
                if (c == 22) {
                    glyph = EnumChatFormatting.RED + "W";
                }
                this.field_146289_q.func_78276_b(glyph, this.guiLeft + x2, this.guiTop + y, 65280);
            }
            if (System.currentTimeMillis() % 1000L >= 500L || !this.textFocus) continue;
            x = Math.max(11 + 7 * (text.length() - 1) + 7, 11);
            if (this.cursorPos != line) continue;
            this.field_146289_q.func_78276_b("|", this.guiLeft + x, this.guiTop + y, 65280);
        }
        for (line = 0; line < 5; ++line) {
            text = this.telex.rxBuffer[line];
            y = 145 + 14 * line;
            format = EnumChatFormatting.RESET + "";
            x = 11;
            for (int index = 0; index < text.length(); ++index) {
                c = text.charAt(index);
                x += (7 - this.field_146289_q.func_78263_a((char)c)) / 2;
                if (c == 167 && text.length() > index + 1) {
                    format = "\u00a7" + text.charAt(index + 1);
                    c = 32;
                } else if (c == 167) {
                    c = 32;
                } else if (index > 0 && text.charAt(index - 1) == '\u00a7') {
                    c = 32;
                    x -= 14;
                }
                glyph = format + (char)c;
                this.field_146289_q.func_78276_b(glyph, this.guiLeft + x, this.guiTop + y, 65280);
                x += 7;
            }
        }
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)3.0f);
        Random rand = new Random(this.telex.sendingChar);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(1);
        tess.func_78378_d(65280);
        double offset = 0.0;
        for (int i = 0; i < 48; ++i) {
            tess.func_78377_a((double)(this.guiLeft + 199 + i), (double)this.guiTop + 93.5 + offset, (double)(this.field_73735_i + 10.0f));
            offset = this.telex.sendingChar != ' ' && i > 4 && i < 43 ? rand.nextGaussian() * 7.0 : 0.0;
            offset = MathHelper.func_151237_a((double)offset, (double)-7.0, (double)7.0);
            tess.func_78377_a((double)(this.guiLeft + 199 + i + 1), (double)this.guiTop + 93.5 + offset, (double)(this.field_73735_i + 10.0f));
        }
        tess.func_78381_a();
        GL11.glEnable((int)3553);
    }

    protected void func_73864_a(int x, int y, int i) {
        int j;
        NBTTagCompound data;
        super.func_73864_a(x, y, i);
        this.txFrequency.func_146192_a(x, y, i);
        this.rxFrequency.func_146192_a(x, y, i);
        this.textFocus = this.guiLeft + 7 <= x && this.guiLeft + 7 + 242 > x && this.guiTop + 7 < y && this.guiTop + 7 + 74 >= y;
        char character = '\u0000';
        String cmd = null;
        if (this.checkClick(x, y, 7, 85, 18, 18)) {
            character = '\u0007';
        }
        if (this.checkClick(x, y, 27, 85, 18, 18)) {
            character = '\f';
        }
        if (this.checkClick(x, y, 47, 85, 18, 18)) {
            character = '\u007f';
        }
        if (this.checkClick(x, y, 67, 85, 18, 18)) {
            character = '\u00a7';
        }
        if (this.checkClick(x, y, 87, 85, 18, 18)) {
            character = '\u0016';
        }
        if (this.checkClick(x, y, 127, 105, 18, 18) || this.checkClick(x, y, 127, 219, 18, 18)) {
            cmd = "sve";
        }
        if (this.checkClick(x, y, 147, 105, 18, 18)) {
            cmd = "snd";
        }
        if (this.checkClick(x, y, 167, 105, 18, 18)) {
            cmd = "rxdel";
            for (int j2 = 0; j2 < 5; ++j2) {
                this.txBuffer[j2] = "";
            }
            data = new NBTTagCompound();
            for (j = 0; j < 5; ++j) {
                data.func_74778_a("tx" + j, this.txBuffer[j]);
            }
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.telex.field_145851_c, this.telex.field_145848_d, this.telex.field_145849_e));
        }
        if (this.checkClick(x, y, 147, 219, 18, 18)) {
            cmd = "rxprt";
        }
        if (this.checkClick(x, y, 167, 219, 18, 18)) {
            cmd = "rxcls";
        }
        if (cmd != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            data = new NBTTagCompound();
            data.func_74778_a("cmd", cmd);
            if ("snd".equals(cmd)) {
                for (j = 0; j < 5; ++j) {
                    data.func_74778_a("tx" + j, this.txBuffer[j]);
                }
            }
            if ("sve".equals(cmd)) {
                data.func_74778_a("txChan", this.txFrequency.func_146179_b());
                data.func_74778_a("rxChan", this.rxFrequency.func_146179_b());
            }
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.telex.field_145851_c, this.telex.field_145848_d, this.telex.field_145849_e));
        }
        if (character != '\u0000') {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            this.setTextFocus();
            this.submitChar(character);
        }
    }

    protected boolean checkClick(int x, int y, int left, int top, int sizeX, int sizeY) {
        return this.guiLeft + left <= x && this.guiLeft + left + sizeX > x && this.guiTop + top < y && this.guiTop + top + sizeY >= y;
    }

    protected void setTextFocus() {
        this.textFocus = true;
        this.txFrequency.func_146195_b(false);
        this.rxFrequency.func_146195_b(false);
    }

    protected void func_73869_a(char c, int i) {
        if (this.txFrequency.func_146201_a(c, i)) {
            return;
        }
        if (this.rxFrequency.func_146201_a(c, i)) {
            return;
        }
        if (this.textFocus) {
            if (i == 1) {
                this.textFocus = false;
                return;
            }
            if (i == 200) {
                --this.cursorPos;
            }
            if (i == 208) {
                ++this.cursorPos;
            }
            this.cursorPos = MathHelper.func_76125_a((int)this.cursorPos, (int)0, (int)4);
            if (ChatAllowedCharacters.func_71566_a((char)c)) {
                this.submitChar(c);
                return;
            }
            if (i == 14 && this.txBuffer[this.cursorPos].length() > 0) {
                this.txBuffer[this.cursorPos] = this.txBuffer[this.cursorPos].substring(0, this.txBuffer[this.cursorPos].length() - 1);
            }
        }
        if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
            this.field_146297_k.func_71381_h();
        }
    }

    protected void submitChar(char c) {
        String line = this.txBuffer[this.cursorPos];
        if (line.length() < 33) {
            this.txBuffer[this.cursorPos] = line + c;
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        NBTTagCompound data = new NBTTagCompound();
        for (int j = 0; j < 5; ++j) {
            data.func_74778_a("tx" + j, this.txBuffer[j]);
        }
        PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.telex.field_145851_c, this.telex.field_145848_d, this.telex.field_145849_e));
    }

    public boolean func_73868_f() {
        return false;
    }
}

