/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes.anvil;

import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.anvil.AnvilSmithingRecipe;
import com.hbm.items.special.ItemHot;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AnvilSmithingHotRecipe
extends AnvilSmithingRecipe {
    public AnvilSmithingHotRecipe(int tier, ItemStack out, RecipesCommon.AStack left, RecipesCommon.AStack right) {
        super(tier, out, left, right);
    }

    @Override
    public boolean doesStackMatch(ItemStack input, RecipesCommon.AStack recipe) {
        double heat;
        if (input != null && input.func_77973_b() instanceof ItemHot && (heat = ItemHot.getHeat(input)) < 0.5) {
            return false;
        }
        return recipe.matchesRecipe(input, false);
    }

    @Override
    public ItemStack getOutput(ItemStack left, ItemStack right) {
        if (left.func_77973_b() instanceof ItemHot && right.func_77973_b() instanceof ItemHot && this.output.func_77973_b() instanceof ItemHot) {
            double h1 = ItemHot.getHeat(left);
            double h2 = ItemHot.getHeat(right);
            ItemStack out = this.output.func_77946_l();
            ItemHot.heatUp(out, (h1 + h2) / 2.0);
            return out;
        }
        return this.output.func_77946_l();
    }

    @Override
    public List<ItemStack> getLeft() {
        return Arrays.asList(this.getHot(this.left));
    }

    @Override
    public List<ItemStack> getRight() {
        return Arrays.asList(this.getHot(this.right));
    }

    private ItemStack getHot(RecipesCommon.AStack stack) {
        ItemStack first = stack.extractForNEI().get(0);
        if (first.func_77973_b() instanceof ItemHot) {
            ItemHot.heatUp(first);
        }
        return first;
    }
}

