/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes.anvil;

import com.hbm.config.GeneralConfig;
import com.hbm.inventory.RecipesCommon;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AnvilSmithingRecipe {
    public int tier;
    ItemStack output;
    RecipesCommon.AStack left;
    RecipesCommon.AStack right;
    boolean shapeless = false;

    public AnvilSmithingRecipe(int tier, ItemStack out, RecipesCommon.AStack left, RecipesCommon.AStack right) {
        this.tier = tier;
        this.output = out;
        this.left = left;
        this.right = right;
        if (GeneralConfig.enableLBSMShorterDecay && GeneralConfig.enableLBSMUnlockAnvil) {
            this.tier = 1;
        }
    }

    public AnvilSmithingRecipe makeShapeless() {
        this.shapeless = true;
        return this;
    }

    public boolean matches(ItemStack left, ItemStack right) {
        return this.matchesInt(left, right) != -1;
    }

    public int matchesInt(ItemStack left, ItemStack right) {
        if (this.doesStackMatch(left, this.left) && this.doesStackMatch(right, this.right)) {
            return 0;
        }
        if (this.shapeless) {
            return this.doesStackMatch(right, this.left) && this.doesStackMatch(left, this.right) ? 1 : -1;
        }
        return -1;
    }

    public boolean doesStackMatch(ItemStack input, RecipesCommon.AStack recipe) {
        return recipe.matchesRecipe(input, false);
    }

    public List<ItemStack> getLeft() {
        return this.left.extractForNEI();
    }

    public List<ItemStack> getRight() {
        return this.right.extractForNEI();
    }

    public ItemStack getSimpleOutput() {
        return this.output.func_77946_l();
    }

    public ItemStack getOutput(ItemStack left, ItemStack right) {
        return this.getSimpleOutput();
    }

    public int amountConsumed(int index, boolean mirrored) {
        if (index == 0) {
            return mirrored ? this.right.stacksize : this.left.stacksize;
        }
        if (index == 1) {
            return mirrored ? this.left.stacksize : this.right.stacksize;
        }
        return 0;
    }
}

