/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items;

import com.hbm.interfaces.IOrderedEnum;
import com.hbm.util.EnumUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemEnumMulti
extends Item {
    protected Class<? extends Enum> theEnum;
    protected boolean multiName;
    protected boolean multiTexture;
    protected IIcon[] icons;

    public ItemEnumMulti(Class<? extends Enum> theEnum, boolean multiName, boolean multiTexture) {
        this.func_77627_a(true);
        this.theEnum = theEnum;
        this.multiName = multiName;
        this.multiTexture = multiTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        Enum[] order = this.theEnum.getEnumConstants();
        if (order[0] instanceof IOrderedEnum) {
            order = ((IOrderedEnum)((Object)order[0])).getOrder();
        }
        for (int i = 0; i < order.length; ++i) {
            list.add(new ItemStack(item, 1, order[i].ordinal()));
        }
    }

    public Item func_77655_b(String unlocalizedName) {
        super.func_77655_b(unlocalizedName);
        this.func_111206_d("hbm:" + unlocalizedName);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        if (this.multiTexture) {
            Enum[] enums = this.theEnum.getEnumConstants();
            this.icons = new IIcon[enums.length];
            for (int i = 0; i < this.icons.length; ++i) {
                Enum num = enums[i];
                this.icons[i] = reg.func_94245_a(this.func_111208_A() + "." + num.name().toLowerCase(Locale.US));
            }
        } else {
            this.field_77791_bV = reg.func_94245_a(this.func_111208_A());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (this.multiTexture) {
            Object num = EnumUtil.grabEnumSafely(this.theEnum, meta);
            return this.icons[((Enum)num).ordinal()];
        }
        return this.field_77791_bV;
    }

    public ItemStack stackFromEnum(int count, Enum num) {
        if (num.getClass() != this.theEnum) {
            return null;
        }
        return new ItemStack((Item)this, count, num.ordinal());
    }

    public ItemStack stackFromEnum(Enum num) {
        return this.stackFromEnum(1, num);
    }

    public String func_77667_c(ItemStack stack) {
        if (this.multiName) {
            Object num = EnumUtil.grabEnumSafely(this.theEnum, stack.func_77960_j());
            return super.func_77658_a() + "." + ((Enum)num).name().toLowerCase(Locale.US);
        }
        return super.func_77667_c(stack);
    }
}

