/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.Multimap;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.items.armor.ArmorFSBPowered;
import com.hbm.items.armor.ItemModNightVision;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.model.ModelArmorEnvsuit;
import com.hbm.render.tileentity.IItemRendererProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ArmorEnvsuit
extends ArmorFSBPowered
implements IItemRendererProvider {
    @SideOnly(value=Side.CLIENT)
    ModelArmorEnvsuit[] models;
    private static final UUID speed = UUID.fromString("6ab858ba-d712-485c-bae9-e5e765fc555a");

    public ArmorEnvsuit(ItemArmor.ArmorMaterial material, int slot, String texture, long maxPower, long chargeRate, long consumption, long drain) {
        super(material, slot, texture, maxPower, chargeRate, consumption, drain);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.models == null) {
            this.models = new ModelArmorEnvsuit[4];
            for (int i = 0; i < 4; ++i) {
                this.models[i] = new ModelArmorEnvsuit(i);
            }
        }
        return this.models[armorSlot];
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this != ModItems.envsuit_plate) {
            return;
        }
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(speed, "SQUIRREL SPEED", 0.1, 0));
        player.func_110140_aT().func_111148_a(multimap);
        if (ArmorEnvsuit.hasFSBArmor(player)) {
            if (player.func_70051_ag()) {
                player.func_110140_aT().func_111147_b(multimap);
            }
            if (player.func_70090_H()) {
                if (!world.field_72995_K) {
                    player.func_70050_g(300);
                    player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0));
                }
                double mo = 0.1 * (double)player.field_70701_bs;
                Vec3 vec = player.func_70040_Z();
                vec.field_72450_a *= mo;
                vec.field_72448_b *= mo;
                vec.field_72449_c *= mo;
                player.field_70159_w += vec.field_72450_a;
                player.field_70181_x += vec.field_72448_b;
                player.field_70179_y += vec.field_72449_c;
            } else {
                boolean canRemoveNightVision = true;
                ItemStack helmet = player.field_71071_by.field_70460_b[3];
                ItemStack helmetMod = ArmorModHandler.pryMod(helmet, 0);
                if (helmetMod != null && helmetMod.func_77973_b() instanceof ItemModNightVision) {
                    canRemoveNightVision = false;
                }
                if (!world.field_72995_K && canRemoveNightVision) {
                    player.func_82170_o(Potion.field_76439_r.field_76415_H);
                }
            }
        }
    }

    @Override
    public Item getItemForRenderer() {
        return this;
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                ArmorFSB.setupRenderInv();
            }

            @Override
            public void renderNonInv() {
                ArmorFSB.setupRenderNonInv();
            }

            @Override
            public void renderCommon() {
                if (ArmorEnvsuit.this.field_77881_a == 0) {
                    GL11.glScaled((double)0.3125, (double)0.3125, (double)0.3125);
                    GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.envsuit_helmet);
                    ResourceManager.armor_envsuit.renderPart("Helmet");
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)3553);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.8f);
                    ResourceManager.armor_envsuit.renderPart("Lamps");
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)3553);
                    GL11.glEnable((int)2896);
                } else {
                    ArmorFSB.renderStandard(ResourceManager.armor_envsuit, ArmorEnvsuit.this.field_77881_a, ResourceManager.envsuit_helmet, ResourceManager.envsuit_chest, ResourceManager.envsuit_arm, ResourceManager.envsuit_leg, "Helmet,Lamps", "Chest", "LeftArm", "RightArm", "LeftLeg", "RightLeg", "LeftFoot", "RightFoot");
                }
            }
        };
    }
}

