/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemRBMKPellet;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemRBMKRod
extends Item {
    public ItemRBMKPellet pellet;
    public String fullName = "";
    public double reactivity;
    public double selfRate;
    public EnumBurnFunc function = EnumBurnFunc.LOG_TEN;
    public EnumDepleteFunc depFunc = EnumDepleteFunc.GENTLE_SLOPE;
    public double xGen = 0.5;
    public double xBurn = 50.0;
    public double heat = 1.0;
    public double yield;
    public double meltingPoint = 1000.0;
    public double diffusion = 0.02;
    public IRBMKFluxReceiver.NType nType = IRBMKFluxReceiver.NType.SLOW;
    public IRBMKFluxReceiver.NType rType = IRBMKFluxReceiver.NType.FAST;
    public static List<ItemRBMKRod> craftableRods = new ArrayList<ItemRBMKRod>();
    public boolean specialFluxCurve = false;
    BiFunction<Double, Double, Double> ratioCurve;
    BiFunction<Double, Double, Double> fluxCurve;

    public ItemRBMKRod(ItemRBMKPellet pellet) {
        this(pellet.fullName);
        this.pellet = pellet;
        craftableRods.add(this);
    }

    public ItemRBMKRod(String fullName) {
        this.fullName = fullName;
        this.func_77642_a(ModItems.rbmk_fuel_empty);
        this.func_77625_d(1);
        this.func_77637_a(MainRegistry.controlTab);
    }

    public ItemRBMKRod setYield(double yield) {
        this.yield = yield;
        return this;
    }

    public ItemRBMKRod setStats(double funcEnd) {
        return this.setStats(funcEnd, 0.0);
    }

    public ItemRBMKRod setStats(double funcEnd, double selfRate) {
        this.reactivity = funcEnd;
        this.selfRate = selfRate;
        return this;
    }

    public ItemRBMKRod setFunction(EnumBurnFunc func) {
        this.function = func;
        return this;
    }

    public ItemRBMKRod setDepletionFunction(EnumDepleteFunc func) {
        this.depFunc = func;
        return this;
    }

    public ItemRBMKRod setXenon(double gen, double burn) {
        this.xGen = gen;
        this.xBurn = burn;
        return this;
    }

    public ItemRBMKRod setHeat(double heat) {
        this.heat = heat;
        return this;
    }

    public ItemRBMKRod setDiffusion(double diffusion) {
        this.diffusion = diffusion;
        return this;
    }

    public ItemRBMKRod setMeltingPoint(double meltingPoint) {
        this.meltingPoint = meltingPoint;
        return this;
    }

    public ItemRBMKRod setNeutronTypes(IRBMKFluxReceiver.NType nType, IRBMKFluxReceiver.NType rType) {
        this.nType = nType;
        this.rType = rType;
        return this;
    }

    public double burn(World world, ItemStack stack, double inFlux) {
        inFlux += this.selfRate;
        if (RBMKDials.getXenon(world)) {
            double xenon = ItemRBMKRod.getPoison(stack);
            xenon -= this.xenonBurnFunc(inFlux);
            if ((xenon += this.xenonGenFunc(inFlux *= 1.0 - ItemRBMKRod.getPoisonLevel(stack))) < 0.0) {
                xenon = 0.0;
            }
            if (xenon > 100.0) {
                xenon = 100.0;
            }
            ItemRBMKRod.setPoison(stack, xenon);
        }
        double outFlux = this.reactivityFunc(inFlux, ItemRBMKRod.getEnrichment(stack)) * RBMKDials.getReactivityMod(world);
        if (RBMKDials.getDepletion(world)) {
            double y = ItemRBMKRod.getYield(stack);
            if ((y -= inFlux) < 0.0) {
                y = 0.0;
            }
            ItemRBMKRod.setYield(stack, y);
        }
        double coreHeat = ItemRBMKRod.getCoreHeat(stack);
        ItemRBMKRod.setCoreHeat(stack, this.rectify(coreHeat += outFlux * this.heat));
        return outFlux;
    }

    private double rectify(double num) {
        if (num > 1000000.0) {
            num = 1000000.0;
        }
        if (num < 20.0 || Double.isNaN(num)) {
            num = 20.0;
        }
        return num;
    }

    public void updateHeat(World world, ItemStack stack, double mod) {
        double coreHeat = ItemRBMKRod.getCoreHeat(stack);
        double hullHeat = ItemRBMKRod.getHullHeat(stack);
        if (coreHeat > hullHeat) {
            double mid = (coreHeat - hullHeat) / 2.0;
            ItemRBMKRod.setCoreHeat(stack, this.rectify(coreHeat -= mid * this.diffusion * RBMKDials.getFuelDiffusionMod(world) * mod));
            ItemRBMKRod.setHullHeat(stack, this.rectify(hullHeat += mid * this.diffusion * RBMKDials.getFuelDiffusionMod(world) * mod));
        }
    }

    public double provideHeat(World world, ItemStack stack, double heat, double mod) {
        double hullHeat = ItemRBMKRod.getHullHeat(stack);
        if (hullHeat > this.meltingPoint) {
            double coreHeat = ItemRBMKRod.getCoreHeat(stack);
            double avg = (heat + hullHeat + coreHeat) / 3.0;
            ItemRBMKRod.setCoreHeat(stack, avg);
            ItemRBMKRod.setHullHeat(stack, avg);
            return avg - heat;
        }
        if (hullHeat <= heat) {
            return 0.0;
        }
        double ret = (hullHeat - heat) / 2.0;
        ItemRBMKRod.setHullHeat(stack, hullHeat -= (ret *= RBMKDials.getFuelHeatProvision(world) * mod));
        return ret;
    }

    public double reactivityFunc(double in, double enrichment) {
        double flux = in * this.reactivityModByEnrichment(enrichment);
        switch (this.function) {
            case PASSIVE: {
                return this.selfRate * enrichment;
            }
            case LOG_TEN: {
                return Math.log10(flux + 1.0) * 0.5 * this.reactivity;
            }
            case PLATEU: {
                return (1.0 - Math.pow(Math.E, -flux / 25.0)) * this.reactivity;
            }
            case ARCH: {
                return Math.max((flux - flux * flux / 10000.0) / 100.0 * this.reactivity, 0.0);
            }
            case SIGMOID: {
                return this.reactivity / (1.0 + Math.pow(Math.E, -(flux - 50.0) / 10.0));
            }
            case SQUARE_ROOT: {
                return Math.sqrt(flux) * this.reactivity / 10.0;
            }
            case LINEAR: {
                return flux / 100.0 * this.reactivity;
            }
            case QUADRATIC: {
                return flux * flux / 10000.0 * this.reactivity;
            }
            case EXPERIMENTAL: {
                return flux * (Math.sin(flux) + 1.0) * this.reactivity;
            }
        }
        return 0.0;
    }

    public String getFuncDescription(ItemStack stack) {
        String function;
        switch (this.function) {
            case PASSIVE: {
                function = EnumChatFormatting.RED + "" + this.selfRate;
                break;
            }
            case LOG_TEN: {
                function = "log10(%1$s + 1) * 0.5 * %2$s";
                break;
            }
            case PLATEU: {
                function = "(1 - e^(-%1$s / 25)) * %2$s";
                break;
            }
            case ARCH: {
                function = "(%1$s - %1$s\u00b2 / 10000) / 100 * %2$s [0;\u221e]";
                break;
            }
            case SIGMOID: {
                function = "%2$s / (1 + e^(-(%1$s - 50) / 10))";
                break;
            }
            case SQUARE_ROOT: {
                function = "sqrt(%1$s) * %2$s / 10";
                break;
            }
            case LINEAR: {
                function = "%1$s / 100 * %2$s";
                break;
            }
            case QUADRATIC: {
                function = "%1$s\u00b2 / 10000 * %2$s";
                break;
            }
            case EXPERIMENTAL: {
                function = "%1$s * (sin(%1$s) + 1) * %2$s";
                break;
            }
            default: {
                function = "ERROR";
            }
        }
        double enrichment = ItemRBMKRod.getEnrichment(stack);
        if (enrichment < 1.0) {
            enrichment = this.reactivityModByEnrichment(enrichment);
            String reactivity = EnumChatFormatting.YELLOW + "" + (double)((int)(this.reactivity * enrichment * 1000.0)) / 1000.0 + EnumChatFormatting.WHITE;
            String enrichmentPer = EnumChatFormatting.GOLD + " (" + (double)((int)(enrichment * 1000.0)) / 10.0 + "%)";
            return String.format(Locale.US, function, this.selfRate > 0.0 ? "(x" + EnumChatFormatting.RED + " + " + this.selfRate + "" + EnumChatFormatting.WHITE + ")" : "x", reactivity).concat(enrichmentPer);
        }
        return String.format(Locale.US, function, this.selfRate > 0.0 ? "(x" + EnumChatFormatting.RED + " + " + this.selfRate + "" + EnumChatFormatting.WHITE + ")" : "x", this.reactivity);
    }

    public double reactivityModByEnrichment(double enrichment) {
        switch (this.depFunc) {
            default: {
                return enrichment;
            }
            case STATIC: {
                return 1.0;
            }
            case BOOSTED_SLOPE: {
                return enrichment + Math.sin((enrichment - 1.0) * (enrichment - 1.0) * Math.PI);
            }
            case RAISING_SLOPE: {
                return enrichment + Math.sin(enrichment * Math.PI) / 2.0;
            }
            case GENTLE_SLOPE: 
        }
        return enrichment + Math.sin(enrichment * Math.PI) / 3.0;
    }

    public double xenonGenFunc(double flux) {
        return flux * this.xGen;
    }

    public double xenonBurnFunc(double flux) {
        return flux * flux / this.xBurn;
    }

    public static double getEnrichment(ItemStack stack) {
        return ItemRBMKRod.getYield(stack) / ((ItemRBMKRod)stack.func_77973_b()).yield;
    }

    public static double getPoisonLevel(ItemStack stack) {
        return ItemRBMKRod.getPoison(stack) / 100.0;
    }

    public ItemRBMKRod setFluxCurve(boolean bool) {
        this.specialFluxCurve = bool;
        return this;
    }

    public ItemRBMKRod setOutputRatioCurve(Function<Double, Double> func) {
        this.ratioCurve = (fluxRatioIn, depletion) -> (Double)func.apply((Double)fluxRatioIn) * 1.0;
        return this;
    }

    public ItemRBMKRod setDepletionOutputRatioCurve(BiFunction<Double, Double, Double> func) {
        this.ratioCurve = func;
        return this;
    }

    public ItemRBMKRod setOutputFluxCurve(BiFunction<Double, Double, Double> func) {
        this.fluxCurve = func;
        return this;
    }

    public double fluxRatioOut(double fluxRatioIn, double depletion) {
        return MathHelper.func_151237_a((double)this.ratioCurve.apply(fluxRatioIn, depletion), (double)0.0, (double)1.0);
    }

    public double fluxFromRatio(double quantity, double ratio) {
        return this.fluxCurve.apply(quantity, ratio);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.ITALIC + this.fullName);
        if (this == ModItems.rbmk_fuel_drx) {
            if (ItemRBMKRod.getHullHeat(stack) >= 50.0 || ItemRBMKRod.getCoreHeat(stack) >= 50.0) {
                list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("desc.item.wasteCooling", new Object[0]));
            }
            if (this.selfRate > 0.0 || this.function == EnumBurnFunc.SIGMOID) {
                list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("trait.rbmx.source", new Object[0]));
            }
            list.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("trait.rbmx.depletion", (double)((int)((this.yield - ItemRBMKRod.getYield(stack)) / this.yield * 100000.0)) / 1000.0 + "%"));
            list.add(EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("trait.rbmx.xenon", (double)((int)(ItemRBMKRod.getPoison(stack) * 1000.0)) / 1000.0 + "%"));
            list.add(EnumChatFormatting.BLUE + I18nUtil.resolveKey("trait.rbmx.splitsWith", I18nUtil.resolveKey(this.nType.unlocalized + ".x", new Object[0])));
            list.add(EnumChatFormatting.BLUE + I18nUtil.resolveKey("trait.rbmx.splitsInto", I18nUtil.resolveKey(this.rType.unlocalized + ".x", new Object[0])));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmx.fluxFunc", EnumChatFormatting.WHITE + this.getFuncDescription(stack)));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmx.funcType", this.function.title));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmx.xenonGen", EnumChatFormatting.WHITE + "x * " + this.xGen));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmx.xenonBurn", EnumChatFormatting.WHITE + "x\u00b2 / " + this.xBurn));
            list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("trait.rbmx.heat", this.heat + "\u00b0C"));
            list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("trait.rbmx.diffusion", this.diffusion + "\u00b9/\u00b2"));
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("trait.rbmx.skinTemp", (double)((int)(ItemRBMKRod.getHullHeat(stack) * 10.0)) / 10.0 + "m"));
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("trait.rbmx.coreTemp", (double)((int)(ItemRBMKRod.getCoreHeat(stack) * 10.0)) / 10.0 + "m"));
            list.add(EnumChatFormatting.DARK_RED + I18nUtil.resolveKey("trait.rbmx.melt", this.meltingPoint + "m"));
        } else {
            if (ItemRBMKRod.getHullHeat(stack) >= 50.0 || ItemRBMKRod.getCoreHeat(stack) >= 50.0) {
                list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("desc.item.wasteCooling", new Object[0]));
            }
            if (this.selfRate > 0.0 || this.function == EnumBurnFunc.SIGMOID) {
                list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("trait.rbmk.source", new Object[0]));
            }
            list.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("trait.rbmk.depletion", (double)((int)((this.yield - ItemRBMKRod.getYield(stack)) / this.yield * 100000.0)) / 1000.0 + "%"));
            list.add(EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("trait.rbmk.xenon", (double)((int)(ItemRBMKRod.getPoison(stack) * 1000.0)) / 1000.0 + "%"));
            list.add(EnumChatFormatting.BLUE + I18nUtil.resolveKey("trait.rbmk.splitsWith", I18nUtil.resolveKey(this.nType.unlocalized, new Object[0])));
            list.add(EnumChatFormatting.BLUE + I18nUtil.resolveKey("trait.rbmk.splitsInto", I18nUtil.resolveKey(this.rType.unlocalized, new Object[0])));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.fluxFunc", EnumChatFormatting.WHITE + this.getFuncDescription(stack)));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.funcType", this.function.title));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.xenonGen", EnumChatFormatting.WHITE + "x * " + this.xGen));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.xenonBurn", EnumChatFormatting.WHITE + "x\u00b2 / " + this.xBurn));
            list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("trait.rbmk.heat", this.heat + "\u00b0C"));
            list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("trait.rbmk.diffusion", this.diffusion + "\u00b9/\u00b2"));
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("trait.rbmk.skinTemp", (double)((int)(ItemRBMKRod.getHullHeat(stack) * 10.0)) / 10.0 + "\u00b0C"));
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("trait.rbmk.coreTemp", (double)((int)(ItemRBMKRod.getCoreHeat(stack) * 10.0)) / 10.0 + "\u00b0C"));
            list.add(EnumChatFormatting.DARK_RED + I18nUtil.resolveKey("trait.rbmk.melt", this.meltingPoint + "\u00b0C"));
        }
        super.func_77624_a(stack, player, list, bool);
    }

    public static void setYield(ItemStack stack, double yield) {
        ItemRBMKRod.setDouble(stack, "yield", yield);
    }

    public static double getYield(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemRBMKRod) {
            return ItemRBMKRod.getDouble(stack, "yield");
        }
        return 0.0;
    }

    public static void setPoison(ItemStack stack, double xenon) {
        ItemRBMKRod.setDouble(stack, "xenon", xenon);
    }

    public static double getPoison(ItemStack stack) {
        return ItemRBMKRod.getDouble(stack, "xenon");
    }

    public static void setCoreHeat(ItemStack stack, double heat) {
        ItemRBMKRod.setDouble(stack, "core", heat);
    }

    public static double getCoreHeat(ItemStack stack) {
        return ItemRBMKRod.getDouble(stack, "core");
    }

    public static void setHullHeat(ItemStack stack, double heat) {
        ItemRBMKRod.setDouble(stack, "hull", heat);
    }

    public static double getHullHeat(ItemStack stack) {
        return ItemRBMKRod.getDouble(stack, "hull");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemRBMKRod.getEnrichment(stack);
    }

    public static void setDouble(ItemStack stack, String key, double yield) {
        if (!stack.func_77942_o()) {
            ItemRBMKRod.setNBTDefaults(stack);
        }
        stack.field_77990_d.func_74780_a(key, yield);
    }

    public static double getDouble(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            ItemRBMKRod.setNBTDefaults(stack);
        }
        return stack.field_77990_d.func_74769_h(key);
    }

    private static void setNBTDefaults(ItemStack stack) {
        stack.field_77990_d = new NBTTagCompound();
        ItemRBMKRod.setYield(stack, ((ItemRBMKRod)stack.func_77973_b()).yield);
        ItemRBMKRod.setCoreHeat(stack, 20.0);
        ItemRBMKRod.setHullHeat(stack, 20.0);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        ItemRBMKRod.setNBTDefaults(stack);
    }

    public static enum EnumDepleteFunc {
        LINEAR,
        RAISING_SLOPE,
        BOOSTED_SLOPE,
        GENTLE_SLOPE,
        STATIC;

    }

    public static enum EnumBurnFunc {
        PASSIVE(EnumChatFormatting.DARK_GREEN + "SAFE / PASSIVE"),
        LOG_TEN(EnumChatFormatting.YELLOW + "MEDIUM / LOGARITHMIC"),
        PLATEU(EnumChatFormatting.GREEN + "SAFE / EULER"),
        ARCH(EnumChatFormatting.RED + "DANGEROUS / NEGATIVE-QUADRATIC"),
        SIGMOID(EnumChatFormatting.GREEN + "SAFE / SIGMOID"),
        SQUARE_ROOT(EnumChatFormatting.YELLOW + "MEDIUM / SQUARE ROOT"),
        LINEAR(EnumChatFormatting.RED + "DANGEROUS / LINEAR"),
        QUADRATIC(EnumChatFormatting.RED + "DANGEROUS / QUADRATIC"),
        EXPERIMENTAL(EnumChatFormatting.RED + "EXPERIMENTAL / SINE SLOPE");

        public String title = "";

        private EnumBurnFunc(String title) {
            this.title = title;
        }
    }
}

