/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.ItemEnumMulti;
import com.hbm.util.BobMathUtil;
import com.hbm.util.EnumUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class ItemZirnoxRod
extends ItemEnumMulti {
    public ItemZirnoxRod() {
        super(EnumZirnoxType.class, true, true);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public static void incrementLifeTime(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        int time = stack.field_77990_d.func_74762_e("life");
        stack.field_77990_d.func_74768_a("life", time + 1);
    }

    public static void setLifeTime(ItemStack stack, int time) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("life", time);
    }

    public static int getLifeTime(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
            return 0;
        }
        return stack.field_77990_d.func_74762_e("life");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        EnumZirnoxType num = (EnumZirnoxType)((Object)EnumUtil.grabEnumSafely(this.theEnum, stack.func_77960_j()));
        return (double)ItemZirnoxRod.getLifeTime(stack) / (double)num.maxLife;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        EnumZirnoxType num = (EnumZirnoxType)((Object)EnumUtil.grabEnumSafely(this.theEnum, stack.func_77960_j()));
        list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.depletion", (double)((int)((double)ItemZirnoxRod.getLifeTime(stack) / (double)num.maxLife * 100000.0)) / 1000.0 + "%"));
        String[] loc = I18nUtil.resolveKeyArray("desc.item.zirnox" + (num.breeding ? "BreedingRod" : "Rod"), BobMathUtil.getShortNumber(num.maxLife));
        loc = num.breeding ? I18nUtil.resolveKeyArray("desc.item.zirnoxBreedingRod", BobMathUtil.getShortNumber(num.maxLife)) : I18nUtil.resolveKeyArray("desc.item.zirnoxRod", num.heat, BobMathUtil.getShortNumber(num.maxLife));
        for (String s : loc) {
            list.add(s);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        Enum[] enums = (Enum[])this.theEnum.getEnumConstants();
        this.icons = new IIcon[enums.length];
        for (int i = 0; i < this.icons.length; ++i) {
            Enum num = enums[i];
            this.icons[i] = reg.func_94245_a(this.func_111208_A() + "_" + num.name().toLowerCase(Locale.US));
        }
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        Object num = EnumUtil.grabEnumSafely(this.theEnum, stack.func_77960_j());
        return super.func_77658_a() + "_" + ((Enum)num).name().toLowerCase(Locale.US);
    }

    public static enum EnumZirnoxType {
        NATURAL_URANIUM_FUEL(250000, 30),
        URANIUM_FUEL(200000, 50),
        TH232(20000, 0, true),
        THORIUM_FUEL(200000, 40),
        MOX_FUEL(165000, 75),
        PLUTONIUM_FUEL(175000, 65),
        U233_FUEL(150000, 100),
        U235_FUEL(165000, 85),
        LES_FUEL(150000, 150),
        LITHIUM(20000, 0, true),
        ZFB_MOX(50000, 35);

        public final int maxLife;
        public final int heat;
        public final boolean breeding;

        private EnumZirnoxType(int life, int heat, boolean breeding) {
            this.maxLife = life;
            this.heat = heat;
            this.breeding = breeding;
        }

        private EnumZirnoxType(int life, int heat) {
            this.maxLife = life;
            this.heat = heat;
            this.breeding = false;
        }
    }
}

