/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.entity.cart.EntityMinecartCrate;
import com.hbm.entity.cart.EntityMinecartDestroyer;
import com.hbm.entity.cart.EntityMinecartOre;
import com.hbm.entity.cart.EntityMinecartPowder;
import com.hbm.entity.cart.EntityMinecartSemtex;
import com.hbm.items.ModItems;
import com.hbm.util.EnumUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemModMinecart
extends Item {
    private IIcon[] icons;
    private IIcon[] bases = new IIcon[4];
    public static final String CART_BASE_NBT = "cartBase";
    private static final IBehaviorDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem(){
        private final BehaviorDefaultDispenseItem behaviourDefaultDispenseItem = new BehaviorDefaultDispenseItem();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            double yOffset;
            int iZ;
            int iY;
            EnumFacing enumfacing = BlockDispenser.func_149937_b((int)source.func_82620_h());
            World world = source.func_82618_k();
            double x = source.func_82615_a() + (double)enumfacing.func_82601_c() * 1.125;
            double y = source.func_82617_b() + (double)enumfacing.func_96559_d() * 1.125;
            double z = source.func_82616_c() + (double)enumfacing.func_82599_e() * 1.125;
            int iX = source.func_82623_d() + enumfacing.func_82601_c();
            Block block = world.func_147439_a(iX, iY = source.func_82622_e() + enumfacing.func_96559_d(), iZ = source.func_82621_f() + enumfacing.func_82599_e());
            if (BlockRailBase.func_150051_a((Block)block)) {
                yOffset = 0.0;
            } else {
                if (block.func_149688_o() != Material.field_151579_a || !BlockRailBase.func_150051_a((Block)world.func_147439_a(iX, iY - 1, iZ))) {
                    return this.behaviourDefaultDispenseItem.func_82482_a(source, stack);
                }
                yOffset = -1.0;
            }
            EntityMinecart entityminecart = ItemModMinecart.createMinecart(world, x, y + yOffset, z, stack);
            if (stack.func_82837_s()) {
                entityminecart.func_96094_a(stack.func_82833_r());
            }
            world.func_72838_d((Entity)entityminecart);
            stack.func_77979_a(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_82618_k().func_72926_e(1000, source.func_82623_d(), source.func_82622_e(), source.func_82621_f(), 0);
        }
    };

    public ItemModMinecart() {
        this.func_77625_d(4);
        this.func_77637_a(CreativeTabs.field_78029_e);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)dispenseBehavior);
    }

    public Item func_77655_b(String unlocalizedName) {
        super.func_77655_b(unlocalizedName);
        this.func_111206_d("hbm:" + unlocalizedName);
        return this;
    }

    public String func_77667_c(ItemStack stack) {
        EnumMinecart cart = (EnumMinecart)((Object)EnumUtil.grabEnumSafely(EnumMinecart.class, stack.func_77960_j()));
        return super.func_77658_a() + "." + cart.name().toLowerCase(Locale.US);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < EnumMinecart.values().length; ++i) {
            EnumMinecart cart = EnumMinecart.values()[i];
            for (EnumCartBase base : EnumCartBase.values()) {
                if (!cart.supportsBase(base)) continue;
                list.add(ItemModMinecart.createCartItem(base, cart));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        for (int i = 0; i < EnumCartBase.values().length; ++i) {
            EnumCartBase base = EnumCartBase.values()[i];
            this.bases[i] = reg.func_94245_a(this.func_111208_A() + "." + base.name().toLowerCase(Locale.US));
        }
        EnumMinecart[] enums = EnumMinecart.values();
        this.icons = new IIcon[enums.length];
        for (int i = 0; i < this.icons.length; ++i) {
            EnumMinecart num = enums[i];
            this.icons[i] = reg.func_94245_a(this.func_111208_A() + "_overlay." + num.name().toLowerCase(Locale.US));
        }
    }

    public static EnumCartBase getBaseType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return EnumCartBase.VANILLA;
        }
        int meta = stack.field_77990_d.func_74762_e(CART_BASE_NBT);
        return (EnumCartBase)((Object)EnumUtil.grabEnumSafely(EnumCartBase.class, meta));
    }

    public static ItemStack createCartItem(EnumCartBase base, EnumMinecart cart) {
        ItemStack stack = new ItemStack(ModItems.cart, 1, cart.ordinal());
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74768_a(CART_BASE_NBT, base.ordinal());
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            EnumCartBase base = ItemModMinecart.getBaseType(stack);
            return this.bases[base.ordinal()];
        }
        return this.icons[stack.func_77960_j()];
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer entity, World world, int x, int y, int z, int side, float fx, float fy, float fz) {
        if (BlockRailBase.func_150051_a((Block)world.func_147439_a(x, y, z))) {
            if (!world.field_72995_K) {
                EntityMinecart entityminecart = ItemModMinecart.createMinecart(world, (float)x + fx, (float)y + fy, (float)z + fz, stack);
                if (stack.func_82837_s()) {
                    entityminecart.func_96094_a(stack.func_82833_r());
                }
                world.func_72838_d((Entity)entityminecart);
            }
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    public static EntityMinecart createMinecart(World world, double x, double y, double z, ItemStack stack) {
        EnumMinecart type = EnumMinecart.values()[stack.func_77960_j()];
        EnumCartBase base = ItemModMinecart.getBaseType(stack);
        switch (type) {
            case CRATE: {
                return new EntityMinecartCrate(world, x, y, z, base, stack);
            }
            case DESTROYER: {
                return new EntityMinecartDestroyer(world, x, y, z, base);
            }
            case EMPTY: {
                return new EntityMinecartOre(world, x, y, z, base);
            }
            case POWDER: {
                return new EntityMinecartPowder(world, x, y, z, base);
            }
            case SEMTEX: {
                return new EntityMinecartSemtex(world, x, y, z, base);
            }
        }
        return new EntityMinecartEmpty(world, x, y, z);
    }

    public static enum EnumMinecart {
        EMPTY(EnumCartBase.WOOD, EnumCartBase.STEEL, EnumCartBase.PAINTED),
        CRATE(EnumCartBase.VANILLA),
        DESTROYER(EnumCartBase.STEEL, EnumCartBase.PAINTED),
        POWDER(EnumCartBase.WOOD, EnumCartBase.STEEL, EnumCartBase.PAINTED),
        SEMTEX(EnumCartBase.WOOD, EnumCartBase.STEEL, EnumCartBase.PAINTED);

        public int types;

        private EnumMinecart(EnumCartBase ... types) {
            this.types = 0;
            for (EnumCartBase type : types) {
                this.types |= 1 << type.ordinal();
            }
        }

        private EnumMinecart(int types) {
            this.types = types;
        }

        public boolean supportsBase(int type) {
            return (this.types & 1 << type) > 0;
        }

        public boolean supportsBase(EnumCartBase type) {
            return this.supportsBase(type.ordinal());
        }
    }

    public static enum EnumCartBase {
        VANILLA,
        WOOD,
        STEEL,
        PAINTED;

    }
}

