/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.fluidmk2.IFillableItem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.tool.ItemToolAbility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class ItemToolAbilityFueled
extends ItemToolAbility
implements IFillableItem {
    protected int fillRate;
    protected int consumption;
    protected int maxFuel;
    protected HashSet<FluidType> acceptedFuels = new HashSet();

    public ItemToolAbilityFueled(float damage, double movement, Item.ToolMaterial material, ItemToolAbility.EnumToolType type, int maxFuel, int consumption, int fillRate, FluidType ... acceptedFuels) {
        super(damage, movement, material, type);
        this.maxFuel = maxFuel;
        this.consumption = consumption;
        this.fillRate = fillRate;
        this.func_77656_e(1);
        for (FluidType fuel : acceptedFuels) {
            this.acceptedFuels.add(fuel);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.GOLD + "Fuel: " + this.getFill(stack) + "/" + this.maxFuel + "mB");
        for (FluidType type : this.acceptedFuels) {
            list.add(EnumChatFormatting.YELLOW + "- " + type.getLocalizedName());
        }
        super.func_77624_a(stack, player, list, ext);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getFill(stack) < this.maxFuel;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getFill(stack) / (double)this.maxFuel;
    }

    @Override
    public boolean canOperate(ItemStack stack) {
        return this.getFill(stack) >= this.consumption;
    }

    public void setDamage(ItemStack stack, int damage) {
        this.setFill(stack, Math.max(this.getFill(stack) - damage * this.consumption, 0));
    }

    public boolean func_77645_m() {
        return true;
    }

    @Override
    public int getFill(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            this.setFill(stack, this.maxFuel);
            return this.maxFuel;
        }
        return stack.field_77990_d.func_74762_e("fuel");
    }

    public void setFill(ItemStack stack, int fill) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("fuel", fill);
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        return this.acceptedFuels.contains(type);
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        if (!this.acceptsFluid(type, stack)) {
            return amount;
        }
        int toFill = Math.min(amount, this.fillRate);
        toFill = Math.min(toFill, this.maxFuel - this.getFill(stack));
        this.setFill(stack, this.getFill(stack) + toFill);
        return amount - toFill;
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return false;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        return amount;
    }

    public static ItemStack getEmptyTool(Item item) {
        ItemToolAbilityFueled tool = (ItemToolAbilityFueled)item;
        ItemStack stack = new ItemStack(item);
        tool.setFill(stack, 0);
        return stack;
    }

    @Override
    public FluidType getFirstFluidType(ItemStack stack) {
        return null;
    }
}

