/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet.toclient;

import com.hbm.items.IAnimatedItem;
import com.hbm.items.armor.ArmorTrenchmaster;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.render.anim.AnimationEnums;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.util.EnumUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class HbmAnimationPacket
implements IMessage {
    public short type;
    public int receiverIndex;
    public int itemIndex;

    public HbmAnimationPacket() {
    }

    public HbmAnimationPacket(int type) {
        this.type = (short)type;
        this.receiverIndex = 0;
        this.itemIndex = 0;
    }

    public HbmAnimationPacket(int type, int rec) {
        this.type = (short)type;
        this.receiverIndex = rec;
        this.itemIndex = 0;
    }

    public HbmAnimationPacket(int type, int rec, int gun) {
        this.type = (short)type;
        this.receiverIndex = rec;
        this.itemIndex = gun;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readShort();
        this.receiverIndex = buf.readInt();
        this.itemIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.type);
        buf.writeInt(this.receiverIndex);
        buf.writeInt(this.itemIndex);
    }

    public static class Handler
    implements IMessageHandler<HbmAnimationPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(HbmAnimationPacket m, MessageContext ctx) {
            try {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                ItemStack stack = player.func_70694_bm();
                int slot = player.field_71071_by.field_70461_c;
                if (stack == null) {
                    return null;
                }
                if (stack.func_77973_b() instanceof ItemGunBaseNT) {
                    Handler.handleSedna((EntityPlayer)player, stack, slot, AnimationEnums.GunAnimation.values()[m.type], m.receiverIndex, m.itemIndex);
                } else if (stack.func_77973_b() instanceof IAnimatedItem) {
                    Handler.handleItem((EntityPlayer)player, stack, slot, m.type, m.receiverIndex, m.itemIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public static void handleSedna(EntityPlayer player, ItemStack stack, int slot, AnimationEnums.GunAnimation type, int receiverIndex, int gunIndex) {
            BiFunction<ItemStack, AnimationEnums.GunAnimation, BusAnimation> anims;
            BusAnimation animation;
            ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
            GunConfig config = gun.getConfig(stack, gunIndex);
            if (type == AnimationEnums.GunAnimation.CYCLE) {
                Receiver rec;
                BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> onRecoil;
                if (gunIndex < gun.lastShot.length) {
                    gun.lastShot[gunIndex] = System.currentTimeMillis();
                }
                gun.shotRand = player.field_70170_p.field_73012_v.nextDouble();
                Receiver[] receivers = config.getReceivers(stack);
                if (receiverIndex >= 0 && receiverIndex < receivers.length && (onRecoil = (rec = receivers[receiverIndex]).getRecoil(stack)) != null) {
                    onRecoil.accept(stack, new ItemGunBaseNT.LambdaContext(config, (EntityLivingBase)player, (IInventory)player.field_71071_by, receiverIndex));
                }
            }
            if ((animation = (anims = config.getAnims(stack)).apply(stack, type)) == null && (type == AnimationEnums.GunAnimation.ALT_CYCLE || type == AnimationEnums.GunAnimation.CYCLE_EMPTY)) {
                animation = anims.apply(stack, AnimationEnums.GunAnimation.CYCLE);
            }
            if (animation != null) {
                boolean isReloadAnimation;
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78444_b();
                Minecraft.func_71410_x().field_71460_t.field_78516_c.field_78453_b = stack;
                boolean bl = isReloadAnimation = type == AnimationEnums.GunAnimation.RELOAD || type == AnimationEnums.GunAnimation.RELOAD_CYCLE;
                if (isReloadAnimation && ArmorTrenchmaster.isTrenchMaster(player)) {
                    animation.setTimeMult(0.5);
                }
                HbmAnimations.hotbar[slot][gunIndex] = new HbmAnimations.Animation(stack.func_77973_b().func_77658_a(), System.currentTimeMillis(), animation, isReloadAnimation && config.getReloadAnimSequential(stack));
            }
        }

        public static void handleItem(EntityPlayer player, ItemStack stack, int slot, short type, int receiverIndex, int itemIndex) {
            Class animClass;
            IAnimatedItem item = (IAnimatedItem)stack.func_77973_b();
            BusAnimation animation = item.getAnimation(EnumUtil.grabEnumSafely(animClass = item.getEnum(), type), stack);
            if (animation != null) {
                HbmAnimations.hotbar[slot][itemIndex] = new HbmAnimations.Animation(stack.func_77973_b().func_77658_a(), System.currentTimeMillis(), animation);
            }
        }
    }
}

