/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.helper;

import com.hbm.particle.ParticleBlackPowderSmoke;
import com.hbm.particle.ParticleBlackPowderSpark;
import com.hbm.particle.helper.IParticleCreator;
import com.hbm.util.Vec3NT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BlackPowderCreator
implements IParticleCreator {
    public static void composeEffect(World world, double x, double y, double z, double headingX, double headingY, double headingZ, int cloudCount, float cloudScale, float cloudSpeedMult, int sparkCount, float sparkSpeedMult) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "blackPowder");
        data.func_74768_a("cloudCount", cloudCount);
        data.func_74776_a("cloudScale", cloudScale);
        data.func_74776_a("cloudSpeedMult", cloudSpeedMult);
        data.func_74768_a("sparkCount", sparkCount);
        data.func_74776_a("sparkSpeedMult", sparkSpeedMult);
        data.func_74780_a("hX", headingX);
        data.func_74780_a("hY", headingY);
        data.func_74780_a("hZ", headingZ);
        IParticleCreator.sendPacket(world, x, y, z, 200, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void makeParticle(World world, EntityPlayer player, TextureManager texman, Random rand, double x, double y, double z, NBTTagCompound data) {
        int i;
        double headingX = data.func_74769_h("hX");
        double headingY = data.func_74769_h("hY");
        double headingZ = data.func_74769_h("hZ");
        int cloudCount = data.func_74762_e("cloudCount");
        float cloudScale = data.func_74760_g("cloudScale");
        float cloudSpeedMult = data.func_74760_g("cloudSpeedMult");
        int sparkCount = data.func_74762_e("sparkCount");
        float sparkSpeedMult = data.func_74760_g("sparkSpeedMult");
        Vec3NT heading = new Vec3NT(headingX, headingY, headingZ).normalizeSelf();
        for (i = 0; i < cloudCount; ++i) {
            ParticleBlackPowderSmoke particle = new ParticleBlackPowderSmoke(world, x, y, z, cloudScale);
            double speedMult = 0.85 + rand.nextDouble() * 0.3;
            particle.field_70159_w = heading.field_72450_a * (double)cloudSpeedMult * speedMult + rand.nextGaussian() * 0.05;
            particle.field_70181_x = heading.field_72448_b * (double)cloudSpeedMult * speedMult + rand.nextGaussian() * 0.05;
            particle.field_70179_y = heading.field_72449_c * (double)cloudSpeedMult * speedMult + rand.nextGaussian() * 0.05;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
        for (i = 0; i < sparkCount; ++i) {
            double speedMult = 0.85 + rand.nextDouble() * 0.3;
            ParticleBlackPowderSpark particle = new ParticleBlackPowderSpark(world, x, y, z, heading.field_72450_a * (double)sparkSpeedMult * speedMult + rand.nextGaussian() * 0.02, heading.field_72448_b * (double)sparkSpeedMult * speedMult + rand.nextGaussian() * 0.02, heading.field_72449_c * (double)sparkSpeedMult * speedMult + rand.nextGaussian() * 0.02);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
    }
}

