/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.block;

import com.hbm.blocks.network.PneumoTube;
import com.hbm.lib.Library;
import com.hbm.render.util.RenderBlocksNT;
import com.hbm.tileentity.network.TileEntityPneumoTube;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderPneumoTube
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        PneumoTube duct = (PneumoTube)block;
        double lower = 0.3125;
        double upper = 0.6875;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        renderer.func_147782_a(lower, lower, 0.0, upper, upper, 1.0);
        renderer.field_147867_u = 2;
        renderer.field_147865_v = 1;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, duct.iconStraight);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, duct.iconStraight);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, duct.iconStraight);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, duct.iconStraight);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, duct.iconConnector);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, duct.iconConnector);
        tessellator.func_78381_a();
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean hasConnections;
        renderer = RenderBlocksNT.INSTANCE.setWorld(world);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        PneumoTube duct = (PneumoTube)block;
        TileEntity te = world.func_147438_o(x, y, z);
        TileEntityPneumoTube tile = te instanceof TileEntityPneumoTube ? (TileEntityPneumoTube)te : null;
        boolean pX = duct.canConnectTo(world, x, y, z, Library.POS_X);
        boolean nX = duct.canConnectTo(world, x, y, z, Library.NEG_X);
        boolean pY = duct.canConnectTo(world, x, y, z, Library.POS_Y);
        boolean nY = duct.canConnectTo(world, x, y, z, Library.NEG_Y);
        boolean pZ = duct.canConnectTo(world, x, y, z, Library.POS_Z);
        boolean nZ = duct.canConnectTo(world, x, y, z, Library.NEG_Z);
        int mask = 0 + (pX ? 32 : 0) + (nX ? 16 : 0) + (pY ? 8 : 0) + (nY ? 4 : 0) + (pZ ? 2 : 0) + (nZ ? 1 : 0);
        double lower = 0.3125;
        double upper = 0.6875;
        boolean bl = hasConnections = tile != null && (tile.isCompressor() || tile.isEndpoint());
        if (mask == 48 && !hasConnections) {
            renderer.func_147782_a(0.0, lower, lower, 1.0, upper, upper);
            duct.renderSides[4] = false;
            duct.renderSides[5] = false;
            duct.activeIcon = duct.iconStraight;
            renderer.func_147784_q(block, x, y, z);
            duct.resetRenderSides();
        } else if (mask == 3 && !hasConnections) {
            renderer.func_147782_a(lower, lower, 0.0, upper, upper, 1.0);
            duct.renderSides[2] = false;
            duct.renderSides[3] = false;
            duct.activeIcon = duct.iconStraight;
            renderer.field_147867_u = 2;
            renderer.field_147865_v = 1;
            renderer.func_147784_q(block, x, y, z);
            duct.resetRenderSides();
            renderer.field_147867_u = 0;
            renderer.field_147865_v = 0;
        } else if (mask == 12 && !hasConnections) {
            renderer.func_147782_a(lower, 0.0, lower, upper, 1.0, upper);
            duct.renderSides[0] = false;
            duct.renderSides[1] = false;
            duct.activeIcon = duct.iconStraight;
            renderer.field_147869_t = 2;
            renderer.field_147871_s = 2;
            renderer.field_147875_q = 2;
            renderer.field_147873_r = 2;
            renderer.func_147784_q(block, x, y, z);
            duct.resetRenderSides();
            renderer.field_147869_t = 0;
            renderer.field_147871_s = 0;
            renderer.field_147875_q = 0;
            renderer.field_147873_r = 0;
        } else {
            renderer.func_147782_a(lower, lower, lower, upper, upper, upper);
            duct.renderSides[5] = !pX;
            duct.renderSides[4] = !nX;
            duct.renderSides[1] = !pY;
            duct.renderSides[0] = !nY;
            duct.renderSides[3] = !pZ;
            duct.renderSides[2] = !nZ;
            renderer.func_147784_q(block, x, y, z);
            duct.resetRenderSides();
            if (pX) {
                duct.renderSides[5] = false;
                duct.renderSides[4] = false;
                renderer.func_147782_a(upper, lower, lower, 1.0, upper, upper);
                renderer.func_147784_q(block, x, y, z);
                duct.resetRenderSides();
            }
            if (nX) {
                duct.renderSides[4] = false;
                duct.renderSides[5] = false;
                renderer.func_147782_a(0.0, lower, lower, lower, upper, upper);
                renderer.func_147784_q(block, x, y, z);
                duct.resetRenderSides();
            }
            if (pY) {
                duct.renderSides[1] = false;
                duct.renderSides[0] = false;
                renderer.func_147782_a(lower, upper, lower, upper, 1.0, upper);
                renderer.func_147784_q(block, x, y, z);
                duct.resetRenderSides();
            }
            if (nY) {
                duct.renderSides[0] = false;
                duct.renderSides[1] = false;
                renderer.func_147782_a(lower, 0.0, lower, upper, lower, upper);
                renderer.func_147784_q(block, x, y, z);
                duct.resetRenderSides();
            }
            if (pZ) {
                duct.renderSides[3] = false;
                duct.renderSides[2] = false;
                renderer.func_147782_a(lower, lower, upper, upper, upper, 1.0);
                renderer.func_147784_q(block, x, y, z);
                duct.resetRenderSides();
            }
            if (nZ) {
                duct.renderSides[2] = false;
                duct.renderSides[3] = false;
                renderer.func_147782_a(lower, lower, 0.0, upper, upper, lower);
                renderer.func_147784_q(block, x, y, z);
                duct.resetRenderSides();
            }
        }
        if (tile != null) {
            RenderPneumoTube.renderCon(duct, x, y, z, renderer, tile.insertionDir, duct.iconIn);
            RenderPneumoTube.renderCon(duct, x, y, z, renderer, tile.ejectionDir, duct.iconOut);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!duct.canConnectToAir(world, x, y, z, dir)) continue;
                RenderPneumoTube.renderCon(duct, x, y, z, renderer, dir, duct.iconConnector);
            }
        }
        duct.activeIcon = duct.baseIcon;
        return true;
    }

    protected static void renderCon(PneumoTube duct, int x, int y, int z, RenderBlocks renderer, ForgeDirection dir, IIcon newIcon) {
        double lower = 0.3125;
        double upper = 0.6875;
        double cLower = 0.25;
        double cUpper = 0.75;
        double nLower = 0.25;
        double nUpper = 0.75;
        if (dir == Library.POS_X) {
            duct.renderSides[5] = false;
            duct.renderSides[4] = false;
            renderer.func_147782_a(upper, lower, lower, cUpper, upper, upper);
            renderer.func_147784_q((Block)duct, x, y, z);
            duct.resetRenderSides();
            duct.activeIcon = newIcon;
            renderer.func_147782_a(cUpper, nLower, nLower, 1.0, nUpper, nUpper);
            renderer.func_147784_q((Block)duct, x, y, z);
        }
        if (dir == Library.NEG_X) {
            duct.renderSides[5] = false;
            duct.renderSides[4] = false;
            renderer.func_147782_a(cLower, lower, lower, lower, upper, upper);
            renderer.func_147784_q((Block)duct, x, y, z);
            duct.resetRenderSides();
            duct.activeIcon = newIcon;
            renderer.func_147782_a(0.0, nLower, nLower, nLower, nUpper, nUpper);
            renderer.func_147784_q((Block)duct, x, y, z);
        }
        if (dir == Library.POS_Y) {
            duct.renderSides[1] = false;
            duct.renderSides[0] = false;
            renderer.func_147782_a(lower, upper, lower, upper, cUpper, upper);
            renderer.func_147784_q((Block)duct, x, y, z);
            duct.resetRenderSides();
            duct.activeIcon = newIcon;
            renderer.func_147782_a(nLower, cUpper, nLower, nUpper, 1.0, nUpper);
            renderer.func_147784_q((Block)duct, x, y, z);
        }
        if (dir == Library.NEG_Y) {
            duct.renderSides[1] = false;
            duct.renderSides[0] = false;
            renderer.func_147782_a(lower, cLower, lower, upper, lower, upper);
            renderer.func_147784_q((Block)duct, x, y, z);
            duct.resetRenderSides();
            duct.activeIcon = newIcon;
            renderer.func_147782_a(nLower, 0.0, nLower, nUpper, nLower, nUpper);
            renderer.func_147784_q((Block)duct, x, y, z);
        }
        if (dir == Library.POS_Z) {
            duct.renderSides[3] = false;
            duct.renderSides[2] = false;
            renderer.func_147782_a(lower, lower, upper, upper, upper, cUpper);
            renderer.func_147784_q((Block)duct, x, y, z);
            duct.resetRenderSides();
            duct.activeIcon = newIcon;
            renderer.func_147782_a(nLower, nLower, cUpper, nUpper, nUpper, 1.0);
            renderer.func_147784_q((Block)duct, x, y, z);
        }
        if (dir == Library.NEG_Z) {
            duct.renderSides[3] = false;
            duct.renderSides[2] = false;
            renderer.func_147782_a(lower, lower, cLower, upper, upper, lower);
            renderer.func_147784_q((Block)duct, x, y, z);
            duct.resetRenderSides();
            duct.activeIcon = newIcon;
            renderer.func_147782_a(nLower, nLower, 0.0, nUpper, nUpper, cLower);
            renderer.func_147784_q((Block)duct, x, y, z);
        }
        duct.activeIcon = duct.baseIcon;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return PneumoTube.renderID;
    }
}

