/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item;

import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.main.ResourceManager;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class ItemRenderMissileGeneric
implements IItemRenderer {
    public static HashMap<RecipesCommon.ComparableStack, Consumer<TextureManager>> renderers = new HashMap();
    protected RenderMissileType type;

    public ItemRenderMissileGeneric(RenderMissileType type) {
        this.type = type;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Consumer<TextureManager> renderer = renderers.get(new RecipesCommon.ComparableStack(item).makeSingular());
        if (renderer == null) {
            return;
        }
        GL11.glPushMatrix();
        double guiScale = 1.0;
        double guiOffset = 0.0;
        switch (this.type) {
            case TYPE_TIER0: {
                guiScale = 3.75;
                guiOffset = 10.75;
                break;
            }
            case TYPE_TIER1: {
                guiScale = 2.5;
                guiOffset = 8.5;
                break;
            }
            case TYPE_TIER2: {
                guiScale = 2.0;
                guiOffset = 6.5;
                break;
            }
            case TYPE_TIER3: {
                guiScale = 1.25;
                guiOffset = 1.0;
                break;
            }
            case TYPE_STEALTH: {
                guiScale = 1.75;
                guiOffset = 4.75;
                break;
            }
            case TYPE_ABM: {
                guiScale = 2.25;
                guiOffset = 7.0;
                break;
            }
            case TYPE_NUCLEAR: {
                guiScale = 1.375;
                guiOffset = 1.5;
                break;
            }
            case TYPE_ROBIN: {
                guiScale = 1.25;
                guiOffset = 2.0;
            }
        }
        GL11.glEnable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3008);
        switch (type) {
            case EQUIPPED: {
                double s = 0.15;
                GL11.glTranslated((double)0.5, (double)-0.25, (double)0.0);
                GL11.glScaled((double)s, (double)s, (double)s);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                double heldScale = 0.1;
                GL11.glTranslated((double)0.5, (double)0.25, (double)0.0);
                GL11.glScaled((double)heldScale, (double)heldScale, (double)heldScale);
                break;
            }
            case ENTITY: {
                double s2 = 0.15;
                GL11.glScaled((double)s2, (double)s2, (double)s2);
                break;
            }
            case INVENTORY: {
                RenderHelper.func_74520_c();
                GL11.glScaled((double)guiScale, (double)guiScale, (double)guiScale);
                GL11.glRotated((double)135.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotatef((float)(System.currentTimeMillis() / 15L % 360L), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)0.0, (double)(-16.0 + guiOffset), (double)0.0);
                break;
            }
        }
        GL11.glDisable((int)2884);
        renderer.accept(Minecraft.func_71410_x().field_71446_o);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public static Consumer<TextureManager> generateStandard(ResourceLocation texture, IModelCustom model) {
        return ItemRenderMissileGeneric.generateWithScale(texture, model, 1.0f);
    }

    public static Consumer<TextureManager> generateLarge(ResourceLocation texture, IModelCustom model) {
        return ItemRenderMissileGeneric.generateWithScale(texture, model, 1.5f);
    }

    public static Consumer<TextureManager> generateDouble(ResourceLocation texture, IModelCustom model) {
        return ItemRenderMissileGeneric.generateWithScale(texture, model, 2.0f);
    }

    public static Consumer<TextureManager> generateWithScale(ResourceLocation texture, IModelCustom model, float scale) {
        return x -> {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glShadeModel((int)7425);
            x.func_110577_a(texture);
            model.renderAll();
            GL11.glShadeModel((int)7424);
        };
    }

    public static void init() {
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_test), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicroTest_tex, ResourceManager.missileMicro));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_taint), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicroTaint_tex, ResourceManager.missileMicro));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_micro), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicro_tex, ResourceManager.missileMicro));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_bhole), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicroBHole_tex, ResourceManager.missileMicro));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_schrabidium), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicroSchrab_tex, ResourceManager.missileMicro));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_emp), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicroEMP_tex, ResourceManager.missileMicro));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_stealth), x -> {
            GL11.glShadeModel((int)7425);
            x.func_110577_a(ResourceManager.missileStealth_tex);
            ResourceManager.missileStealth.renderAll();
            GL11.glShadeModel((int)7424);
        });
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_generic), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_HE_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_incendiary), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_IN_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_cluster), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_CL_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_buster), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_BU_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_decoy), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_decoy_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_anti_ballistic), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileAA_tex, ResourceManager.missileABM));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_HE_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_incendiary_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_IN_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_cluster_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_CL_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_buster_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_BU_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_emp_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_EMP_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_burst), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileHuge_HE_tex, ResourceManager.missileHuge));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_inferno), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileHuge_IN_tex, ResourceManager.missileHuge));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_rain), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileHuge_CL_tex, ResourceManager.missileHuge));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_drill), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileHuge_BU_tex, ResourceManager.missileHuge));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_nuclear), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileNuclear_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_nuclear_cluster), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileThermo_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_volcano), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileVolcano_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_doomsday), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileDoomsday_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_doomsday_rusted), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileDoomsdayRusted_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_shuttle), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileShuttle_tex, ResourceManager.missileShuttle));
    }

    public static enum RenderMissileType {
        TYPE_TIER0,
        TYPE_TIER1,
        TYPE_TIER2,
        TYPE_TIER3,
        TYPE_STEALTH,
        TYPE_ABM,
        TYPE_NUCLEAR,
        TYPE_ROBIN;

    }
}

