/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderAberrator
extends ItemRenderWeaponBase {
    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.25f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
        float offset = 0.8f;
        ItemRenderAberrator.standardAimingTransform(stack, -1.0f * offset, -1.25f * offset, 1.25f * offset, 0.0, -0.65625, 0.125);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.aberrator_tex);
        double scale = 0.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] rise = HbmAnimations.getRelevantTransformation("RISE");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] slide = HbmAnimations.getRelevantTransformation("SLIDE");
        double[] bullet = HbmAnimations.getRelevantTransformation("BULLET");
        double[] hammer = HbmAnimations.getRelevantTransformation("HAMMER");
        double[] roll = HbmAnimations.getRelevantTransformation("ROLL");
        double[] mag = HbmAnimations.getRelevantTransformation("MAG");
        double[] magroll = HbmAnimations.getRelevantTransformation("MAGROLL");
        double[] sight = HbmAnimations.getRelevantTransformation("SIGHT");
        GL11.glTranslated((double)0.0, (double)rise[1], (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)-2.25);
        GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)2.25);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)-4.0);
        GL11.glRotated((double)recoil[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)4.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)roll[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
        GL11.glShadeModel((int)7425);
        ResourceManager.aberrator.renderPart("Gun");
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)2.4375, (double)-1.9375);
        GL11.glRotated((double)sight[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-2.4375, (double)1.9375);
        ResourceManager.aberrator.renderPart("Sight");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)mag[0], (double)mag[1], (double)mag[2]);
        GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)magroll[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
        ResourceManager.aberrator.renderPart("Magazine");
        GL11.glTranslated((double)bullet[0], (double)bullet[1], (double)bullet[2]);
        ResourceManager.aberrator.renderPart("Bullet");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)slide[2]);
        ResourceManager.aberrator.renderPart("Slide");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.25, (double)-3.625);
        GL11.glRotated((double)(-45.0 + hammer[0]), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.25, (double)3.625);
        ResourceManager.aberrator.renderPart("Hammer");
        GL11.glPopMatrix();
        double smokeScale = 0.5;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)2.0, (double)4.0);
        GL11.glRotated((double)recoil[0], (double)-1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)roll[2], (double)0.0, (double)0.0, (double)-1.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
        ItemRenderAberrator.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 0.5);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)2.0, (double)4.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(90.0 * gun.shotRand), (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        ItemRenderAberrator.renderMuzzleFlash(gun.lastShot[0], 75, 7.5);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)2.0, (double)-1.5);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        ItemRenderAberrator.renderFireball(gun.lastShot[0]);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().func_110434_K().func_130087_a(Items.field_151010_B.func_94901_k()));
        IIcon icon = Items.field_151010_B.func_77617_a(0);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        GL11.glTranslated((double)0.0, (double)2.0, (double)4.5);
        GL11.glRotated((double)roll[2], (double)0.0, (double)0.0, (double)-1.0);
        GL11.glRotated((double)recoil[0], (double)-1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)equip[0], (double)-1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)((double)System.currentTimeMillis() / 50.0 % 360.0), (double)0.0, (double)0.0, (double)1.0);
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        aimingProgress = Math.min(1.0f, aimingProgress * 2.0f);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        int amount = 16;
        for (int i = 0; i < amount; ++i) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)(-1.5 - (double)aimingProgress), (double)0.0);
            GL11.glRotated((double)(90.0f * aimingProgress), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)-45.0, (double)0.0, (double)0.0, (double)1.0);
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            tess.func_78374_a(-0.5, -0.5, -0.5, (double)maxU, (double)maxV);
            tess.func_78374_a(0.5, -0.5, -0.5, (double)minU, (double)maxV);
            tess.func_78374_a(0.5, 0.5, -0.5, (double)minU, (double)minV);
            tess.func_78374_a(-0.5, 0.5, -0.5, (double)maxU, (double)minV);
            tess.func_78381_a();
            GL11.glPopMatrix();
            GL11.glRotated((double)(360.0 / (double)amount), (double)0.0, (double)0.0, (double)1.0);
        }
        GL11.glPopMatrix();
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)4.0);
        double scale = 1.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 2.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-1.0, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -12.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)0.5);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type) {
        GL11.glEnable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3008);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.aberrator_tex);
        ResourceManager.aberrator.renderPart("Gun");
        ResourceManager.aberrator.renderPart("Hammer");
        ResourceManager.aberrator.renderPart("Magazine");
        ResourceManager.aberrator.renderPart("Slide");
        ResourceManager.aberrator.renderPart("Sight");
        GL11.glShadeModel((int)7424);
    }

    public static void renderFireball(long lastShot) {
        Tessellator tess = Tessellator.field_78398_a;
        int flash = 150;
        if (System.currentTimeMillis() - lastShot < (long)flash) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glPushMatrix();
            double fire = (double)(System.currentTimeMillis() - lastShot) / (double)flash;
            double height = 5.0 * fire;
            double length = 10.0 * fire;
            double offset = 1.0 * fire;
            double lengthOffset = -1.125;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(flash_plume);
            tess.func_78382_b();
            tess.func_78380_c(240);
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            tess.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
            tess.func_78374_a(height, -offset, 0.0, 0.0, 1.0);
            tess.func_78374_a(-height, -offset, 0.0, 1.0, 1.0);
            tess.func_78374_a(-height, -offset + length, -lengthOffset, 1.0, 0.0);
            tess.func_78374_a(height, -offset + length, -lengthOffset, 0.0, 0.0);
            tess.func_78374_a(height, -offset, 0.0, 0.0, 1.0);
            tess.func_78374_a(-height, -offset, 0.0, 1.0, 1.0);
            tess.func_78374_a(-height, -offset + length, lengthOffset, 1.0, 0.0);
            tess.func_78374_a(height, -offset + length, lengthOffset, 0.0, 0.0);
            tess.func_78381_a();
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
        }
    }
}

