/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mods.WeaponModManager;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderG3
extends ItemRenderWeaponBase {
    public ResourceLocation texture;

    public ItemRenderG3(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.25f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * (this.isScoped(stack) ? 0.66f : 0.33f));
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        boolean isScoped = this.isScoped(stack);
        float offset = 0.8f;
        ItemRenderG3.standardAimingTransform(stack, -1.25f * offset, -1.0f * offset, 2.75f * offset, 0.0, isScoped ? -0.69140625 : -0.4453125, isScoped ? 1.46875 : 1.75);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        boolean silenced;
        boolean isScoped = this.isScoped(stack);
        if (isScoped && ItemGunBaseNT.prevAimingProgress == 1.0f && ItemGunBaseNT.aimingProgress == 1.0f) {
            return;
        }
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture(stack));
        double scale = 0.375;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] lift = HbmAnimations.getRelevantTransformation("LIFT");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] mag = HbmAnimations.getRelevantTransformation("MAG");
        double[] speen = HbmAnimations.getRelevantTransformation("SPEEN");
        double[] bolt = HbmAnimations.getRelevantTransformation("BOLT");
        double[] plug = HbmAnimations.getRelevantTransformation("PLUG");
        double[] handle = HbmAnimations.getRelevantTransformation("HANDLE");
        double[] bullet = HbmAnimations.getRelevantTransformation("BULLET");
        GL11.glTranslated((double)0.0, (double)-2.0, (double)-6.0);
        GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)2.0, (double)6.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-4.0);
        GL11.glRotated((double)lift[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)4.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)recoil[2]);
        GL11.glShadeModel((int)7425);
        ResourceManager.g3.renderPart("Rifle");
        if (this.hasStock(stack)) {
            ResourceManager.g3.renderPart("Stock");
        }
        if (!(silenced = this.hasSilencer(stack))) {
            ResourceManager.g3.renderPart("Flash_Hider");
        }
        ResourceManager.g3.renderPart("Trigger");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture(stack));
        GL11.glPushMatrix();
        GL11.glTranslated((double)mag[0], (double)mag[1], (double)mag[2]);
        GL11.glTranslated((double)0.0, (double)-1.75, (double)-0.5);
        GL11.glRotated((double)speen[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)speen[1], (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.75, (double)0.5);
        ResourceManager.g3.renderPart("Magazine");
        if (bullet[0] == 0.0) {
            ResourceManager.g3.renderPart("Bullet");
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)bolt[2]);
        ResourceManager.g3.renderPart("Guide_And_Bolt");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.625, (double)plug[2]);
        GL11.glRotated((double)handle[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-0.625, (double)0.0);
        ResourceManager.g3.renderPart("Plug");
        GL11.glTranslated((double)0.0, (double)0.625, (double)5.25);
        GL11.glRotated((double)22.5, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)handle[1], (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)-22.5, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-0.625, (double)-5.25);
        ResourceManager.g3.renderPart("Handle");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-0.875, (double)-3.5);
        GL11.glRotated((double)(-30 * (1 - ItemGunBaseNT.getMode(stack, 0))), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.875, (double)3.5);
        ResourceManager.g3.renderPart("Selector");
        GL11.glPopMatrix();
        if (silenced || isScoped) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.g3_attachments);
            if (silenced) {
                ResourceManager.g3.renderPart("Silencer");
            }
            if (isScoped) {
                ResourceManager.g3.renderPart("Scope");
            }
        }
        if (!silenced) {
            double smokeScale = 0.75;
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)13.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
            ItemRenderG3.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 0.5);
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)12.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-25.0 + gun.shotRand * 10.0), (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
            ItemRenderG3.renderMuzzleFlash(gun.lastShot[0], 75, 10.0);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        double scale = 1.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)0.0, (double)2.0, (double)4.0);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        if (this.hasStock(stack)) {
            double scale = 0.875;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(this.hasSilencer(stack) ? 50.0 : 45.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)(this.hasSilencer(stack) ? 0.75 : -0.5), (double)0.5, (double)0.0);
        } else {
            double scale = 1.125;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(this.hasSilencer(stack) ? 55.0 : 45.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)2.5, (double)0.5, (double)0.0);
        }
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -5.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.5, (double)-0.5);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type) {
        GL11.glEnable((int)2896);
        boolean silenced = this.hasSilencer(stack);
        boolean isScoped = this.isScoped(stack);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture(stack));
        ResourceManager.g3.renderPart("Rifle");
        if (this.hasStock(stack)) {
            ResourceManager.g3.renderPart("Stock");
        }
        ResourceManager.g3.renderPart("Magazine");
        if (!silenced) {
            ResourceManager.g3.renderPart("Flash_Hider");
        }
        ResourceManager.g3.renderPart("Guide_And_Bolt");
        ResourceManager.g3.renderPart("Handle");
        ResourceManager.g3.renderPart("Trigger");
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-0.875, (double)-3.5);
        GL11.glRotated((double)-30.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.875, (double)3.5);
        ResourceManager.g3.renderPart("Selector");
        GL11.glPopMatrix();
        if (silenced || isScoped) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.g3_attachments);
            if (silenced) {
                ResourceManager.g3.renderPart("Silencer");
            }
            if (isScoped) {
                ResourceManager.g3.renderPart("Scope");
            }
        }
        GL11.glShadeModel((int)7424);
    }

    public boolean hasStock(ItemStack stack) {
        return !WeaponModManager.hasUpgrade(stack, 0, 205);
    }

    public boolean hasSilencer(ItemStack stack) {
        return stack.func_77973_b() == ModItems.gun_g3_zebra || WeaponModManager.hasUpgrade(stack, 0, 201);
    }

    public boolean isScoped(ItemStack stack) {
        return stack.func_77973_b() == ModItems.gun_g3_zebra || WeaponModManager.hasUpgrade(stack, 0, 202);
    }

    public ResourceLocation getTexture(ItemStack stack) {
        if (WeaponModManager.hasUpgrade(stack, 0, 211)) {
            return ResourceManager.g3_green_tex;
        }
        if (WeaponModManager.hasUpgrade(stack, 0, 212)) {
            return ResourceManager.g3_black_tex;
        }
        return this.texture;
    }
}

