/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderLaserPistol
extends ItemRenderWeaponBase {
    public ResourceLocation texture;

    public ItemRenderLaserPistol(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.5f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderLaserPistol.standardAimingTransform(stack, -1.75f * offset, -2.0f * offset, 2.75f * offset, 0.0, -1.25, 1.25);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        double scale = 0.375;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] latch = HbmAnimations.getRelevantTransformation("LATCH");
        double[] lift = HbmAnimations.getRelevantTransformation("LIFT");
        double[] jolt = HbmAnimations.getRelevantTransformation("JOLT");
        double[] battery = HbmAnimations.getRelevantTransformation("BATTERY");
        double[] swirl = HbmAnimations.getRelevantTransformation("SWIRL");
        GL11.glTranslated((double)0.0, (double)-1.0, (double)-6.0);
        GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)6.0);
        GL11.glTranslated((double)0.0, (double)2.0, (double)-2.0);
        GL11.glRotated((double)lift[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-2.0, (double)2.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)-1.0);
        GL11.glRotated((double)swirl[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)recoil[2]);
        GL11.glTranslated((double)jolt[0], (double)jolt[1], (double)jolt[2]);
        GL11.glShadeModel((int)7425);
        ResourceManager.laser_pistol.renderPart("Gun");
        if (this.hasCapacitors(stack)) {
            ResourceManager.laser_pistol.renderPart("Capacitors");
        }
        if (this.hasTape(stack)) {
            ResourceManager.laser_pistol.renderPart("Tape");
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)1.125, (double)0.0, (double)-1.9125);
        GL11.glRotated((double)latch[1], (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-1.125, (double)0.0, (double)1.9125);
        ResourceManager.laser_pistol.renderPart("Latch");
        GL11.glTranslated((double)battery[0], (double)battery[1], (double)battery[2]);
        ResourceManager.laser_pistol.renderPart("Battery");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)2.0, (double)4.75);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        ItemRenderLaserPistol.renderLaserFlash(gun.lastShot[0], 150, 1.5, this.hasEmerald(stack) ? 32768 : 0xFF0000);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.25);
        ItemRenderLaserPistol.renderLaserFlash(gun.lastShot[0], 150, 0.75, this.hasEmerald(stack) ? 0x80FF00 : 0xFF8000);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        double scale = 1.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)0.0, (double)-0.5, (double)1.0);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 1.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -10.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        ResourceManager.laser_pistol.renderPart("Gun");
        ResourceManager.laser_pistol.renderPart("Latch");
        if (this.hasCapacitors(stack)) {
            ResourceManager.laser_pistol.renderPart("Capacitors");
        }
        if (this.hasTape(stack)) {
            ResourceManager.laser_pistol.renderPart("Tape");
        }
        GL11.glShadeModel((int)7424);
    }

    public boolean hasCapacitors(ItemStack stack) {
        return stack.func_77973_b() == ModItems.gun_laser_pistol_pew_pew;
    }

    public boolean hasTape(ItemStack stack) {
        return stack.func_77973_b() == ModItems.gun_laser_pistol_pew_pew;
    }

    public boolean hasEmerald(ItemStack stack) {
        return stack.func_77973_b() == ModItems.gun_laser_pistol_morning_glory;
    }
}

