/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class BeamPronter {
    private static boolean depthMask = false;

    public static void prontBeamwithDepth(Vec3 skeleton, EnumWaveType wave, EnumBeamType beam, int outerColor, int innerColor, int start, int segments, float size, int layers, float thickness) {
        depthMask = true;
        BeamPronter.prontBeam(skeleton, wave, beam, outerColor, innerColor, start, segments, size, layers, thickness);
        depthMask = false;
    }

    public static void prontBeam(Vec3 skeleton, EnumWaveType wave, EnumBeamType beam, int outerColor, int innerColor, int start, int segments, float size, int layers, float thickness) {
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)depthMask);
        float sYaw = (float)(Math.atan2(skeleton.field_72450_a, skeleton.field_72449_c) * 180.0 / Math.PI);
        float sqrt = MathHelper.func_76133_a((double)(skeleton.field_72450_a * skeleton.field_72450_a + skeleton.field_72449_c * skeleton.field_72449_c));
        float sPitch = (float)(Math.atan2(skeleton.field_72448_b, sqrt) * 180.0 / Math.PI);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)sYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(sPitch - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        if (beam == EnumBeamType.SOLID) {
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        Vec3 unit = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
        Random rand = new Random(start);
        double length = skeleton.func_72433_c();
        double segLength = length / (double)segments;
        double lastX = 0.0;
        double lastY = 0.0;
        double lastZ = 0.0;
        for (int i = 0; i <= segments; ++i) {
            Vec3 spinner = Vec3.func_72443_a((double)size, (double)0.0, (double)0.0);
            if (wave == EnumWaveType.SPIRAL) {
                spinner.func_72442_b((float)Math.PI * (float)start / 180.0f);
                spinner.func_72442_b(0.7853982f * (float)i);
            } else if (wave == EnumWaveType.RANDOM) {
                spinner.func_72442_b((float)Math.PI * 2 * rand.nextFloat());
                spinner.func_72442_b((float)Math.PI * 2 * rand.nextFloat());
            }
            double pX = unit.field_72450_a * segLength * (double)i + spinner.field_72450_a;
            double pY = unit.field_72448_b * segLength * (double)i + spinner.field_72448_b;
            double pZ = unit.field_72449_c * segLength * (double)i + spinner.field_72449_c;
            if (beam == EnumBeamType.LINE && i > 0) {
                tessellator.func_78371_b(3);
                tessellator.func_78378_d(outerColor);
                tessellator.func_78377_a(pX, pY, pZ);
                tessellator.func_78377_a(lastX, lastY, lastZ);
                tessellator.func_78381_a();
            }
            if (beam == EnumBeamType.SOLID && i > 0) {
                float radius = thickness / (float)layers;
                for (int j = 1; j <= layers; ++j) {
                    float inter = (float)(j - 1) / (float)(layers - 1);
                    int r1 = (outerColor & 0xFF0000) >> 16;
                    int g1 = (outerColor & 0xFF00) >> 8;
                    int b1 = (outerColor & 0xFF) >> 0;
                    int r2 = (innerColor & 0xFF0000) >> 16;
                    int g2 = (innerColor & 0xFF00) >> 8;
                    int b2 = (innerColor & 0xFF) >> 0;
                    int r = (int)((float)r1 + (float)(r2 - r1) * inter) << 16;
                    int g = (int)((float)g1 + (float)(g2 - g1) * inter) << 8;
                    int b = (int)((float)b1 + (float)(b2 - b1) * inter) << 0;
                    int color = r | g | b;
                    tessellator.func_78382_b();
                    tessellator.func_78378_d(color);
                    tessellator.func_78377_a(lastX + (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.func_78377_a(lastX + (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.func_78377_a(pX + (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.func_78377_a(pX + (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.func_78381_a();
                    tessellator.func_78382_b();
                    tessellator.func_78378_d(color);
                    tessellator.func_78377_a(lastX - (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.func_78377_a(lastX - (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.func_78377_a(pX - (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.func_78377_a(pX - (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.func_78381_a();
                    tessellator.func_78382_b();
                    tessellator.func_78378_d(color);
                    tessellator.func_78377_a(lastX + (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.func_78377_a(lastX - (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.func_78377_a(pX - (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.func_78377_a(pX + (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.func_78381_a();
                    tessellator.func_78382_b();
                    tessellator.func_78378_d(color);
                    tessellator.func_78377_a(lastX + (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.func_78377_a(lastX - (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.func_78377_a(pX - (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.func_78377_a(pX + (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.func_78381_a();
                }
            }
            lastX = pX;
            lastY = pY;
            lastZ = pZ;
        }
        if (beam == EnumBeamType.LINE) {
            tessellator.func_78371_b(3);
            tessellator.func_78378_d(innerColor);
            tessellator.func_78377_a(0.0, 0.0, 0.0);
            tessellator.func_78377_a(0.0, skeleton.func_72433_c(), 0.0);
            tessellator.func_78381_a();
        }
        if (beam == EnumBeamType.SOLID) {
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public static enum EnumBeamType {
        SOLID,
        LINE;

    }

    public static enum EnumWaveType {
        RANDOM,
        SPIRAL;

    }
}

