/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.util.Clock;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.wiaj.WorldInAJar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderOverhead {
    public static final HashMap<BlockPos, Marker> queuedMarkers = new HashMap();
    private static final HashMap<BlockPos, Marker> markers = new HashMap();
    private static WorldInAJar actionPreviewWorld;
    private static int offsetX;
    private static int offsetY;
    private static int offsetZ;
    private static boolean actionPreviewSuccess;
    private static boolean clearPreview;

    public static void renderTag(EntityLivingBase living, double x, double y, double z, RendererLivingEntity renderer, String name, boolean depthTest) {
        EntityClientPlayerMP thePlayer = Minecraft.func_71410_x().field_71439_g;
        GL11.glAlphaFunc((int)516, (float)0.1f);
        if (RenderOverhead.shouldRenderTag(living)) {
            float range;
            double distSq = living.func_70068_e((Entity)thePlayer);
            float f = living.func_70093_af() ? RendererLivingEntity.NAME_TAG_RANGE_SNEAK : (range = RendererLivingEntity.NAME_TAG_RANGE);
            if (distSq < (double)(range * range)) {
                RenderOverhead.drawTagAware(living, x, y, z, name, depthTest);
            }
        }
    }

    public static boolean shouldRenderTag(EntityLivingBase p_110813_1_) {
        return Minecraft.func_71382_s() && p_110813_1_ != RenderManager.field_78727_a.field_78734_h && !p_110813_1_.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && p_110813_1_.field_70153_n == null;
    }

    public static void drawTagAware(EntityLivingBase entity, double x, double y, double z, String string, boolean depthTest) {
        if (entity.func_70608_bn()) {
            RenderOverhead.drawTag((Entity)entity, string, x, y - 1.5, z, 64, depthTest);
        } else {
            RenderOverhead.drawTag((Entity)entity, string, x, y, z, 64, depthTest);
        }
    }

    public static void drawTag(Entity entity, String name, double x, double y, double z, int dist, boolean depthTest) {
        RenderOverhead.drawTag(entity.field_70131_O + 0.75f, entity.func_70068_e((Entity)RenderManager.field_78727_a.field_78734_h), name, x, y, z, dist, depthTest, -1, 0x20FFFFFF);
    }

    public static void drawTag(float offset, double distsq, String name, double x, double y, double z, int dist, boolean depthTest, int color, int shadowColor) {
        if (distsq <= (double)(dist * dist)) {
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            float f = 1.6f;
            float scale = 0.016666668f * f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + offset), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            if (depthTest) {
                GL11.glDisable((int)2929);
            }
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.field_78398_a;
            int heightOffset = 0;
            if (name.equals("deadmau5")) {
                heightOffset = -10;
            }
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            int center = fontrenderer.func_78256_a(name) / 2;
            tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
            tessellator.func_78377_a((double)(-center - 1), (double)(-1 + heightOffset), 0.0);
            tessellator.func_78377_a((double)(-center - 1), (double)(8 + heightOffset), 0.0);
            tessellator.func_78377_a((double)(center + 1), (double)(8 + heightOffset), 0.0);
            tessellator.func_78377_a((double)(center + 1), (double)(-1 + heightOffset), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, heightOffset, shadowColor);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, heightOffset, color);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void renderThermalSight(float partialTicks) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GL11.glPushMatrix();
        GL11.glDisable((int)2903);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2832);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(1);
        for (Object o : player.field_70170_p.field_72996_f) {
            Entity ent = (Entity)o;
            if (ent == player || ent.func_70068_e((Entity)player) > 4096.0) continue;
            if (ent instanceof IBossDisplayData) {
                tess.func_78386_a(1.0f, 0.5f, 0.0f);
            } else if (ent instanceof IMob) {
                tess.func_78386_a(1.0f, 0.0f, 0.0f);
            } else if (ent instanceof EntityPlayer) {
                tess.func_78386_a(1.0f, 0.0f, 1.0f);
            } else if (ent instanceof EntityLiving) {
                tess.func_78386_a(0.0f, 1.0f, 0.0f);
            } else if (ent instanceof EntityItem) {
                tess.func_78386_a(1.0f, 1.0f, 0.5f);
            } else {
                if (!(ent instanceof EntityXPOrb)) continue;
                if (player.field_70173_aa % 10 < 5) {
                    tess.func_78386_a(1.0f, 1.0f, 0.5f);
                } else {
                    tess.func_78386_a(0.5f, 1.0f, 0.5f);
                }
            }
            if (ent instanceof EntityLivingBase && ((EntityLivingBase)ent).func_110143_aJ() <= 0.0f) {
                tess.func_78386_a(0.0f, 0.0f, 0.0f);
            }
            AxisAlignedBB bb = ent.field_70121_D;
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72334_f - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72339_c - z);
            tess.func_78377_a(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72334_f - z);
        }
        tess.func_78381_a();
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void renderMarkers(float partialTicks) {
        markers.putAll(queuedMarkers);
        queuedMarkers.clear();
        if (markers.isEmpty()) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GL11.glPushMatrix();
        GL11.glDisable((int)2903);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2832);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(1);
        Iterator<Map.Entry<BlockPos, Marker>> it = markers.entrySet().iterator();
        ArrayList<Map.Entry<BlockPos, Marker>> tagList = new ArrayList<Map.Entry<BlockPos, Marker>>();
        while (it.hasNext()) {
            double aZ;
            double aY;
            double aX;
            Vec3 vec;
            Map.Entry<BlockPos, Marker> entry = it.next();
            BlockPos blockPos = entry.getKey();
            Marker marker = entry.getValue();
            int pX = blockPos.getX();
            int pY = blockPos.getY();
            int pZ = blockPos.getZ();
            double minX = marker.minX;
            double minY = marker.minY;
            double minZ = marker.minZ;
            double maxX = marker.maxX;
            double maxY = marker.maxY;
            double maxZ = marker.maxZ;
            tess.func_78378_d(marker.color);
            tess.func_78377_a((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + minY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + minY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + minY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + minY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + maxZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + minY - y, (double)pZ + minZ - z);
            tess.func_78377_a((double)pX + minX - x, (double)pY + minY - y, (double)pZ + maxZ - z);
            tagList.add(entry);
            if (marker.expire > 0L && Clock.get_ms() > marker.expire) {
                it.remove();
                continue;
            }
            if (!(marker.maxDist > 0.0) || !((vec = Vec3.func_72443_a((double)(x - (aX = (double)pX + (maxX - minX) / 2.0)), (double)(y - (aY = (double)pY + (maxY - minY) / 2.0)), (double)(z - (aZ = (double)pZ + (maxZ - minZ) / 2.0)))).func_72433_c() > marker.maxDist)) continue;
            it.remove();
        }
        tess.func_78381_a();
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        for (Map.Entry entry : tagList) {
            BlockPos pos = (BlockPos)entry.getKey();
            Marker marker = (Marker)entry.getValue();
            int pX = pos.getX();
            int pY = pos.getY();
            int pZ = pos.getZ();
            double minX = marker.minX;
            double minY = marker.minY;
            double minZ = marker.minZ;
            double maxX = marker.maxX;
            double maxY = marker.maxY;
            double maxZ = marker.maxZ;
            double aX = (double)pX + (maxX - minX) / 2.0;
            double aY = (double)pY + (maxY - minY) / 2.0;
            double aZ = (double)pZ + (maxZ - minZ) / 2.0;
            Vec3 vec = Vec3.func_72443_a((double)(aX - x), (double)(aY - y), (double)(aZ - z));
            double len = vec.field_72450_a * vec.field_72450_a + vec.field_72448_b * vec.field_72448_b + vec.field_72449_c * vec.field_72449_c;
            double sqrt = Math.sqrt(len);
            double mult = Math.min(sqrt, 16.0);
            vec.field_72450_a *= mult / sqrt;
            vec.field_72448_b *= mult / sqrt;
            vec.field_72449_c *= mult / sqrt;
            Vec3 look = player.func_70040_Z();
            Vec3 diff = vec.func_72432_b();
            String label = marker.label;
            if (label == null) {
                label = "";
            }
            if (Math.abs(look.field_72450_a - diff.field_72450_a) + Math.abs(look.field_72448_b - diff.field_72448_b) + Math.abs(look.field_72449_c - diff.field_72449_c) < 0.15) {
                label = label + (!label.isEmpty() ? " " : "") + (int)sqrt + "m";
            }
            if (label.isEmpty()) continue;
            RenderOverhead.drawTag(1.0f, len, label, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 100, true, marker.color, marker.color);
        }
        GL11.glPopMatrix();
    }

    public static void setActionPreview(WorldInAJar wiaj, int x, int y, int z, boolean canAction) {
        actionPreviewWorld = wiaj;
        offsetX = x;
        offsetY = y;
        offsetZ = z;
        actionPreviewSuccess = canAction;
    }

    public static void clearActionPreview() {
        clearPreview = true;
    }

    public static void renderActionPreview(float partialTicks) {
        if (clearPreview) {
            actionPreviewWorld = null;
            clearPreview = false;
        }
        if (actionPreviewWorld == null) {
            return;
        }
        RenderBlocks renderer = new RenderBlocks((IBlockAccess)actionPreviewWorld);
        renderer.field_147863_w = true;
        RenderOverhead.actionPreviewWorld.lightlevel = 15;
        RenderHelper.func_74518_a();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GL11.glTranslated((double)((double)offsetX - x), (double)((double)offsetY - y), (double)((double)offsetZ - z));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glShadeModel((int)7425);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78383_c();
        if (actionPreviewSuccess) {
            GL11.glColor3f((float)0.0f, (float)1.0f, (float)1.0f);
        } else {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        }
        for (int ix = 0; ix < RenderOverhead.actionPreviewWorld.sizeX; ++ix) {
            for (int iy = 0; iy < RenderOverhead.actionPreviewWorld.sizeY; ++iy) {
                for (int iz = 0; iz < RenderOverhead.actionPreviewWorld.sizeZ; ++iz) {
                    try {
                        renderer.func_147805_b(actionPreviewWorld.func_147439_a(ix, iy, iz), ix, iy, iz);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }

    public static class Marker {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        int color;
        String label;
        long expire;
        double maxDist;

        public Marker(int color) {
            this.color = color;
        }

        public Marker setExpire(long expire) {
            this.expire = expire;
            return this;
        }

        public Marker setDist(double maxDist) {
            this.maxDist = maxDist;
            return this;
        }

        public Marker withLabel(String label) {
            this.label = label;
            return this;
        }
    }
}

