/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IHeatSource;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.ReactorResearch;
import com.hbm.config.CustomMachineConfigJSON;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.inventory.container.ContainerMachineCustom;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineCustom;
import com.hbm.inventory.recipes.CustomMachineRecipes;
import com.hbm.lib.Library;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.tileentity.TileEntityProxyBase;
import com.hbm.tileentity.machine.TileEntityReactorResearch;
import com.hbm.util.BufferUtil;
import com.hbm.util.Compat;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCustomMachine
extends TileEntityMachinePolluting
implements IFluidStandardTransceiver,
IEnergyProviderMK2,
IEnergyReceiverMK2,
IGUIProvider {
    public String machineType;
    public CustomMachineConfigJSON.MachineConfiguration config;
    public long power;
    public int flux;
    public int heat;
    public int maxHeat;
    public int progress;
    public int maxProgress = 1;
    public FluidTank[] inputTanks;
    public FluidTank[] outputTanks;
    public ModulePatternMatcher matcher;
    public int structureCheckDelay;
    public boolean structureOK = false;
    public CustomMachineRecipes.CustomMachineRecipe cachedRecipe;
    public List<DirPos> connectionPos = new ArrayList<DirPos>();
    public List<DirPos> fluxPos = new ArrayList<DirPos>();
    public List<DirPos> heatPos = new ArrayList<DirPos>();

    public TileEntityCustomMachine() {
        super(22, 100);
    }

    public void init() {
        CustomMachineConfigJSON.MachineConfiguration config = CustomMachineConfigJSON.customMachines.get(this.machineType);
        if (config != null) {
            int i;
            this.config = config;
            this.inputTanks = new FluidTank[config.fluidInCount];
            for (i = 0; i < this.inputTanks.length; ++i) {
                this.inputTanks[i] = new FluidTank(Fluids.NONE, config.fluidInCap);
            }
            this.outputTanks = new FluidTank[config.fluidOutCount];
            for (i = 0; i < this.outputTanks.length; ++i) {
                this.outputTanks[i] = new FluidTank(Fluids.NONE, config.fluidOutCap);
            }
            this.maxHeat = config.maxHeat;
            this.matcher = new ModulePatternMatcher(config.itemInCount);
            this.smoke.changeTankSize(config.maxPollutionCap);
            this.smoke_leaded.changeTankSize(config.maxPollutionCap);
            this.smoke_poison.changeTankSize(config.maxPollutionCap);
        } else {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
    }

    @Override
    public String getName() {
        return this.config != null ? this.config.localizedName : "INVALID";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.config == null) {
                this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                return;
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.config.maxPower);
            if (this.inputTanks.length > 0) {
                this.inputTanks[0].setType(1, this.slots);
            }
            if (this.inputTanks.length > 1) {
                this.inputTanks[1].setType(2, this.slots);
            }
            if (this.inputTanks.length > 2) {
                this.inputTanks[2].setType(3, this.slots);
            }
            --this.structureCheckDelay;
            if (this.structureCheckDelay <= 0) {
                this.checkStructure();
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.connectionPos) {
                    for (FluidTank fluidTank : this.inputTanks) {
                        this.trySubscribe(fluidTank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    }
                    if (this.config.generatorMode) continue;
                    this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                for (int d = 2; d < 6; d = (int)((byte)(d + 1))) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)d);
                    for (DirPos pos : this.fluxPos) {
                        TileEntity tile;
                        int[] nArray;
                        Block b = this.field_145850_b.func_147439_a(pos.getX() + dir.offsetX, pos.getY(), pos.getZ() + dir.offsetZ);
                        if (b != ModBlocks.reactor_research || (nArray = ((ReactorResearch)ModBlocks.reactor_research).findCore(this.field_145850_b, pos.getX() + dir.offsetX, pos.getY(), pos.getZ() + dir.offsetZ)) == null || !((tile = this.field_145850_b.func_147438_o(nArray[0], nArray[1], nArray[2])) instanceof TileEntityReactorResearch)) continue;
                        TileEntityReactorResearch reactor = (TileEntityReactorResearch)tile;
                        this.flux = reactor.totalFlux;
                    }
                    if (this.config.maxHeat <= 0) continue;
                    for (DirPos pos : this.heatPos) {
                        this.tryPullHeat(pos.getX() + dir.offsetX, pos.getY() - 1, pos.getZ() + dir.offsetZ);
                    }
                }
            }
            for (DirPos pos : this.connectionPos) {
                if (this.config.generatorMode && this.power > 0L) {
                    this.tryProvide(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                for (FluidTank fluidTank : this.outputTanks) {
                    if (fluidTank.getFill() <= 0) continue;
                    this.sendFluid(fluidTank, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                this.sendSmoke(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.structureOK) {
                CustomMachineRecipes.CustomMachineRecipe recipe;
                if (this.config.generatorMode) {
                    if (this.cachedRecipe == null && (recipe = this.getMatchingRecipe()) != null && this.hasRequiredQuantities(recipe) && this.hasSpace(recipe)) {
                        this.cachedRecipe = recipe;
                        this.useUpInput(recipe);
                    }
                    if (this.cachedRecipe != null) {
                        this.maxProgress = (int)Math.max((double)this.cachedRecipe.duration / this.config.recipeSpeedMult, 1.0);
                        int powerReq = (int)Math.max((double)this.cachedRecipe.consumptionPerTick * this.config.recipeConsumptionMult, 1.0);
                        ++this.progress;
                        this.power += (long)powerReq;
                        this.heat -= this.cachedRecipe.heat;
                        if (this.power > this.config.maxPower) {
                            this.power = this.config.maxPower;
                        }
                        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                            this.pollution(this.cachedRecipe);
                            this.radiation(this.cachedRecipe);
                        }
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            this.processRecipe(this.cachedRecipe);
                            this.cachedRecipe = null;
                        }
                    }
                } else {
                    recipe = this.getMatchingRecipe();
                    if (recipe != null) {
                        this.maxProgress = (int)Math.max((double)recipe.duration / this.config.recipeSpeedMult, 1.0);
                        int powerReq = (int)Math.max((double)recipe.consumptionPerTick * this.config.recipeConsumptionMult, 1.0);
                        if (this.power >= (long)powerReq && this.hasRequiredQuantities(recipe) && this.hasSpace(recipe)) {
                            ++this.progress;
                            this.power -= (long)powerReq;
                            this.heat -= recipe.heat;
                            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                                this.pollution(recipe);
                                this.radiation(recipe);
                            }
                            if (this.progress >= this.maxProgress) {
                                this.progress = 0;
                                this.useUpInput(recipe);
                                this.processRecipe(recipe);
                            }
                        }
                    } else {
                        this.progress = 0;
                    }
                }
            } else {
                this.progress = 0;
            }
            this.networkPackNT(50);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        BufferUtil.writeString(buf, this.machineType);
        buf.writeLong(this.power);
        buf.writeInt(this.progress);
        buf.writeInt(this.flux);
        buf.writeInt(this.heat);
        buf.writeBoolean(this.structureOK);
        buf.writeInt(this.maxProgress);
        for (FluidTank inputTank : this.inputTanks) {
            inputTank.serialize(buf);
        }
        for (FluidTank outputTank : this.outputTanks) {
            outputTank.serialize(buf);
        }
        this.matcher.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.machineType = BufferUtil.readString(buf);
        if (this.config == null) {
            this.init();
        }
        this.power = buf.readLong();
        this.progress = buf.readInt();
        this.flux = buf.readInt();
        this.heat = buf.readInt();
        this.structureOK = buf.readBoolean();
        this.maxProgress = buf.readInt();
        for (FluidTank inputTank : this.inputTanks) {
            inputTank.deserialize(buf);
        }
        for (FluidTank outputTank : this.outputTanks) {
            outputTank.deserialize(buf);
        }
        this.matcher.deserialize(buf);
    }

    public CustomMachineRecipes.CustomMachineRecipe getMatchingRecipe() {
        List<CustomMachineRecipes.CustomMachineRecipe> recipes = CustomMachineRecipes.recipes.get(this.config.recipeKey);
        if (recipes == null || recipes.isEmpty()) {
            return null;
        }
        block0: for (CustomMachineRecipes.CustomMachineRecipe recipe : recipes) {
            int i;
            for (i = 0; i < recipe.inputFluids.length; ++i) {
                if (this.inputTanks[i].getTankType() != recipe.inputFluids[i].type || this.inputTanks[i].getPressure() != recipe.inputFluids[i].pressure) continue block0;
            }
            for (i = 0; i < recipe.inputItems.length; ++i) {
                if (recipe.inputItems[i] != null && this.slots[i + 4] == null || !recipe.inputItems[i].matchesRecipe(this.slots[i + 4], true)) continue block0;
            }
            return recipe;
        }
        return null;
    }

    public void pollution(CustomMachineRecipes.CustomMachineRecipe recipe) {
        if (recipe.pollutionAmount > 0.0f) {
            this.pollute(PollutionHandler.PollutionType.valueOf(recipe.pollutionType), recipe.pollutionAmount);
        } else if (recipe.pollutionAmount < 0.0f && PollutionHandler.getPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.valueOf(recipe.pollutionType)) >= -recipe.pollutionAmount) {
            PollutionHandler.decrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.valueOf(recipe.pollutionType), -recipe.pollutionAmount);
        }
    }

    public void radiation(CustomMachineRecipes.CustomMachineRecipe recipe) {
        if (recipe.radiationAmount > 0.0f) {
            ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, recipe.radiationAmount);
        } else if (recipe.radiationAmount < 0.0f) {
            ChunkRadiationManager.proxy.decrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, -recipe.radiationAmount);
        }
    }

    protected void tryPullHeat(int x, int y, int z) {
        TileEntity con = this.field_145850_b.func_147438_o(x, y, z);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > this.maxHeat) {
                    this.heat = this.maxHeat;
                }
            }
        }
    }

    public boolean hasRequiredQuantities(CustomMachineRecipes.CustomMachineRecipe recipe) {
        int i;
        for (i = 0; i < recipe.inputFluids.length; ++i) {
            if (this.inputTanks[i].getFill() >= recipe.inputFluids[i].fill) continue;
            return false;
        }
        for (i = 0; i < recipe.inputItems.length; ++i) {
            if (this.slots[i + 4] == null || this.slots[i + 4].field_77994_a >= recipe.inputItems[i].stacksize) continue;
            return false;
        }
        if (this.config.fluxMode && this.flux < recipe.flux) {
            return false;
        }
        return this.config.maxHeat <= 0 || recipe.heat <= 0 || this.heat >= recipe.heat;
    }

    public boolean hasSpace(CustomMachineRecipes.CustomMachineRecipe recipe) {
        int i;
        for (i = 0; i < recipe.outputFluids.length; ++i) {
            if (this.outputTanks[i].getTankType() != recipe.outputFluids[i].type || this.outputTanks[i].getFill() + recipe.outputFluids[i].fill <= this.outputTanks[i].getMaxFill()) continue;
            return false;
        }
        for (i = 0; i < recipe.outputItems.length; ++i) {
            if (this.slots[i + 16] != null && (this.slots[i + 16].func_77973_b() != ((ItemStack)recipe.outputItems[i].key).func_77973_b() || this.slots[i + 16].func_77960_j() != ((ItemStack)recipe.outputItems[i].key).func_77960_j())) {
                return false;
            }
            if (this.slots[i + 16] == null || this.slots[16 + i].field_77994_a + ((ItemStack)recipe.outputItems[i].key).field_77994_a <= this.slots[i + 16].func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void useUpInput(CustomMachineRecipes.CustomMachineRecipe recipe) {
        int i;
        for (i = 0; i < recipe.inputFluids.length; ++i) {
            this.inputTanks[i].setFill(this.inputTanks[i].getFill() - recipe.inputFluids[i].fill);
        }
        for (i = 0; i < recipe.inputItems.length; ++i) {
            this.func_70298_a(i + 4, recipe.inputItems[i].stacksize);
        }
    }

    public void processRecipe(CustomMachineRecipes.CustomMachineRecipe recipe) {
        int i;
        for (i = 0; i < recipe.outputFluids.length; ++i) {
            if (this.outputTanks[i].getTankType() != recipe.outputFluids[i].type) {
                this.outputTanks[i].setTankType(recipe.outputFluids[i].type);
            }
            this.outputTanks[i].setFill(this.outputTanks[i].getFill() + recipe.outputFluids[i].fill);
        }
        for (i = 0; i < recipe.outputItems.length; ++i) {
            if (!(this.field_145850_b.field_73012_v.nextFloat() < ((Float)recipe.outputItems[i].value).floatValue())) continue;
            if (this.slots[i + 16] == null) {
                this.slots[i + 16] = ((ItemStack)recipe.outputItems[i].key).func_77946_l();
                continue;
            }
            this.slots[i + 16].field_77994_a += ((ItemStack)recipe.outputItems[i].key).field_77994_a;
        }
    }

    public boolean checkStructure() {
        this.connectionPos.clear();
        this.structureCheckDelay = 300;
        this.structureOK = false;
        if (this.config == null) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        for (CustomMachineConfigJSON.MachineConfiguration.ComponentDefinition comp : this.config.components) {
            Block b;
            int x = this.field_145851_c - dir.offsetX * comp.x + rot.offsetX * comp.x;
            int y = this.field_145848_d + comp.y;
            int z = this.field_145849_e - dir.offsetZ * comp.z + rot.offsetZ * comp.z;
            if (dir == ForgeDirection.EAST || dir == ForgeDirection.WEST) {
                x = this.field_145851_c + dir.offsetZ * comp.z - rot.offsetZ * comp.z;
                z = this.field_145849_e + dir.offsetX * comp.x - rot.offsetX * comp.x;
            }
            if ((b = this.field_145850_b.func_147439_a(x, y, z)) != comp.block) {
                return false;
            }
            int meta = this.field_145850_b.func_72805_g(x, y, z);
            if (!comp.allowedMetas.contains(meta)) {
                return false;
            }
            TileEntity tile = Compat.getTileStandard(this.field_145850_b, x, y, z);
            if (tile instanceof TileEntityProxyBase) {
                TileEntityProxyBase proxy = (TileEntityProxyBase)tile;
                proxy.cachedPosition = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                proxy.func_70296_d();
                ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
                int n = forgeDirectionArray.length;
                for (int i = 0; i < n; ++i) {
                    ForgeDirection facing = forgeDirectionArray[i];
                    this.connectionPos.add(new DirPos(x + facing.offsetX, y + facing.offsetY, z + facing.offsetZ, facing));
                }
            }
            if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.cm_flux) {
                for (ForgeDirection facing : ForgeDirection.VALID_DIRECTIONS) {
                    this.fluxPos.add(new DirPos(x + facing.offsetX, y + facing.offsetY, z + facing.offsetZ, facing));
                }
                continue;
            }
            if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.cm_heat) continue;
            for (ForgeDirection facing : ForgeDirection.VALID_DIRECTIONS) {
                this.heatPos.add(new DirPos(x + facing.offsetX, y + facing.offsetY, z + facing.offsetZ, facing));
            }
        }
        for (ForgeDirection facing : ForgeDirection.VALID_DIRECTIONS) {
            this.connectionPos.add(new DirPos(this.field_145851_c + facing.offsetX, this.field_145848_d + facing.offsetY, this.field_145849_e + facing.offsetZ, facing));
        }
        this.structureOK = true;
        return true;
    }

    public void buildStructure() {
        if (this.config == null) {
            return;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        for (CustomMachineConfigJSON.MachineConfiguration.ComponentDefinition comp : this.config.components) {
            int x = this.field_145851_c - dir.offsetX * comp.x + rot.offsetX * comp.x;
            int y = this.field_145848_d + comp.y;
            int z = this.field_145849_e - dir.offsetZ * comp.z + rot.offsetZ * comp.z;
            if (dir == ForgeDirection.EAST || dir == ForgeDirection.WEST) {
                x = this.field_145851_c + dir.offsetZ * comp.z - rot.offsetZ * comp.z;
                z = this.field_145849_e + dir.offsetX * comp.x - rot.offsetX * comp.x;
            }
            this.field_145850_b.func_147465_d(x, y, z, comp.block, ((Integer)comp.allowedMetas.toArray()[0]).intValue(), 3);
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        if (this.config == null) {
            return new int[0];
        }
        if (this.config.itemInCount > 5) {
            return new int[]{4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21};
        }
        if (this.config.itemInCount > 4) {
            return new int[]{4, 5, 6, 7, 8, 16, 17, 18, 19, 20, 21};
        }
        if (this.config.itemInCount > 3) {
            return new int[]{4, 5, 6, 7, 16, 17, 18, 19, 20, 21};
        }
        if (this.config.itemInCount > 2) {
            return new int[]{4, 5, 6, 16, 17, 18, 19, 20, 21};
        }
        if (this.config.itemInCount > 1) {
            return new int[]{4, 5, 16, 17, 18, 19, 20, 21};
        }
        if (this.config.itemInCount > 0) {
            return new int[]{4, 16, 17, 18, 19, 20, 21};
        }
        return new int[]{16, 17, 18, 19, 20, 21};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        return i >= 16 && i <= 21;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 4 || slot > 9) {
            return false;
        }
        int index = slot - 4;
        int filterSlot = slot + 6;
        if (this.slots[filterSlot] == null) {
            return true;
        }
        return this.matcher.isValidForFilter(this.slots[filterSlot], index, stack);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.machineType = nbt.func_74779_i("machineType");
        this.init();
        super.func_145839_a(nbt);
        if (this.config != null) {
            int i;
            for (i = 0; i < this.inputTanks.length; ++i) {
                this.inputTanks[i].readFromNBT(nbt, "i" + i);
            }
            for (i = 0; i < this.outputTanks.length; ++i) {
                this.outputTanks[i].readFromNBT(nbt, "o" + i);
            }
            this.matcher.readFromNBT(nbt);
            int index = nbt.func_74762_e("cachedIndex");
            if (index != -1) {
                this.cachedRecipe = CustomMachineRecipes.recipes.get(this.config.recipeKey).get(index);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        int i;
        if (this.machineType == null || this.config == null) {
            super.func_145841_b(nbt);
            return;
        }
        nbt.func_74778_a("machineType", this.machineType);
        super.func_145841_b(nbt);
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.inputTanks[i].writeToNBT(nbt, "i" + i);
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.outputTanks[i].writeToNBT(nbt, "o" + i);
        }
        this.matcher.writeToNBT(nbt);
        if (this.cachedRecipe != null) {
            int index = CustomMachineRecipes.recipes.get(this.config.recipeKey).indexOf(this.cachedRecipe);
            nbt.func_74768_a("cachedIndex", index);
        } else {
            nbt.func_74768_a("cachedIndex", -1);
        }
    }

    @Override
    public FluidTank[] getAllTanks() {
        int i;
        FluidTank[] all = new FluidTank[this.inputTanks.length + this.outputTanks.length];
        for (i = 0; i < this.inputTanks.length; ++i) {
            all[i] = this.inputTanks[i];
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            all[this.inputTanks.length + i] = this.outputTanks[i];
        }
        return all;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        int i;
        FluidTank[] all = new FluidTank[this.outputTanks.length + this.getSmokeTanks().length];
        for (i = 0; i < this.outputTanks.length; ++i) {
            all[i] = this.outputTanks[i];
        }
        for (i = 0; i < this.getSmokeTanks().length; ++i) {
            all[this.outputTanks.length + i] = this.getSmokeTanks()[i];
        }
        return all;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.inputTanks != null ? this.inputTanks : new FluidTank[]{};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (this.config == null) {
            return null;
        }
        return new ContainerMachineCustom(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (this.config == null) {
            return null;
        }
        return new GUIMachineCustom(player.field_71071_by, this);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return this.config != null ? this.config.maxPower : 1L;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long transferPower(long power) {
        if (this.config != null && this.config.generatorMode) {
            return power;
        }
        this.setPower(this.getPower() + power);
        if (this.getPower() > this.getMaxPower()) {
            long overshoot = this.getPower() - this.getMaxPower();
            this.setPower(this.getMaxPower());
            return overshoot;
        }
        return 0L;
    }

    @Override
    public long getReceiverSpeed() {
        if (this.config != null && !this.config.generatorMode) {
            return this.getMaxPower();
        }
        return 0L;
    }

    @Override
    public long getProviderSpeed() {
        if (this.config != null && this.config.generatorMode) {
            return this.getMaxPower();
        }
        return 0L;
    }
}

