/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerMachineRotaryFurnace;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineRotaryFurnace;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.inventory.recipes.RotaryFurnaceRecipes;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.module.ModuleBurnTime;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IConditionalInvAccess;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.util.CrucibleUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineRotaryFurnace
extends TileEntityMachinePolluting
implements IFluidStandardTransceiver,
IGUIProvider,
IFluidCopiable,
IConditionalInvAccess,
IConfigurableMachine {
    public FluidTank[] tanks = new FluidTank[3];
    public boolean isProgressing;
    public float progress;
    public int burnTime;
    public double burnHeat = 1.0;
    public int maxBurnTime;
    public int steamUsed = 0;
    public boolean isVenting;
    public Mats.MaterialStack output;
    public static final int maxOutput = MaterialShapes.BLOCK.q(16);
    public int anim;
    public int lastAnim;
    public static ModuleBurnTime burnModule = new ModuleBurnTime().setCokeTimeMod(1.25).setRocketTimeMod(1.5).setSolidTimeMod(1.5).setBalefireTimeMod(1.5).setSolidHeatMod(1.5).setRocketHeatMod(3.0).setBalefireHeatMod(10.0);
    AxisAlignedBB bb = null;

    public TileEntityMachineRotaryFurnace() {
        super(5, 50);
        this.tanks[0] = new FluidTank(Fluids.NONE, 16000);
        this.tanks[1] = new FluidTank(Fluids.STEAM, 12000);
        this.tanks[2] = new FluidTank(Fluids.SPENTSTEAM, 120);
    }

    @Override
    public String getName() {
        return "container.machineRotaryFurnace";
    }

    @Override
    public void func_145845_h() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        if (!this.field_145850_b.field_72995_K) {
            this.tanks[0].setType(3, this.slots);
            for (DirPos pos : this.getSteamPos()) {
                this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                if (this.tanks[2].getFill() <= 0) continue;
                this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.tanks[0].getTankType() != Fluids.NONE) {
                for (DirPos pos : this.getFluidPos()) {
                    this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            if (this.smoke.getFill() > 0) {
                this.sendFluid(this.smoke, this.field_145850_b, this.field_145851_c + rot.offsetX, this.field_145848_d + 5, this.field_145849_e + rot.offsetZ, Library.POS_Y);
            }
            if (this.output != null) {
                Mats.MaterialStack leftover;
                int prev = this.output.amount;
                Vec3 impact = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                this.output = leftover = CrucibleUtil.pourSingleStack(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)rot.offsetX * 2.875, (double)this.field_145848_d + 1.25, (double)this.field_145849_e + 0.5 + (double)rot.offsetZ * 2.875, 6.0, true, this.output, MaterialShapes.INGOT.q(1), impact);
                if (prev != this.output.amount) {
                    this.output = leftover;
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", leftover.material.moltenColor);
                    data.func_74774_a("dir", (byte)rot.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)(this.field_145848_d + 1) - (float)(Math.ceil(impact.field_72448_b) - 1.125)));
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5 + (double)rot.offsetX * 2.875, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.5 + (double)rot.offsetZ * 2.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 50.0));
                }
                if (this.output.amount <= 0) {
                    this.output = null;
                }
            }
            RotaryFurnaceRecipes.RotaryFurnaceRecipe recipe = RotaryFurnaceRecipes.getRecipe(this.slots[0], this.slots[1], this.slots[2]);
            this.isProgressing = false;
            if (recipe != null) {
                if (this.burnTime <= 0 && this.slots[4] != null && TileEntityFurnace.func_145954_b((ItemStack)this.slots[4])) {
                    this.burnHeat = burnModule.getMod(this.slots[4], burnModule.getModHeat());
                    this.maxBurnTime = this.burnTime = burnModule.getBurnTime(this.slots[4]) / 2;
                    this.func_70298_a(4, 1);
                    this.markChanged();
                }
                if (this.canProcess(recipe)) {
                    float speed = Math.max((float)this.burnHeat, 1.0f);
                    this.progress += speed / (float)recipe.duration;
                    speed = (float)(13.0 * Math.log10(speed) + 1.0);
                    this.tanks[1].setFill((int)((float)this.tanks[1].getFill() - (float)recipe.steam * speed));
                    this.steamUsed = (int)((float)this.steamUsed + (float)recipe.steam * speed);
                    this.isProgressing = true;
                    if (this.progress >= 1.0f) {
                        this.progress -= 1.0f;
                        this.consumeItems(recipe);
                        if (this.output == null) {
                            this.output = recipe.output.copy();
                        } else {
                            this.output.amount += recipe.output.amount;
                        }
                        this.func_70296_d();
                    }
                    if (this.burnTime > 0) {
                        this.pollute(PollutionHandler.PollutionType.SOOT, 0.0039999997f);
                        --this.burnTime;
                    }
                } else {
                    this.progress = 0.0f;
                }
                if (this.steamUsed >= 100) {
                    int steamReturn = this.steamUsed / 100;
                    int canReturn = this.tanks[2].getMaxFill() - this.tanks[2].getFill();
                    int doesReturn = Math.min(steamReturn, canReturn);
                    this.steamUsed -= doesReturn * 100;
                    this.tanks[2].setFill(this.tanks[2].getFill() + doesReturn);
                }
            } else {
                this.progress = 0.0f;
            }
            this.isVenting = false;
            this.networkPackNT(50);
        } else {
            if (this.burnTime > 0 && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 25.0) {
                Random rand = this.field_145850_b.field_73012_v;
                this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 0.5 + (double)rot.offsetX + rand.nextGaussian() * 0.25, (double)this.field_145848_d + 0.375, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 0.5 + (double)rot.offsetZ + rand.nextGaussian() * 0.25, 0.0, 0.0, 0.0);
            }
            if (this.isVenting && this.field_145850_b.func_82737_E() % 2L == 0L) {
                NBTTagCompound fx = new NBTTagCompound();
                fx.func_74778_a("type", "tower");
                fx.func_74776_a("lift", 10.0f);
                fx.func_74776_a("base", 0.25f);
                fx.func_74776_a("max", 2.5f);
                fx.func_74768_a("life", 100 + this.field_145850_b.field_73012_v.nextInt(20));
                fx.func_74768_a("color", 0x202020);
                fx.func_74780_a("posX", (double)this.field_145851_c + 0.5 + (double)rot.offsetX);
                fx.func_74780_a("posY", (double)(this.field_145848_d + 5));
                fx.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + (double)rot.offsetZ);
                MainRegistry.proxy.effectNT(fx);
            }
            this.lastAnim = this.anim;
            if (this.isProgressing) {
                this.anim += (int)Math.max(burnModule.getMod(this.slots[4], burnModule.getModHeat()), 1.0);
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        this.tanks[2].serialize(buf);
        buf.writeBoolean(this.isVenting);
        buf.writeBoolean(this.isProgressing);
        buf.writeFloat(this.progress);
        buf.writeInt(this.burnTime);
        buf.writeInt(this.maxBurnTime);
        if (this.output != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.output.material.id);
            buf.writeInt(this.output.amount);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.tanks[2].deserialize(buf);
        this.isVenting = buf.readBoolean();
        this.isProgressing = buf.readBoolean();
        this.progress = buf.readFloat();
        this.burnTime = buf.readInt();
        this.maxBurnTime = buf.readInt();
        this.output = buf.readBoolean() ? new Mats.MaterialStack(Mats.matById.get(buf.readInt()), buf.readInt()) : null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.tanks[2].readFromNBT(nbt, "t2");
        this.progress = nbt.func_74760_g("prog");
        this.burnTime = nbt.func_74762_e("burn");
        this.burnHeat = nbt.func_74769_h("heat");
        this.maxBurnTime = nbt.func_74762_e("maxBurn");
        if (nbt.func_74764_b("outType")) {
            NTMMaterial mat = Mats.matById.get(nbt.func_74762_e("outType"));
            this.output = new Mats.MaterialStack(mat, nbt.func_74762_e("outAmount"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
        this.tanks[2].writeToNBT(nbt, "t2");
        nbt.func_74776_a("prog", this.progress);
        nbt.func_74768_a("burn", this.burnTime);
        nbt.func_74780_a("heat", this.burnHeat);
        nbt.func_74768_a("maxBurn", this.maxBurnTime);
        if (this.output != null) {
            nbt.func_74768_a("outType", this.output.material.id);
            nbt.func_74768_a("outAmount", this.output.amount);
        }
    }

    public DirPos[] getSteamPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite())};
    }

    public DirPos[] getFluidPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - dir.offsetX + rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ + rot.offsetZ * 3, rot)};
    }

    public boolean canProcess(RotaryFurnaceRecipes.RotaryFurnaceRecipe recipe) {
        if (this.burnTime <= 0) {
            return false;
        }
        if (recipe.fluid != null) {
            if (this.tanks[0].getTankType() != recipe.fluid.type) {
                return false;
            }
            if (this.tanks[0].getFill() < recipe.fluid.fill) {
                return false;
            }
        }
        float speed = Math.max((float)this.burnHeat, 1.0f);
        if ((float)this.tanks[1].getFill() < (float)recipe.steam * speed) {
            return false;
        }
        if ((float)(this.tanks[2].getMaxFill() - this.tanks[2].getFill()) < (float)recipe.steam * speed / 100.0f) {
            return false;
        }
        if (this.steamUsed > 100) {
            return false;
        }
        if (this.output != null) {
            if (this.output.material != recipe.output.material) {
                return false;
            }
            if (this.output.amount + recipe.output.amount > maxOutput) {
                return false;
            }
        }
        return true;
    }

    public void consumeItems(RotaryFurnaceRecipes.RotaryFurnaceRecipe recipe) {
        block0: for (RecipesCommon.AStack aStack : recipe.ingredients) {
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = this.slots[i];
                if (!aStack.matchesRecipe(stack, true) || stack.field_77994_a < aStack.stacksize) continue;
                this.func_70298_a(i, aStack.stacksize);
                continue block0;
            }
        }
        if (recipe.fluid != null) {
            this.tanks[0].setFill(this.tanks[0].getFill() - recipe.fluid.fill);
        }
    }

    @Override
    public void pollute(PollutionHandler.PollutionType type, float amount) {
        FluidTank tank = type == PollutionHandler.PollutionType.SOOT ? this.smoke : (type == PollutionHandler.PollutionType.HEAVYMETAL ? this.smoke_leaded : this.smoke_poison);
        int fluidAmount = (int)Math.ceil(amount * 100.0f);
        tank.setFill(tank.getFill() + fluidAmount);
        if (tank.getFill() > tank.getMaxFill()) {
            int overflow = tank.getFill() - tank.getMaxFill();
            tank.setFill(tank.getMaxFill());
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, type, (float)overflow / 100.0f);
            this.isVenting = true;
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[0];
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot < 3 || slot == 4;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int x, int y, int z, int slot, ItemStack stack) {
        return slot < 3 || slot == 4;
    }

    @Override
    public boolean canExtractItem(int x, int y, int z, int slot, ItemStack stack, int side) {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(int x, int y, int z, int side) {
        BlockPos pos = new BlockPos(x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        BlockPos core = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (side == dir.getOpposite().ordinal() && pos.equals(core.clone().offset(dir, -1).offset(rot, -2))) {
            return new int[]{0};
        }
        if (side == dir.getOpposite().ordinal() && pos.equals(core.clone().offset(dir, -1).offset(rot, -1))) {
            return new int[]{1};
        }
        if (side == dir.getOpposite().ordinal() && pos.equals(core.clone().offset(dir, -1))) {
            return new int[]{2};
        }
        if (side == dir.ordinal() && pos.equals(core.clone().offset(dir, 1).offset(rot, -1))) {
            return new int[]{4};
        }
        return new int[0];
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1], this.tanks[2], this.smoke};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[2], this.smoke};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineRotaryFurnace(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineRotaryFurnace(player.field_71071_by, this);
    }

    @Override
    public String getConfigName() {
        return "rotaryfurnace";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        if (obj.has("burnModule")) {
            burnModule.readIfPresent(obj.get("M:burnModule").getAsJsonObject());
        }
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("M:burnModule").beginObject();
        burnModule.writeConfig(writer);
        writer.endObject();
    }
}

