/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.FluidNetMK2;
import api.hbm.fluidmk2.FluidNode;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import api.hbm.redstoneoverradio.IRORInteractive;
import api.hbm.redstoneoverradio.IRORValueProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.container.ContainerBarrel;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FT_Polluting;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.inventory.gui.GUIBarrel;
import com.hbm.lib.Library;
import com.hbm.saveddata.TomSaveData;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.uninos.UniNodespace;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityBarrel
extends TileEntityMachineBase
implements SimpleComponent,
IFluidStandardTransceiverMK2,
IPersistentNBT,
IGUIProvider,
CompatHandler.OCComponent,
IFluidCopiable,
IRORValueProvider,
IRORInteractive {
    protected FluidNode node;
    protected FluidType lastType;
    public FluidTank tank;
    public short mode = 0;
    public static final short modes = 4;
    public int age = 0;
    public byte lastRedstone = 0;

    public TileEntityBarrel() {
        super(6);
        this.tank = new FluidTank(Fluids.NONE, 0);
    }

    public TileEntityBarrel(int capacity) {
        super(6);
        this.tank = new FluidTank(Fluids.NONE, capacity);
    }

    @Override
    public String getName() {
        return "container.barrel";
    }

    public byte getComparatorPower() {
        if (this.tank.getFill() == 0) {
            return 0;
        }
        double frac = (double)this.tank.getFill() / (double)this.tank.getMaxFill() * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)frac + 1), (int)0, (int)15);
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        if (this.mode == 2 || this.mode == 3) {
            return 0L;
        }
        if (this.tank.getPressure() != pressure) {
            return 0L;
        }
        return type == this.tank.getTankType() ? (long)(this.tank.getMaxFill() - this.tank.getFill()) : 0L;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            byte comp = this.getComparatorPower();
            if (comp != this.lastRedstone) {
                this.func_70296_d();
                for (DirPos pos : this.getConPos()) {
                    this.updateRedstoneConnection(pos);
                }
            }
            this.lastRedstone = comp;
            this.tank.setType(0, 1, this.slots);
            this.tank.loadTank(2, 3, this.slots);
            this.tank.unloadTank(4, 5, this.slots);
            if (this.mode == 1) {
                if (this.node == null || this.node.expired || this.tank.getTankType() != this.lastType) {
                    this.node = (FluidNode)UniNodespace.getNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType().getNetworkProvider());
                    if (this.node == null || this.node.expired || this.tank.getTankType() != this.lastType) {
                        this.node = this.createNode(this.tank.getTankType());
                        UniNodespace.createNode(this.field_145850_b, this.node);
                        this.lastType = this.tank.getTankType();
                    }
                }
                if (this.node != null && this.node.hasValidNet()) {
                    ((FluidNetMK2)this.node.net).addProvider(this);
                    ((FluidNetMK2)this.node.net).addReceiver(this);
                }
            } else {
                if (this.node != null) {
                    UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType().getNetworkProvider());
                    this.node = null;
                }
                for (DirPos pos : this.getConPos()) {
                    FluidNode dirNode = (FluidNode)UniNodespace.getNode(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), this.tank.getTankType().getNetworkProvider());
                    if (this.mode == 2) {
                        this.tryProvide(this.tank, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    } else if (dirNode != null && dirNode.hasValidNet()) {
                        ((FluidNetMK2)dirNode.net).removeProvider(this);
                    }
                    if (this.mode == 0) {
                        if (dirNode == null || !dirNode.hasValidNet()) continue;
                        ((FluidNetMK2)dirNode.net).addReceiver(this);
                        continue;
                    }
                    if (dirNode == null || !dirNode.hasValidNet()) continue;
                    ((FluidNetMK2)dirNode.net).removeReceiver(this);
                }
            }
            if (this.tank.getFill() > 0) {
                this.checkFluidInteraction();
            }
            this.networkPackNT(50);
        }
    }

    protected FluidNode createNode(FluidType type) {
        DirPos[] conPos = this.getConPos();
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        posSet.add(new BlockPos(this));
        for (DirPos pos : conPos) {
            ForgeDirection dir = pos.getDir();
            posSet.add(new BlockPos(pos.getX() - dir.offsetX, pos.getY() - dir.offsetY, pos.getZ() - dir.offsetZ));
        }
        return new FluidNode(type.getNetworkProvider(), posSet.toArray(new BlockPos[posSet.size()])).setConnections(conPos);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.node != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType().getNetworkProvider());
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeShort((int)this.mode);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.mode = buf.readShort();
        this.tank.deserialize(buf);
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        ItemStack full = FluidContainerRegistry.getFullContainer(itemStack, this.tank.getTankType());
        if (i == 4 && full != null && FluidContainerRegistry.getFluidContent(full, this.tank.getTankType()) <= this.tank.getMaxFill()) {
            return true;
        }
        int content = FluidContainerRegistry.getFluidContent(itemStack, this.tank.getTankType());
        return i == 2 && content > 0 && content <= this.tank.getMaxFill();
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 3 || i == 5;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{2, 3, 4, 5};
    }

    public void checkFluidInteraction() {
        int light;
        Block b = this.func_145838_q();
        if (b != ModBlocks.barrel_antimatter && this.tank.getTankType().isAntimatter()) {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
            this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 5.0f, true, true);
        }
        if (b == ModBlocks.barrel_plastic && (this.tank.getTankType().isCorrosive() || this.tank.getTankType().isHot())) {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 1.0f);
        }
        if (b == ModBlocks.barrel_iron && this.tank.getTankType().isCorrosive() || b == ModBlocks.barrel_steel && this.tank.getTankType().hasTrait(FT_Corrosive.class) && this.tank.getTankType().getTrait(FT_Corrosive.class).getRating() > 50) {
            ItemStack[] copy = (ItemStack[])this.slots.clone();
            this.slots = new ItemStack[6];
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.barrel_corroded);
            TileEntityBarrel barrel = (TileEntityBarrel)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (barrel != null) {
                barrel.tank.setTankType(this.tank.getTankType());
                barrel.tank.setFill(Math.min(barrel.tank.getMaxFill(), this.tank.getFill()));
                barrel.slots = copy;
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 1.0f);
        }
        if (b == ModBlocks.barrel_corroded) {
            if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                this.tank.setFill(this.tank.getFill() - 1);
                FT_Polluting.pollute(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType(), FluidTrait.FluidReleaseType.SPILL, 1.0f);
            }
            if (this.field_145850_b.field_73012_v.nextInt(3600) == 0) {
                this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
            }
        }
        if (this.tank.getTankType() == Fluids.WATER && (double)TomSaveData.forWorld((World)this.field_145850_b).fire > 1.0E-5 && (light = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e)) > 7) {
            this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 5.0f, true, true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74765_d("mode");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mode", this.mode);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public boolean canConnect(FluidType fluid, ForgeDirection dir) {
        return true;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        FluidTank[] fluidTankArray;
        if (this.mode == 1 || this.mode == 2) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        FluidTank[] fluidTankArray;
        if (this.mode == 0 || this.mode == 1) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public IEnergyReceiverMK2.ConnectionPriority getFluidPriority() {
        return this.mode == 1 ? IEnergyReceiverMK2.ConnectionPriority.LOW : IEnergyReceiverMK2.ConnectionPriority.NORMAL;
    }

    @Override
    public int[] getFluidIDToCopy() {
        return new int[]{this.tank.getTankType().getID()};
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tank;
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tank.getFill() == 0) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        this.tank.writeToNBT(data, "tank");
        data.func_74777_a("mode", this.mode);
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        this.tank.readFromNBT(data, "tank");
        this.mode = data.func_74765_d("nbt");
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerBarrel(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIBarrel(player.field_71071_by, this);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_fluid_tank";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluidStored(Context context, Arguments args) {
        return new Object[]{this.tank.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getMaxStored(Context context, Arguments args) {
        return new Object[]{this.tank.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTypeStored(Context context, Arguments args) {
        return new Object[]{this.tank.getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tank.getFill(), this.tank.getMaxFill(), this.tank.getTankType().getName()};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getFluidStored", "getMaxStored", "getTypeStored", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getFluidStored": {
                return this.getFluidStored(context, args);
            }
            case "getMaxStored": {
                return this.getMaxStored(context, args);
            }
            case "getTypeStored": {
                return this.getTypeStored(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public String[] getFunctionInfo() {
        return new String[]{"VAL:type", "VAL:fill", "VAL:fillpercent", "FUN:setmode!mode", "FUN:setmode!mode:fallback"};
    }

    @Override
    public String provideRORValue(String name) {
        if ("VAL:type".equals(name)) {
            return this.tank.getTankType().getName();
        }
        if ("VAL:fill".equals(name)) {
            return "" + this.tank.getFill();
        }
        if ("VAL:fillpercent".equals(name)) {
            return "" + this.tank.getFill() * 100 / this.tank.getMaxFill();
        }
        return null;
    }

    @Override
    public String runRORFunction(String name, String[] params) {
        if ("FUN:setmode".equals(name) && params.length > 0) {
            int mode = IRORInteractive.parseInt(params[0], 0, 3);
            if (mode != this.mode) {
                this.mode = (short)mode;
                this.markChanged();
                return null;
            }
            if (params.length > 1) {
                int altmode = IRORInteractive.parseInt(params[1], 0, 3);
                this.mode = (short)altmode;
                this.markChanged();
                return null;
            }
            return null;
        }
        return null;
    }
}

