/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;

public abstract class TileEntityCrateBase
extends TileEntityLockableBase
implements ISidedInventory,
IGUIProvider {
    protected ItemStack[] slots;
    public String customName;
    public boolean hasSpiders = false;
    private static final int numSpiders = 3;

    public TileEntityCrateBase(int count) {
        this.slots = new ItemStack[count];
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.crateOpen", 1.0f, 1.0f);
    }

    public void func_70305_f() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.crateClose", 1.0f, 1.0f);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            this.func_70296_d();
            return itemStack1;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
        this.hasSpiders = nbt.func_74767_n("spiders");
        this.customName = nbt.func_74779_i("name");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
        nbt.func_74757_a("spiders", this.hasSpiders);
        if (this.customName != null) {
            nbt.func_74778_a("name", this.customName);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int[] func_94128_d(int side) {
        int[] slots = new int[this.slots.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack) && !this.isLocked();
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return !this.isLocked();
    }

    public void fillWithSpiders() {
        this.hasSpiders = true;
    }

    public static void spawnSpiders(EntityPlayer player, World worldObj, TileEntityCrateBase crate) {
        if (crate.hasSpiders) {
            Random random = new Random();
            for (int i = 0; i < 3; ++i) {
                EntityCaveSpider spider = new EntityCaveSpider(worldObj);
                spider.func_70012_b((double)crate.field_145851_c + random.nextGaussian() * 2.0, (double)(crate.field_145848_d + 1), (double)crate.field_145849_e + random.nextGaussian() * 2.0, random.nextFloat(), 0.0f);
                spider.func_70624_b((EntityLivingBase)player);
                worldObj.func_72838_d((Entity)spider);
            }
            crate.hasSpiders = false;
            crate.func_70296_d();
        }
    }

    public static void spawnSpiders(EntityPlayer player, World worldObj, ItemStack crate) {
        if (crate.func_77942_o() && crate.func_77978_p().func_74767_n("spiders")) {
            Random random = new Random();
            for (int i = 0; i < 3; ++i) {
                EntityCaveSpider spider = new EntityCaveSpider(worldObj);
                spider.func_70012_b(player.field_70165_t + random.nextGaussian() * 2.0, player.field_70163_u + 1.0, player.field_70161_v + random.nextGaussian() * 2.0, random.nextFloat(), 0.0f);
                spider.func_70624_b((EntityLivingBase)player);
                worldObj.func_72838_d((Entity)spider);
            }
            crate.func_77978_p().func_82580_o("spiders");
        }
    }
}

