/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BufferUtil;
import cpw.mods.fml.common.Optional;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRadioTorchBase
extends TileEntityLoadedBase
implements IControlReceiver,
SimpleComponent,
CompatHandler.OCComponent {
    public String channel = "";
    public int lastState = 0;
    public long lastUpdate;
    public boolean polling = false;
    public boolean customMap = false;
    public String[] mapping = new String[16];

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.networkPackNT(50);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.polling = nbt.func_74767_n("p");
        this.customMap = nbt.func_74767_n("m");
        this.lastState = nbt.func_74762_e("l");
        this.lastUpdate = nbt.func_74763_f("u");
        this.channel = nbt.func_74779_i("c");
        for (int i = 0; i < 16; ++i) {
            this.mapping[i] = nbt.func_74779_i("m" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("p", this.polling);
        nbt.func_74757_a("m", this.customMap);
        nbt.func_74768_a("l", this.lastState);
        nbt.func_74772_a("u", this.lastUpdate);
        if (this.channel != null) {
            nbt.func_74778_a("c", this.channel);
        }
        for (int i = 0; i < 16; ++i) {
            if (this.mapping[i] == null) continue;
            nbt.func_74778_a("m" + i, this.mapping[i]);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBoolean(this.polling);
        buf.writeBoolean(this.customMap);
        BufferUtil.writeString(buf, this.channel);
        for (int i = 0; i < 16; ++i) {
            BufferUtil.writeString(buf, this.mapping[i]);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.polling = buf.readBoolean();
        this.customMap = buf.readBoolean();
        this.channel = BufferUtil.readString(buf);
        for (int i = 0; i < 16; ++i) {
            this.mapping[i] = BufferUtil.readString(buf);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("l", (byte)this.lastState);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        int last = this.lastState;
        this.lastState = pkt.func_148857_g().func_74771_c("l");
        if (this.lastState != last) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 16.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("p")) {
            this.polling = data.func_74767_n("p");
        }
        if (data.func_74764_b("m")) {
            this.customMap = data.func_74767_n("m");
        }
        if (data.func_74764_b("c")) {
            this.channel = data.func_74779_i("c");
        }
        for (int i = 0; i < 16; ++i) {
            if (!data.func_74764_b("m" + i)) continue;
            this.mapping[i] = data.func_74779_i("m" + i);
        }
        this.func_70296_d();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "radio_torch";
    }

    @Callback(direct=true, limit=4, doc="setChannle(channel: string) -- Set the channel the torch is listening/broadcasting to")
    @Optional.Method(modid="OpenComputers")
    public Object[] setChannel(Context context, Arguments args) {
        this.channel = args.checkString(0);
        return new Object[0];
    }

    @Callback(direct=true, limit=4, doc="setPolling(value: boolean) -- Switches state change mode to tick-based polling")
    @Optional.Method(modid="OpenComputers")
    public Object[] setPolling(Context context, Arguments args) {
        this.polling = args.checkBoolean(0);
        return new Object[0];
    }

    @Callback(direct=true, limit=4, doc="setCustomMap(value: boolean) -- Switches redstone passthrough to custom signal mapping")
    @Optional.Method(modid="OpenComputers")
    public Object[] setCustomMap(Context context, Arguments args) {
        this.customMap = args.checkBoolean(0);
        return new Object[0];
    }

    @Callback(direct=true, limit=4, doc="setCustomMapValues(value: table) -- Sets the custom signal mapping values with a table with indices corresponding to the redstone value (1-16)")
    @Optional.Method(modid="OpenComputers")
    public Object[] setCustomMapValues(Context context, Arguments args) {
        Map values = args.checkTable(0);
        for (int i = 1; i <= 16; ++i) {
            if (!values.containsKey(i) || !(values.get(i) instanceof String)) continue;
            this.mapping[i - 1] = (String)values.get(i);
        }
        return new Object[0];
    }
}

