/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.util.Tuple;

public class NoteBuilder {
    private String beat = "";

    public static NoteBuilder start() {
        return new NoteBuilder();
    }

    public NoteBuilder add(Instrument instrument, Note note, Octave octave) {
        if (!this.beat.isEmpty()) {
            this.beat = this.beat + "-";
        }
        String result = instrument.ordinal() + ":" + note.ordinal() + ":" + octave.ordinal();
        this.beat = this.beat + result;
        return this;
    }

    public String end() {
        return this.beat;
    }

    public static Tuple.Triplet<Instrument, Note, Octave>[] translate(String beat) {
        String[] hits = beat.split("-");
        Tuple.Triplet[] notes = new Tuple.Triplet[hits.length];
        try {
            for (int i = 0; i < hits.length; ++i) {
                String[] components = hits[i].split(":");
                Instrument instrument = Instrument.values()[Integer.parseInt(components[0])];
                Note note = Note.values()[Integer.parseInt(components[1])];
                Octave octave = Octave.values()[Integer.parseInt(components[2])];
                notes[i] = new Tuple.Triplet<Instrument, Note, Octave>(instrument, note, octave);
            }
            return notes;
        }
        catch (Exception ex) {
            return new Tuple.Triplet[0];
        }
    }

    public static enum Octave {
        LOW,
        MID,
        HIGH;

    }

    public static enum Note {
        F_SHARP,
        G,
        G_SHARP,
        A,
        A_SHARP,
        B,
        C,
        C_SHARP,
        D,
        D_SHARP,
        E,
        F;

    }

    public static enum Instrument {
        PIANO,
        BASSDRUM,
        SNARE,
        CLICKS,
        BASSGUITAR;

    }
}

