/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TimeAnalyzer {
    private static List<Tuple.Pair<String, Long>> deltas = new ArrayList<Tuple.Pair<String, Long>>();
    private static String currentSection = "";
    private static long sectionStartTime = 0L;

    public static void startCount(String section) {
        currentSection = section;
        sectionStartTime = System.nanoTime();
    }

    public static void endCount() {
        long delta = System.nanoTime() - sectionStartTime;
        deltas.add(new Tuple.Pair<String, Long>(currentSection, delta));
    }

    public static void startEndCount(String section) {
        TimeAnalyzer.endCount();
        TimeAnalyzer.startCount(section);
    }

    public static void dump() {
        HashMap<String, Long> milliTime = new HashMap<String, Long>();
        for (Tuple.Pair<String, Long> delta : deltas) {
            Long total = (Long)milliTime.get(delta.getKey());
            if (total == null) {
                total = new Long(0L);
            }
            total = total + delta.getValue();
            milliTime.put(delta.getKey(), total);
        }
        long total = 0L;
        for (Map.Entry entry : milliTime.entrySet()) {
            total += ((Long)entry.getValue()).longValue();
            String time = String.format(Locale.US, "%,d", entry.getValue());
            System.out.println((String)entry.getKey() + ": " + time + "ns");
        }
        System.out.println("Total time passed: " + String.format(Locale.US, "%,d", total) + "ns (" + total / 1000000000L + "s)");
        currentSection = "";
        sectionStartTime = 0L;
        deltas.clear();
    }
}

