/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.component;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBobble;
import com.hbm.config.StructureConfig;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Component
extends StructureComponent {
    protected int hpos = -1;

    protected Component() {
        super(0);
    }

    protected Component(int componentType) {
        super(componentType);
    }

    protected Component(Random rand, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(0);
        this.field_74885_f = rand.nextInt(4);
        switch (this.field_74885_f) {
            case 0: {
                this.field_74887_e = new StructureBoundingBox(minX, minY, minZ, minX + maxX, minY + maxY, minZ + maxZ);
                break;
            }
            case 1: {
                this.field_74887_e = new StructureBoundingBox(minX, minY, minZ, minX + maxZ, minY + maxY, minZ + maxX);
                break;
            }
            case 2: {
                this.field_74887_e = new StructureBoundingBox(minX, minY, minZ, minX + maxX, minY + maxY, minZ + maxZ);
                break;
            }
            case 3: {
                this.field_74887_e = new StructureBoundingBox(minX, minY, minZ, minX + maxZ, minY + maxY, minZ + maxX);
                break;
            }
            default: {
                this.field_74887_e = new StructureBoundingBox(minX, minY, minZ, minX + maxX, minY + maxY, minZ + maxZ);
            }
        }
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        nbt.func_74768_a("HPos", this.hpos);
    }

    protected void func_143011_b(NBTTagCompound nbt) {
        this.hpos = nbt.func_74762_e("HPos");
    }

    protected boolean setAverageHeight(World world, StructureBoundingBox box, int y) {
        int total = 0;
        int iterations = 0;
        for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
            for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                if (!box.func_78890_b(x, y, z)) continue;
                total += Math.max(world.func_72825_h(x, z), world.field_73011_w.func_76557_i());
                ++iterations;
            }
        }
        if (iterations == 0) {
            return false;
        }
        this.hpos = total / iterations;
        this.field_74887_e.func_78886_a(0, this.hpos - this.field_74887_e.field_78895_b, 0);
        return true;
    }

    protected static int getAverageHeight(World world, StructureBoundingBox area, StructureBoundingBox box, int y) {
        int total = 0;
        int iterations = 0;
        for (int z = area.field_78896_c; z <= area.field_78892_f; ++z) {
            for (int x = area.field_78897_a; x <= area.field_78893_d; ++x) {
                if (!box.func_78890_b(x, y, z)) continue;
                total += Math.max(world.func_72825_h(x, z), world.field_73011_w.func_76557_i());
                ++iterations;
            }
        }
        if (iterations == 0) {
            return -1;
        }
        return total / iterations;
    }

    public int getCoordMode() {
        return this.field_74885_f;
    }

    protected int getPillarMeta(int metadata) {
        if (this.field_74885_f % 2 != 0 && this.field_74885_f != -1) {
            metadata ^= 0xC;
        }
        return metadata;
    }

    protected int getDecoMeta(int metadata) {
        switch (this.field_74885_f) {
            case 0: {
                switch (metadata) {
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                    case 4: {
                        return 4;
                    }
                    case 5: {
                        return 5;
                    }
                }
            }
            case 1: {
                switch (metadata) {
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 2;
                    }
                    case 5: {
                        return 3;
                    }
                }
            }
            case 2: {
                switch (metadata) {
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 4;
                    }
                }
            }
            case 3: {
                switch (metadata) {
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 5;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                }
            }
        }
        return 0;
    }

    protected int getDecoModelMeta(int metadata) {
        switch (this.field_74885_f) {
            default: {
                break;
            }
            case 1: {
                if ((metadata & 3) < 2) {
                    metadata ^= 3;
                    break;
                }
                metadata ^= 2;
                break;
            }
            case 2: {
                metadata ^= 1;
                break;
            }
            case 3: {
                if ((metadata & 3) < 2) {
                    metadata ^= 2;
                    break;
                }
                metadata ^= 3;
            }
        }
        return metadata << 2;
    }

    protected int getCRTMeta(int meta) {
        return (meta + this.field_74885_f) % 4;
    }

    protected int getStairMeta(int metadata) {
        switch (this.field_74885_f) {
            default: {
                break;
            }
            case 1: {
                if ((metadata & 3) < 2) {
                    metadata ^= 2;
                    break;
                }
                metadata ^= 3;
                break;
            }
            case 2: {
                metadata ^= 1;
                break;
            }
            case 3: {
                if ((metadata & 3) < 2) {
                    metadata ^= 3;
                    break;
                }
                metadata ^= 2;
            }
        }
        return metadata;
    }

    protected void placeDoor(World world, StructureBoundingBox box, Block door, int dirMeta, boolean opensRight, boolean isOpen, int featureX, int featureY, int featureZ) {
        int posZ;
        int posY;
        int posX = this.func_74865_a(featureX, featureZ);
        if (!box.func_78890_b(posX, posY = this.func_74862_a(featureY), posZ = this.func_74873_b(featureX, featureZ))) {
            return;
        }
        switch (this.field_74885_f) {
            default: {
                break;
            }
            case 1: {
                dirMeta = (dirMeta + 1) % 4;
                break;
            }
            case 2: {
                dirMeta ^= 2;
                break;
            }
            case 3: {
                dirMeta = (dirMeta + 3) % 4;
            }
        }
        int metaTop = opensRight ? 9 : 8;
        int metaBottom = dirMeta | (isOpen ? 4 : 0);
        if (World.func_147466_a((IBlockAccess)world, (int)posX, (int)(posY - 1), (int)posZ)) {
            world.func_147465_d(posX, posY, posZ, door, metaBottom, 2);
            world.func_147465_d(posX, posY + 1, posZ, door, metaTop, 2);
        }
    }

    protected void placeLever(World world, StructureBoundingBox box, int dirMeta, boolean on, int featureX, int featureY, int featureZ) {
        int posZ;
        int posY;
        int posX = this.func_74865_a(featureX, featureZ);
        if (!box.func_78890_b(posX, posY = this.func_74862_a(featureY), posZ = this.func_74873_b(featureX, featureZ))) {
            return;
        }
        if (dirMeta <= 0 || dirMeta >= 7) {
            switch (this.field_74885_f) {
                case 1: 
                case 3: {
                    dirMeta ^= 7;
                }
            }
        } else if (dirMeta >= 5) {
            switch (this.field_74885_f) {
                case 1: 
                case 3: {
                    dirMeta = (dirMeta + 1) % 2 + 5;
                }
            }
        } else {
            dirMeta = this.getButtonMeta(dirMeta);
        }
        world.func_147465_d(posX, posY, posZ, Blocks.field_150442_at, on ? dirMeta | 8 : dirMeta, 2);
    }

    protected int getButtonMeta(int dirMeta) {
        switch (this.field_74885_f) {
            case 1: {
                if (dirMeta <= 2) {
                    return dirMeta + 2;
                }
                if (dirMeta < 4) {
                    return dirMeta - 1;
                }
                return dirMeta - 3;
            }
            case 2: {
                return dirMeta + (dirMeta % 2 == 0 ? -1 : 1);
            }
            case 3: {
                if (dirMeta <= 1) {
                    return dirMeta + 3;
                }
                if (dirMeta <= 2) {
                    return dirMeta + 1;
                }
                return dirMeta - 2;
            }
        }
        return dirMeta;
    }

    protected void placeBed(World world, StructureBoundingBox box, int meta, int featureX, int featureY, int featureZ) {
        int xOffset = 0;
        int zOffset = 0;
        switch (meta & 3) {
            default: {
                zOffset = 1;
                break;
            }
            case 1: {
                xOffset = -1;
                break;
            }
            case 2: {
                zOffset = -1;
                break;
            }
            case 3: {
                xOffset = 1;
            }
        }
        switch (this.field_74885_f) {
            default: {
                break;
            }
            case 1: {
                meta = (meta + 1) % 4;
                break;
            }
            case 2: {
                meta ^= 2;
                break;
            }
            case 3: {
                meta = (meta - 1) % 4;
            }
        }
        this.func_151550_a(world, Blocks.field_150324_C, meta, featureX, featureY, featureZ, box);
        this.func_151550_a(world, Blocks.field_150324_C, meta + 8, featureX + xOffset, featureY, featureZ + zOffset, box);
    }

    protected int getTripwireMeta(int metadata) {
        switch (this.field_74885_f) {
            default: {
                return metadata;
            }
            case 1: {
                return (metadata + 1) % 4;
            }
            case 2: {
                return metadata ^ 2;
            }
            case 3: 
        }
        return (metadata - 1) % 4;
    }

    protected boolean generateInvContents(World world, StructureBoundingBox box, Random rand, Block block, int featureX, int featureY, int featureZ, WeightedRandomChestContent[] content, int amount) {
        return this.generateInvContents(world, box, rand, block, 0, featureX, featureY, featureZ, content, amount);
    }

    protected boolean generateInvContents(World world, StructureBoundingBox box, Random rand, Block block, int meta, int featureX, int featureY, int featureZ, WeightedRandomChestContent[] content, int amount) {
        int posZ;
        int posY;
        int posX = this.func_74865_a(featureX, featureZ);
        if (!box.func_78890_b(posX, posY = this.func_74862_a(featureY), posZ = this.func_74873_b(featureX, featureZ)) || world.func_147439_a(posX, posY, posZ) == block) {
            return true;
        }
        this.func_151550_a(world, block, meta, featureX, featureY, featureZ, box);
        IInventory inventory = (IInventory)world.func_147438_o(posX, posY, posZ);
        if (inventory != null) {
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])content, (IInventory)inventory, (int)((amount = (int)Math.floor((double)amount * StructureConfig.lootAmountFactor)) < 1 ? 1 : amount));
            return true;
        }
        return false;
    }

    protected boolean generateLockableContents(World world, StructureBoundingBox box, Random rand, Block block, int featureX, int featureY, int featureZ, WeightedRandomChestContent[] content, int amount, double mod) {
        return this.generateLockableContents(world, box, rand, block, 0, featureX, featureY, featureZ, content, amount, mod);
    }

    protected boolean generateLockableContents(World world, StructureBoundingBox box, Random rand, Block block, int meta, int featureX, int featureY, int featureZ, WeightedRandomChestContent[] content, int amount, double mod) {
        int posZ;
        int posY;
        int posX = this.func_74865_a(featureX, featureZ);
        if (!box.func_78890_b(posX, posY = this.func_74862_a(featureY), posZ = this.func_74873_b(featureX, featureZ)) || world.func_147439_a(posX, posY, posZ) == block) {
            return false;
        }
        this.func_151550_a(world, block, meta, featureX, featureY, featureZ, box);
        TileEntity tile = world.func_147438_o(posX, posY, posZ);
        TileEntityLockableBase lock = (TileEntityLockableBase)tile;
        IInventory inventory = (IInventory)tile;
        if (inventory != null && lock != null) {
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])content, (IInventory)inventory, (int)((amount = (int)Math.floor((double)amount * StructureConfig.lootAmountFactor)) < 1 ? 1 : amount));
            lock.setPins(rand.nextInt(999) + 1);
            lock.setMod(mod);
            lock.lock();
            return true;
        }
        return false;
    }

    protected void generateLoreBook(World world, StructureBoundingBox box, int featureX, int featureY, int featureZ, int slot, ItemStack stack) {
        int posZ;
        int posY;
        int posX = this.func_74865_a(featureX, featureZ);
        if (!box.func_78890_b(posX, posY = this.func_74862_a(featureY), posZ = this.func_74873_b(featureX, featureZ))) {
            return;
        }
        IInventory inventory = (IInventory)world.func_147438_o(posX, posY, posZ);
        if (inventory != null) {
            inventory.func_70299_a(slot, stack);
        }
    }

    protected void placeRandomBobble(World world, StructureBoundingBox box, Random rand, int featureX, int featureY, int featureZ) {
        int posX = this.func_74865_a(featureX, featureZ);
        int posY = this.func_74862_a(featureY);
        int posZ = this.func_74873_b(featureX, featureZ);
        this.func_151550_a(world, ModBlocks.bobblehead, rand.nextInt(16), featureX, featureY, featureZ, box);
        BlockBobble.TileEntityBobble bobble = (BlockBobble.TileEntityBobble)world.func_147438_o(posX, posY, posZ);
        if (bobble != null) {
            bobble.type = BlockBobble.BobbleType.values()[rand.nextInt(BlockBobble.BobbleType.values().length - 1) + 1];
            bobble.func_70296_d();
        }
    }

    protected void placeFoundationUnderneath(World world, Block placeBlock, int meta, int minX, int minZ, int maxX, int maxZ, int featureY, StructureBoundingBox box) {
        for (int featureX = minX; featureX <= maxX; ++featureX) {
            for (int featureZ = minZ; featureZ <= maxZ; ++featureZ) {
                int posZ;
                int posY;
                int posX = this.func_74865_a(featureX, featureZ);
                if (!box.func_78890_b(posX, posY = this.func_74862_a(featureY), posZ = this.func_74873_b(featureX, featureZ))) continue;
                Block block = world.func_147439_a(posX, posY, posZ);
                for (int brake = 0; (world.func_147437_c(posX, posY, posZ) || !block.func_149688_o().func_76220_a() || block.isFoliage((IBlockAccess)world, posX, posY, posZ) || block.func_149688_o() == Material.field_151584_j) && posY > 1 && brake <= 15; ++brake) {
                    world.func_147465_d(posX, posY, posZ, placeBlock, meta, 2);
                    block = world.func_147439_a(posX, --posY, posZ);
                }
            }
        }
    }

    protected void placeBlocksOnTop(World world, StructureBoundingBox box, Block block, int minX, int minZ, int maxX, int maxZ, int height) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posZ;
                int topHeight;
                int posX = this.func_74865_a(x, z);
                if (world.func_147439_a(posX, topHeight = world.func_72825_h(posX, posZ = this.func_74873_b(x, z)), posZ).func_149688_o().func_76224_d()) continue;
                for (int i = 0; i < height; ++i) {
                    int posY = topHeight + i;
                    world.func_147465_d(posX, posY, posZ, block, 0, 2);
                }
            }
        }
    }

    public int func_74865_a(int x, int z) {
        switch (this.field_74885_f) {
            case 0: {
                return this.field_74887_e.field_78897_a + x;
            }
            case 1: {
                return this.field_74887_e.field_78893_d - z;
            }
            case 2: {
                return this.field_74887_e.field_78893_d - x;
            }
            case 3: {
                return this.field_74887_e.field_78897_a + z;
            }
        }
        return x;
    }

    public int func_74873_b(int x, int z) {
        switch (this.field_74885_f) {
            case 0: {
                return this.field_74887_e.field_78896_c + z;
            }
            case 1: {
                return this.field_74887_e.field_78896_c + x;
            }
            case 2: {
                return this.field_74887_e.field_78892_f - z;
            }
            case 3: {
                return this.field_74887_e.field_78892_f - x;
            }
        }
        return z;
    }

    protected void func_74878_a(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    world.func_147465_d(posX, posY, posZ, Blocks.field_150350_a, 0, 2);
                }
            }
        }
    }

    protected void func_151549_a(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block, Block replaceBlock, boolean onlyReplace) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    if (onlyReplace && world.func_147439_a(posX, posY, posZ).func_149688_o() == Material.field_151579_a) continue;
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) {
                        world.func_147465_d(posX, posY, posZ, replaceBlock, 0, 2);
                        continue;
                    }
                    world.func_147465_d(posX, posY, posZ, block, 0, 2);
                }
            }
        }
    }

    protected void fillWithBlocks(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    world.func_147465_d(posX, posY, posZ, block, 0, 2);
                }
            }
        }
    }

    protected void func_151556_a(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block, int meta, Block replaceBlock, int replaceMeta, boolean onlyReplace) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    if (onlyReplace && world.func_147439_a(posX, posY, posZ).func_149688_o() == Material.field_151579_a) continue;
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) {
                        world.func_147465_d(posX, posY, posZ, replaceBlock, replaceMeta, 2);
                        continue;
                    }
                    world.func_147465_d(posX, posY, posZ, block, meta, 2);
                }
            }
        }
    }

    protected void fillWithMetadataBlocks(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block, int meta) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    world.func_147465_d(posX, posY, posZ, block, meta, 2);
                }
            }
        }
    }

    protected void func_74882_a(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean onlyReplace, Random rand, StructureComponent.BlockSelector selector) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    if (onlyReplace && world.func_147439_a(posX, posY, posZ).func_149688_o() == Material.field_151579_a) continue;
                    selector.func_75062_a(rand, posX, posY, posZ, x == minX || x == maxX || y == minY || y == maxY || z == minZ || z == maxZ);
                    world.func_147465_d(posX, posY, posZ, selector.func_151561_a(), selector.func_75064_b(), 2);
                }
            }
        }
    }

    protected void fillWithRandomizedBlocks(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Random rand, StructureComponent.BlockSelector selector) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    selector.func_75062_a(rand, posX, posY, posZ, false);
                    world.func_147465_d(posX, posY, posZ, selector.func_151561_a(), selector.func_75064_b(), 2);
                }
            }
        }
    }

    protected void fillWithRandomizedBlocksMeta(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Random rand, StructureComponent.BlockSelector selector, int meta) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    selector.func_75062_a(rand, posX, posY, posZ, false);
                    world.func_147465_d(posX, posY, posZ, selector.func_151561_a(), meta | selector.func_75064_b(), 2);
                }
            }
        }
    }

    protected void func_151551_a(World world, StructureBoundingBox box, Random rand, float randLimit, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block, Block replaceBlock, boolean onlyReplace) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    if (!(rand.nextFloat() <= randLimit) || onlyReplace && world.func_147439_a(posX, posY, posZ).func_149688_o() == Material.field_151579_a) continue;
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) {
                        world.func_147465_d(posX, posY, posZ, replaceBlock, 0, 2);
                        continue;
                    }
                    world.func_147465_d(posX, posY, posZ, block, 0, 2);
                }
            }
        }
    }

    protected void randomlyFillWithBlocks(World world, StructureBoundingBox box, Random rand, float randLimit, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    if (!(rand.nextFloat() <= randLimit)) continue;
                    world.func_147465_d(posX, posY, posZ, block, 0, 2);
                }
            }
        }
    }

    protected void randomlyFillWithBlocks(World world, StructureBoundingBox box, Random rand, float randLimit, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block, int meta) {
        if (this.func_74862_a(minY) < box.field_78895_b || this.func_74862_a(maxY) > box.field_78894_e) {
            return;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int posX = this.func_74865_a(x, z);
                int posZ = this.func_74873_b(x, z);
                if (posX < box.field_78897_a || posX > box.field_78893_d || posZ < box.field_78896_c || posZ > box.field_78892_f) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int posY = this.func_74862_a(y);
                    if (!(rand.nextFloat() <= randLimit)) continue;
                    world.func_147465_d(posX, posY, posZ, block, meta, 2);
                }
            }
        }
    }

    protected ForgeDirection getDirection(ForgeDirection dir) {
        switch (this.field_74885_f) {
            default: {
                return dir;
            }
            case 1: {
                return dir.getRotation(ForgeDirection.UP);
            }
            case 2: {
                return dir.getOpposite();
            }
            case 3: 
        }
        return dir.getRotation(ForgeDirection.DOWN);
    }

    protected void placeCore(World world, StructureBoundingBox box, Block block, ForgeDirection dir, int x, int y, int z) {
        int posX = this.func_74865_a(x, z);
        int posZ = this.func_74873_b(x, z);
        int posY = this.func_74862_a(y);
        if (!box.func_78890_b(posX, posY, posZ)) {
            return;
        }
        if (dir == null) {
            dir = ForgeDirection.NORTH;
        }
        dir = this.getDirection(dir.getOpposite());
        world.func_147465_d(posX, posY, posZ, block, dir.ordinal() + 10, 2);
    }

    protected void fillSpace(World world, StructureBoundingBox box, int x, int y, int z, int[] dim, Block block, ForgeDirection dir) {
        if (this.func_74862_a(y - dim[1]) < box.field_78895_b || this.func_74862_a(y + dim[0]) > box.field_78894_e) {
            return;
        }
        if (dir == null) {
            dir = ForgeDirection.NORTH;
        }
        dir = this.getDirection(dir.getOpposite());
        int count = 0;
        int[] rot = MultiblockHandlerXR.rotate(dim, dir);
        int posX = this.func_74865_a(x, z);
        int posZ = this.func_74873_b(x, z);
        int posY = this.func_74862_a(y);
        BlockDummyable.safeRem = true;
        for (int a = posX - rot[4]; a <= posX + rot[5]; ++a) {
            for (int c = posZ - rot[2]; c <= posZ + rot[3]; ++c) {
                if (a < box.field_78897_a || a > box.field_78893_d || c < box.field_78896_c || c > box.field_78892_f) continue;
                for (int b = posY - rot[1]; b <= posY + rot[0]; ++b) {
                    int meta = 0;
                    if (b < posY) {
                        meta = ForgeDirection.DOWN.ordinal();
                    } else if (b > posY) {
                        meta = ForgeDirection.UP.ordinal();
                    } else if (a < posX) {
                        meta = ForgeDirection.WEST.ordinal();
                    } else if (a > posX) {
                        meta = ForgeDirection.EAST.ordinal();
                    } else if (c < posZ) {
                        meta = ForgeDirection.NORTH.ordinal();
                    } else {
                        if (c <= posZ) continue;
                        meta = ForgeDirection.SOUTH.ordinal();
                    }
                    world.func_147465_d(a, b, c, block, meta, 2);
                    if (++count <= 2000) continue;
                    System.out.println("component's fillspace: ded " + a + " " + b + " " + c + " " + x + " " + y + " " + z);
                    BlockDummyable.safeRem = false;
                    return;
                }
            }
        }
        BlockDummyable.safeRem = false;
    }

    public void makeExtra(World world, StructureBoundingBox box, Block block, int x, int y, int z) {
        int posX = this.func_74865_a(x, z);
        int posZ = this.func_74873_b(x, z);
        int posY = this.func_74862_a(y);
        if (!box.func_78890_b(posX, posY, posZ)) {
            return;
        }
        if (world.func_147439_a(posX, posY, posZ) != block) {
            return;
        }
        int meta = world.func_72805_g(posX, posY, posZ);
        if (meta > 5) {
            return;
        }
        BlockDummyable.safeRem = true;
        world.func_147465_d(posX, posY, posZ, block, meta + 6, 3);
        BlockDummyable.safeRem = false;
    }

    public static class GreenOoze
    extends StructureComponent.BlockSelector {
        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_151562_a = chance < 0.8f ? ModBlocks.toxic_block : ModBlocks.meteor_polished;
        }
    }

    public static class CrabSpawners
    extends StructureComponent.BlockSelector {
        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_151562_a = chance < 0.8f ? ModBlocks.meteor_brick : ModBlocks.meteor_spawner;
        }
    }

    public static class SupplyCrates
    extends StructureComponent.BlockSelector {
        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_151562_a = chance < 0.6f ? Blocks.field_150350_a : (chance < 0.8f ? ModBlocks.crate_ammo : (chance < 0.9f ? ModBlocks.crate_can : ModBlocks.crate));
        }
    }

    public static class MeteorBricks
    extends StructureComponent.BlockSelector {
        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_151562_a = chance < 0.4f ? ModBlocks.meteor_brick : (chance < 0.7f ? ModBlocks.meteor_brick_mossy : ModBlocks.meteor_brick_cracked);
        }
    }

    static class SuperConcrete
    extends StructureComponent.BlockSelector {
        SuperConcrete() {
            this.field_151562_a = ModBlocks.concrete_super;
        }

        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            this.field_75065_b = rand.nextInt(6) + 10;
        }
    }

    static class LabTiles
    extends StructureComponent.BlockSelector {
        LabTiles() {
        }

        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_151562_a = chance < 0.5f ? ModBlocks.tile_lab : (chance < 0.9f ? ModBlocks.tile_lab_cracked : ModBlocks.tile_lab_broken);
        }
    }

    static class ConcreteBricksSlabs
    extends StructureComponent.BlockSelector {
        ConcreteBricksSlabs() {
            this.field_151562_a = ModBlocks.concrete_brick_slab;
            this.field_75065_b = 0;
        }

        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_75065_b = chance >= 0.4f && chance < 0.7f ? (this.field_75065_b |= 1) : (chance < 0.9f ? (this.field_75065_b |= 2) : (this.field_75065_b |= 3));
        }
    }

    static class ConcreteBricksStairs
    extends StructureComponent.BlockSelector {
        ConcreteBricksStairs() {
            this.field_75065_b = 0;
        }

        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_151562_a = chance < 0.4f ? ModBlocks.brick_concrete_stairs : (chance < 0.7f ? ModBlocks.brick_concrete_mossy_stairs : (chance < 0.9f ? ModBlocks.brick_concrete_cracked_stairs : ModBlocks.brick_concrete_broken_stairs));
        }
    }

    static class ConcreteBricks
    extends StructureComponent.BlockSelector {
        ConcreteBricks() {
        }

        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_151562_a = chance < 0.4f ? ModBlocks.brick_concrete : (chance < 0.7f ? ModBlocks.brick_concrete_mossy : (chance < 0.9f ? ModBlocks.brick_concrete_cracked : ModBlocks.brick_concrete_broken));
        }
    }

    static class Sandstone
    extends StructureComponent.BlockSelector {
        Sandstone() {
        }

        public void func_75062_a(Random rand, int posX, int posY, int posZ, boolean notInterior) {
            float chance = rand.nextFloat();
            this.field_151562_a = chance > 0.6f ? Blocks.field_150322_A : (chance < 0.5f ? ModBlocks.reinforced_sand : Blocks.field_150354_m);
        }
    }
}

