/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/I18N.ts":
/*!*********************!*\
  !*** ./src/I18N.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModI18N = void 0;
exports.sleep = sleep;
const json_1 = __webpack_require__(/*! @streamparser/json */ "./node_modules/@streamparser/json/dist/cjs/index.js");
const TypeB_1 = __webpack_require__(/*! ./TypeB */ "./src/TypeB.ts");
const tsafe_1 = __webpack_require__(/*! tsafe */ "./node_modules/tsafe/index.js");
function sleep(ms = 0) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
class ModI18N {
    constructor() {
        this.modUtils = window.modUtils;
        this.modSC2DataManager = window.modSC2DataManager;
        this._ = window.modUtils.getLodash();
        this.logger = this.modUtils.getLogger();
        this.idbRef = this.modUtils.getIdbRef();
        this.idbKeyValRef = this.modUtils.getIdbKeyValRef();
    }
    checkItem(t) {
        let c = t
            && this._.isString(this._.get(t, 'f'))
            && this._.isString(this._.get(t, 't'))
            && this._.isNumber(this._.get(t, 'pos'));
        if (t.passageName) {
            c = c && this._.isString(t.passageName);
        }
        if (this._.has(t, 'pN')) {
            c = c && this._.isString(this._.get(t, 'pN'));
        }
        if (t.css || t.js) {
            c = c && this._.isString(t.fileName);
        }
        // console.log('checkItem', [c, [
        //     this._.isString(this._.get(t, 'f')),
        //     this._.isString(this._.get(t, 't')),
        //     this._.isNumber(this._.get(t, 'pos')),
        //     t.passageName ? this._.isString(t.passageName) : true,
        //     this._.has(t, 'pN') ? this._.isString(this._.get(t, 'pN')) : true,
        //     t.css || t.js ? this._.isString(t.fileName) : true,
        // ]]);
        return c;
    }
    checkAndProcessData(T) {
        if (T && T.typeB && T.typeB.TypeBOutputText && T.typeB.TypeBInputStoryScript) {
            const cacheTypeBOutputText = T.typeB.TypeBOutputText.map((T) => {
                if (!this.checkItem(T)) {
                    console.error('I18NMod checkAndProcessData TypeBOutputText (!this.checkItem(T))', T);
                }
                return Object.assign(T, {
                    from: T.f,
                    to: T.t,
                });
            });
            const cacheTypeBInputStoryScript = T.typeB.TypeBInputStoryScript.map((T) => {
                if (!this.checkItem(T)) {
                    console.error('I18NMod checkAndProcessData TypeBInputStoryScript (!this.checkItem(T))', T);
                }
                return Object.assign(T, {
                    from: T.f,
                    to: T.t,
                    passageName: T.pN,
                });
            });
            return [cacheTypeBOutputText, cacheTypeBInputStoryScript];
        }
        return undefined;
    }
    patchVersionString() {
        const selfZip = this.modSC2DataManager.getModLoader().getModZip('ModI18N');
        if (selfZip) {
            // console.log('[i18n] selfZip.modInfo', selfZip.modInfo);
            // console.log('[i18n] StartConfig', StartConfig);
            if (selfZip.modInfo && selfZip.modInfo.version) {
                // StartConfig.version = `${StartConfig.version}-(chs-${selfZip.modInfo.version})`;
                StartConfig.versionName = `${StartConfig.versionName}-(chs-${selfZip.modInfo.version})`;
            }
        }
    }
    async readZipStream() {
        this.logger.log('patching i18n mod...');
        const selfZip = this.modSC2DataManager.getModLoader().getModZip('ModI18N');
        if (!selfZip) {
            this.logger.log('ModI18N zip not found');
            return;
        }
        // 获取mod的hash用于版本校验
        const currentHash = selfZip.modZipReaderHash;
        const cachedData = await this.I18NGetFromIDB(currentHash);
        if (cachedData) {
            this.logger.log('Using cached i18n data');
            this.typeB = new TypeB_1.ModI18NTypeB(cachedData.resultB, cachedData.resultBInput);
        }
        else {
            await this.I18NCleanCache();
            // 缓存未命中,使用原始解析方法
            this.logger.log('Cache miss, parsing i18n data...');
            const { resultB, resultBInput } = await this.parseOriginalZip(selfZip);
            await this.I18NSaveToIDB({
                hash: currentHash.toString(),
                resultB,
                resultBInput
            });
            this.typeB = new TypeB_1.ModI18NTypeB(resultB, resultBInput);
        }
        this.logger.log('Starting replace...');
        await sleep(10);
        await this.startReplace();
        this.modSC2DataManager.getLanguageManager().mainLanguage = 'zh';
        this.logger.log('[i18n] cacheing image');
        for (const img of selfZip.modInfo.imgs) {
            // force load banner and other image , to avoid read error after release zip file
            await img.getter.forceCache();
        }
        // 释放zip
        selfZip.gcReleaseZip();
        this.typeB.destroy();
        this.typeB = undefined;
        this.logger.log('GC complete');
        this.logger.log('I18n patch complete');
        await sleep(10);
    }
    // 原始zip解析方法
    async parseOriginalZip(selfZip) {
        var _a;
        const parser = new json_1.JSONParser({
            stringBufferSize: 1024,
            keepStack: false,
            paths: ['$.typeB.TypeBOutputText.*', '$.typeB.TypeBInputStoryScript.*']
        });
        let resultB = [];
        let resultBInput = [];
        var maxusage = 0;
        parser.onValue = ({ value, key, parent, stack }) => {
            if (stack.length < 2)
                return;
            if (stack[2].key === 'TypeBOutputText') {
                if (this.checkItem(value)) {
                    resultB.push({
                        from: value.f,
                        to: value.t,
                        pos: value.pos,
                        fileName: value.fileName,
                        js: value.js,
                    });
                }
            }
            else if (stack[2].key === 'TypeBInputStoryScript') {
                if (this.checkItem(value)) {
                    (0, tsafe_1.assert)(!!value.pN, 'pN must exist if it is TypeBInputStoryScript.');
                    resultBInput.push({
                        from: value.f,
                        to: value.t,
                        pos: value.pos,
                        fileName: value.fileName,
                        passageName: value.pN,
                    });
                }
            }
            if (parent !== undefined) {
                //console.log(parent.length);
                //const used = process.memoryUsage().heapUsed / 1024 / 1024;
                //if (used > maxusage)
                //    maxusage = used;
                parent.length = 0;
            }
        };
        //internalStream 在ts注解里面不存在，但是实际上是有这个方法的
        const logger = this.logger;
        var previousPercent = 0;
        const stream = (_a = selfZip.zip.file("i18n.json")) === null || _a === void 0 ? void 0 : _a.internalStream("string");
        const promise = new Promise(function (resolve, reject) {
            stream
                .on('data', function (dataChunk, metadata) {
                var floorValue = Math.floor(metadata.percent);
                if (previousPercent !== floorValue) {
                    previousPercent = floorValue;
                    if ((previousPercent % 10) === 0) {
                        logger.log('[i18n] Loading...... ' + floorValue);
                    }
                }
                parser.write(dataChunk);
            })
                .on("error", function (err) {
                reject(err);
            })
                .on("end", function () {
                try {
                    resolve(0);
                }
                catch (e) {
                    reject(e);
                }
            })
                .resume();
        });
        await promise;
        return { resultB, resultBInput };
    }
    // IndexedDB操作方法
    async I18NGetFromIDB(hash) {
        const hashKey = hash.toString();
        const db = await this.idbRef.idb_openDB('i18n-cache', 1, {
            upgrade(db) {
                db.createObjectStore('translations', { keyPath: 'hash' });
            },
        });
        const cached = await db.get('translations', hashKey);
        db.close();
        return cached;
    }
    async I18NSaveToIDB(data) {
        const db = await this.idbRef.idb_openDB('i18n-cache', 1);
        await db.put('translations', data);
        db.close();
    }
    async I18NCleanCache() {
        const db = await this.idbRef.idb_openDB('i18n-cache', 1);
        await db.clear('translations');
        db.close();
    }
    async startReplace() {
        if (this.typeB === undefined)
            return;
        // start replace
        const sc2DataCache = this.modSC2DataManager.getSC2DataInfoAfterPatch();
        // console.log('i18nJson sc2DataCache', sc2DataCache);
        const sc2Data = sc2DataCache.cloneSC2DataInfo();
        // console.log('i18nJson sc2Data', sc2Data);
        this.logger.log('[i18n] replace style ... ');
        await sleep(10);
        for (const styleItem of sc2Data.styleFileItems.items) {
            const name = sc2Data.scriptFileItems.getNoPathNameFromString(styleItem.name);
            styleItem.content = this.typeB.replaceCss(styleItem.content, name);
        }
        this.logger.log('[i18n] replace script ... ');
        await sleep(10);
        for (const scriptItem of sc2Data.scriptFileItems.items) {
            const name = sc2Data.scriptFileItems.getNoPathNameFromString(scriptItem.name);
            scriptItem.content = this.typeB.replaceJs(scriptItem.content, name);
        }
        this.logger.log('[i18n] replace passage ... ');
        await sleep(10);
        for (const pd of sc2Data.passageDataItems.items) {
            pd.content = this.typeB.replaceInputStoryScript(pd.content, pd.name);
        }
        this.logger.log('[i18n] rebuilding ... ');
        await sleep(10);
        console.log('sc2DataCache', sc2DataCache);
        console.log('sc2Data', sc2Data);
        sc2Data.styleFileItems.fillMap();
        sc2Data.scriptFileItems.fillMap();
        sc2Data.passageDataItems.fillMap();
        this.modUtils.replaceFollowSC2DataInfo(sc2Data, sc2DataCache);
    }
    async readZipSelf() {
        var _a;
        this.logger.log('patching i18n mod ........');
        const selfZip = this.modSC2DataManager.getModLoader().getModZip('ModI18N');
        if (selfZip) {
            // load i18n.json from mod zip file
            const i18nJsonS = await ((_a = selfZip.zip.file('i18n.json')) === null || _a === void 0 ? void 0 : _a.async('string').catch((err) => {
                console.error(err);
                return undefined;
            }));
            if (i18nJsonS) {
                let i18nJson;
                try {
                    i18nJson = JSON.parse(i18nJsonS);
                }
                catch (e) {
                    console.error(e);
                }
                console.log('i18nJson', i18nJson);
                const cc = this.checkAndProcessData(i18nJson);
                if (!cc) {
                    console.error('I18NMod checkAndProcessData (!cc)');
                    return;
                }
                this.typeB = new TypeB_1.ModI18NTypeB(cc[0], cc[1]);
                await this.startReplace();
                this.modSC2DataManager.getLanguageManager().mainLanguage = 'zh';
            }
        }
        else {
            console.error('I18NMod cannot read zip self');
            this.logger.error('I18NMod cannot read zip self');
        }
    }
}
exports.ModI18N = ModI18N;


/***/ }),

/***/ "./src/TypeB.ts":
/*!**********************!*\
  !*** ./src/TypeB.ts ***!
  \**********************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModI18NTypeB = void 0;
// come from GPT-4
function ModI18NTypeB_normalizeSearchPattern(pattern) {
    return new RegExp(ModI18NTypeB_normalizeSearchString(pattern), 'g');
}
// come from GPT-4
function ModI18NTypeB_escapedPatternString(pattern) {
    return pattern.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}
// come from GPT-4
function ModI18NTypeB_normalizeSearchString(pattern) {
    // 转义正则表达式中的特殊字符
    const escapedPattern = pattern.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    const p = `[^a-zA-Z0-9_$\{\}\`\"\'\|]${escapedPattern}[^a-zA-Z0-9_$\{\}\`\"\'\|]`;
    // console.log('p:', [p]);
    return p;
}
// come from GPT-4
function ModI18NTypeB_ignoreSpaceString(pattern) {
    // 转义正则表达式中的特殊字符
    const escapedPattern = pattern.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    // 转换空格
    // return escapedPattern.replace(/\s+/g, '\\s*');
    // return escapedPattern.split('').map(c => c.trim() ? c + '\\s*' : '').join('');
    const cc = escapedPattern.split('');
    for (let i = 0; i < cc.length; i++) {
        const ct = cc[i].trim();
        if (ct === '') {
            cc[i] = '';
        }
        else if (ct !== '\\') {
            cc[i] = cc[i] + '\\s*';
        }
        else {
            cc[i] = cc[i];
        }
    }
    return ['\\s*', ...cc, '\\s*'].join('');
}
// GPT-4
function fuzzyMatchManual(strA, strB, startIndex = 0) {
    let j = startIndex;
    // 去除字符串B中的空白字符
    const b = strB.replace(/\s+/g, '');
    for (let i = 0; i < b.length; i++) {
        // 跳过字符串A中的空白字符
        while (j < strA.length && /\s/.test(strA[j])) {
            j++;
        }
        // 如果字符串A已经结束，但字符串B还没有，返回-1
        if (j >= strA.length)
            return -1;
        // 比较两个字符，如果不同，返回-1
        if (strA[j] !== b[i])
            return -1;
        j++;
    }
    return j;
}
class ModI18NTypeB_OutputTextMatcher {
    constructor(mt) {
        this.mt = mt;
        console.log('ModI18NTypeB_OutputTextMatcher constructor', [mt]);
        this.m = new Map(this.mt.map((v) => {
            return [ModI18NTypeB_normalizeSearchString(v.from.trim()), v];
        }));
        this.fastTest = new RegExp(Array.from(this.m.keys()).join("|"), 'g');
    }
    tryReplace(text) {
        if (!text.trim()) {
            return text;
        }
        // come from GPT-4
        if (this.fastTest.test(text)) {
            let matches = [];
            let match;
            while ((match = this.fastTest.exec(text)) !== null) {
                matches.push({ index: match.index, value: match[0] });
            }
            // 按照在 strA 中的起始位置排序
            matches.sort((a, b) => a.index - b.index);
            // 用于记录哪些索引已经被替换过，以避免重叠替换
            let replacedIndices = new Set();
            let s = text;
            for (const m of matches) {
                let overlap = false;
                for (let i = m.index; i < m.index + m.value.length; i++) {
                    if (replacedIndices.has(i)) {
                        overlap = true;
                        break;
                    }
                }
                if (!overlap) {
                    let before = s.substring(0, m.index);
                    let after = s.substring(m.index + m.value.length);
                    s = before + this.m.get(m.value).to + after;
                    for (let i = m.index; i < m.index + this.m.get(m.value).to.length; i++) {
                        replacedIndices.add(i);
                    }
                }
            }
        }
        return text;
    }
    destroy() {
        this.m.clear();
        this.mt = [];
    }
}
class ModI18NTypeB_PassageMatcher {
    constructor(mt) {
        this.mt = mt;
        console.log('ModI18NTypeB_PassageMatcher constructor', [mt]);
        this.passagebuffer = new Map();
        mt.forEach((v) => {
            // console.log('ModI18NTypeB_PassageMatcher constructor', [v.from], rs);
            if (this.passagebuffer.has(v.passageName)) {
                this.passagebuffer.get(v.passageName).push(v);
            }
            else {
                this.passagebuffer.set(v.passageName, [v]);
            }
        });
        for (const [k, v] of this.passagebuffer) {
            this.passagebuffer.set(k, v.sort((a, b) => {
                // big to small
                return b.pos - a.pos;
            }));
        }
    }
    getByPassage(passageName) {
        if (passageName) {
            const pp = this.passagebuffer.get(passageName);
            if (pp) {
                return pp;
            }
            // console.log('cannot find passage:', passageName);
        }
        return undefined;
    }
    replacePassageContent(passageName, passageContent) {
        return this.replacePassageContentWithHintIndex(passageName, passageContent);
    }
    replacePassageContentWithHint(passageName, passageContent) {
        const pp = this.getByPassage(passageName);
        if (pp) {
            let s = passageContent;
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent passageName:', passageName);
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent before:', [s]);
            for (const v of pp) {
                s = ModI18NTypeB_PassageMatcher.tryReplaceStringFuzzyWithHint(s, v, passageName);
            }
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent after:', [s]);
            return s;
        }
        return passageContent;
    }
    replacePassageContentWithHintIndex(passageName, passageContent) {
        const pp = this.getByPassage(passageName);
        if (pp) {
            let s = passageContent;
            let textArray = [];
            let laxtIndex = 0;
            pp.sort((a, b) => a.pos - b.pos);
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent passageName:', passageName);
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent before:', [pp, s]);
            // console.log(s);
            for (const v of pp) {
                let d = ModI18NTypeB_PassageMatcher.tryReplaceStringFuzzyWithHintIndexComp(textArray, s, v, passageName, laxtIndex);
                textArray = d[0];
                laxtIndex = d[1];
            }
            textArray.push(s.substring(laxtIndex));
            const r = textArray.join('');
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent after:', [textArray, r]);
            // console.log(r);
            return r;
        }
        return passageContent;
    }
    static strcmpOffset(src, target, offset = 0) {
        // 确保偏移量在合理范围内
        if (offset < 0 || offset >= src.length) {
            return -1;
        }
        // 使用循环进行字符比较
        for (let i = offset, j = 0; i < src.length && j < target.length; i++, j++) {
            if (src[i] < target[j])
                return -1;
            if (src[i] > target[j])
                return 1;
        }
        // 处理长度不同的情况
        if ((src.length - offset) < target.length)
            return -1;
        //这里说明全部匹配了，所以是相等
        //if ((src.length - offset) > target.length) return 1;
        return 0; // 如果两个字符串相等，返回 0
    }
    static isSubstringMatch(A, C, P) {
        // Check if P is within the bounds of A and if the substring from P can be at least as long as C
        if (P < 0 || P >= A.length || P + C.length > A.length) {
            return false;
        }
        // Compare each character one by one using charCodeAt
        for (let i = 0; i < C.length; i++) {
            if (A.charCodeAt(P + i) !== C.charCodeAt(i)) {
                return false;
            }
        }
        return true;
    }
    static tryReplaceStringFuzzyWithHintIndex(textArray, s, v, passageNameOrFileName, lastIndex) {
        // first , we try to match and replace with const string in +-2 , this is the fastest way
        if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos) == 0) {
            textArray.push(s.substring(lastIndex, v.pos), v.to);
            lastIndex = v.pos + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos - 1) == 0) {
            textArray.push(s.substring(lastIndex, v.pos - 1), v.to);
            lastIndex = v.pos - 1 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos - 2) == 0) {
            textArray.push(s.substring(lastIndex, v.pos - 2), v.to);
            lastIndex = v.pos - 2 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos + 1) == 0) {
            textArray.push(s.substring(lastIndex, v.pos + 1), v.to);
            lastIndex = v.pos + 1 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos + 2) == 0) {
            textArray.push(s.substring(lastIndex, v.pos + 2), v.to);
            lastIndex = v.pos + 2 + v.from.length;
        }
        else {
            // otherwise , we try to match and replace with fuzzy match in [-10~+30]
            try {
                let re = new RegExp(ModI18NTypeB_escapedPatternString(v.from), '');
                // re.lastIndex = v.pos;
                const startPos = Math.max(0, v.pos - 10);
                const endPos = Math.min(s.length, v.pos + v.from.length + 30);
                const mm = re.exec(s.substring(startPos, endPos));
                if (mm) {
                    const pStart = startPos + mm.index;
                    const pEnd = pStart + v.from.length;
                    textArray.push(s.substring(lastIndex, pStart), v.to);
                    lastIndex = pStart + v.from.length;
                }
                else {
                    console.error('tryReplaceStringFuzzyWithHintIndex cannot find: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
                }
                re = undefined;
            }
            catch (e) {
                console.error(e);
                console.error('tryReplaceStringFuzzyWithHintIndex cannot find with error: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
            }
        }
        return { 0: textArray, 1: lastIndex };
    }
    static tryReplaceStringFuzzyWithHintIndexComp(textArray, s, v, passageNameOrFileName, lastIndex) {
        // first , we try to match and replace with const string in +-2 , this is the fastest way
        if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos)) {
            textArray.push(s.substring(lastIndex, v.pos), v.to);
            lastIndex = v.pos + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos - 1)) {
            textArray.push(s.substring(lastIndex, v.pos - 1), v.to);
            lastIndex = v.pos - 1 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos - 2)) {
            textArray.push(s.substring(lastIndex, v.pos - 2), v.to);
            lastIndex = v.pos - 2 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos + 1)) {
            textArray.push(s.substring(lastIndex, v.pos + 1), v.to);
            lastIndex = v.pos + 1 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos + 2)) {
            textArray.push(s.substring(lastIndex, v.pos + 2), v.to);
            lastIndex = v.pos + 2 + v.from.length;
        }
        else {
            // otherwise , we try to match and replace with fuzzy match in [-10~+30]
            try {
                let re = new RegExp(ModI18NTypeB_escapedPatternString(v.from), '');
                // re.lastIndex = v.pos;
                const startPos = Math.max(0, v.pos - 10);
                const endPos = Math.min(s.length, v.pos + v.from.length + 30);
                const mm = re.exec(s.substring(startPos, endPos));
                if (mm) {
                    const pStart = startPos + mm.index;
                    const pEnd = pStart + v.from.length;
                    textArray.push(s.substring(lastIndex, pStart), v.to);
                    lastIndex = pStart + v.from.length;
                }
                else {
                    console.error('tryReplaceStringFuzzyWithHintIndexComp cannot find: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
                }
                re = undefined;
            }
            catch (e) {
                console.error(e);
                console.error('tryReplaceStringFuzzyWithHintIndexComp cannot find with error: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
            }
        }
        return { 0: textArray, 1: lastIndex };
    }
    static tryReplaceStringFuzzyWithHint(s, v, passageNameOrFileName) {
        // first , we try to match and replace with const string in +-2 , this is the fastest way
        if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos) == 0) {
            s = s.substring(0, v.pos) + v.to + s.substring(v.pos + v.from.length);
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos - 1) == 0) {
            s = s.substring(0, v.pos - 1) + v.to + s.substring(v.pos - 1 + v.from.length);
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos - 2) == 0) {
            s = s.substring(0, v.pos - 2) + v.to + s.substring(v.pos - 2 + v.from.length);
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos + 1) == 0) {
            s = s.substring(0, v.pos + 1) + v.to + s.substring(v.pos + 1 + v.from.length);
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos + 2) == 0) {
            s = s.substring(0, v.pos + 2) + v.to + s.substring(v.pos + 2 + v.from.length);
        }
        else {
            // otherwise , we try to match and replace with fuzzy match in [-10~+30]
            try {
                let re = new RegExp(ModI18NTypeB_escapedPatternString(v.from), '');
                // re.lastIndex = v.pos;
                const startPos = Math.max(0, v.pos - 10);
                const endPos = Math.min(s.length, v.pos + v.from.length + 30);
                const mm = re.exec(s.substring(startPos, endPos));
                if (mm) {
                    const pStart = startPos + mm.index;
                    const pEnd = pStart + v.from.length;
                    s = s.substring(0, pStart) + v.to + s.substring(pEnd);
                }
                else {
                    console.error('tryReplaceStringFuzzyWithHint cannot find: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
                }
                re = undefined;
            }
            catch (e) {
                console.error(e);
                console.error('tryReplaceStringFuzzyWithHint cannot find with error: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
            }
        }
        return s;
    }
    destroy() {
        this.passagebuffer.clear();
        this.mt = [];
    }
}
class ModI18NTypeB_JsCssMatcher {
    constructor(OutputText, InputStoryScript) {
        this.OutputText = OutputText;
        this.InputStoryScript = InputStoryScript;
        this.cssBuffer = new Map();
        this.jsBuffer = new Map();
        for (const v of OutputText) {
            if (v.fileName) {
                if (v.css) {
                    if (this.cssBuffer.has(v.fileName)) {
                        this.cssBuffer.get(v.fileName).push(v);
                    }
                    else {
                        this.cssBuffer.set(v.fileName, [v]);
                    }
                }
                if (v.js) {
                    if (this.jsBuffer.has(v.fileName)) {
                        this.jsBuffer.get(v.fileName).push(v);
                    }
                    else {
                        this.jsBuffer.set(v.fileName, [v]);
                    }
                }
            }
        }
        for (const v of InputStoryScript) {
            if (v.fileName) {
                if (v.css) {
                    if (this.cssBuffer.has(v.fileName)) {
                        this.cssBuffer.get(v.fileName).push(v);
                    }
                    else {
                        this.cssBuffer.set(v.fileName, [v]);
                    }
                }
                if (v.js) {
                    if (this.jsBuffer.has(v.fileName)) {
                        this.jsBuffer.get(v.fileName).push(v);
                    }
                    else {
                        this.jsBuffer.set(v.fileName, [v]);
                    }
                }
            }
        }
        for (const [k, v] of this.cssBuffer) {
            this.cssBuffer.set(k, v.sort((a, b) => {
                // big to small
                return b.pos - a.pos;
            }));
        }
        for (const [k, v] of this.jsBuffer) {
            this.jsBuffer.set(k, v.sort((a, b) => {
                // big to small
                return b.pos - a.pos;
            }));
        }
    }
    replaceJs(content, fileName) {
        const rep = this.jsBuffer.get(fileName);
        if (rep) {
            let s = content;
            for (const v of rep) {
                s = ModI18NTypeB_PassageMatcher.tryReplaceStringFuzzyWithHint(s, v, fileName);
            }
            return s;
        }
        return content;
    }
    replaceCss(content, fileName) {
        const rep = this.cssBuffer.get(fileName);
        if (rep) {
            let s = content;
            for (const v of rep) {
                s = ModI18NTypeB_PassageMatcher.tryReplaceStringFuzzyWithHint(s, v, fileName);
            }
            return s;
        }
        return content;
    }
    destroy() {
        this.cssBuffer.clear();
        this.jsBuffer.clear();
        this.OutputText = [];
        this.InputStoryScript = [];
    }
}
class ModI18NTypeB {
    constructor(OutputText, InputStoryScript) {
        this.OutputText = OutputText;
        this.InputStoryScript = InputStoryScript;
        this.outputTextMatchBuffer = new ModI18NTypeB_OutputTextMatcher(OutputText);
        this.inputStoryMatchBuffer = new ModI18NTypeB_PassageMatcher(InputStoryScript);
        this.jsCssMatcher = new ModI18NTypeB_JsCssMatcher(OutputText, InputStoryScript);
        // monky patch
        // console.log('TypeB constructor monky patch document.createTextNode');
        // this.oCreateTextNode = document.createTextNode;
        // document.createTextNode = (text: string) => {
        //     return this.oCreateTextNode.call(document, this.replaceOutputText(text));
        // };
    }
    replaceOutputText(text) {
        if (!text.trim()) {
            // empty string
            return text;
        }
        // console.log('replaceOutputText input text ==>>', [text], text);
        try {
            return this.outputTextMatchBuffer.tryReplace(text);
        }
        catch (e) {
            console.error(e);
            return text;
        }
    }
    replaceInputStoryScript(text, passageName) {
        if (!text.trim()) {
            // empty string
            return text;
        }
        if (passageName) {
            try {
                return this.inputStoryMatchBuffer.replacePassageContent(passageName, text);
            }
            catch (e) {
                console.error(e);
            }
        }
        return text;
    }
    replaceJs(text, fileName) {
        return this.jsCssMatcher.replaceJs(text, fileName);
    }
    replaceCss(text, fileName) {
        return this.jsCssMatcher.replaceCss(text, fileName);
    }
    destroy() {
        this.outputTextMatchBuffer.destroy();
        this.inputStoryMatchBuffer.destroy();
        this.jsCssMatcher.destroy();
        this.oCreateTextNode = undefined;
        this.OutputText = [];
        this.InputStoryScript = [];
    }
}
exports.ModI18NTypeB = ModI18NTypeB;


/***/ }),

/***/ "./node_modules/tsafe/Reflect.js":
/*!***************************************!*\
  !*** ./node_modules/tsafe/Reflect.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Reflect = Reflect;
/** Always return null but pretends it returns an object of type T */
function Reflect() {
    return null;
}
//# sourceMappingURL=Reflect.js.map

/***/ }),

/***/ "./node_modules/tsafe/assert.js":
/*!**************************************!*\
  !*** ./node_modules/tsafe/assert.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AssertionError = void 0;
exports.assert = assert;
exports.is = is;
var overwriteReadonlyProp_1 = __webpack_require__(/*! ./lab/overwriteReadonlyProp */ "./node_modules/tsafe/lab/overwriteReadonlyProp.js");
/** https://docs.tsafe.dev/assert#error-thrown */
var AssertionError = /** @class */ (function (_super) {
    __extends(AssertionError, _super);
    function AssertionError(msg) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, "Wrong assertion encountered" + (!msg ? "" : ": \"".concat(msg, "\""))) || this;
        _this.originalMessage = msg;
        Object.setPrototypeOf(_this, _newTarget.prototype);
        if (!_this.stack) {
            return _this;
        }
        try {
            (0, overwriteReadonlyProp_1.overwriteReadonlyProp)(_this, "stack", _this.stack
                .split("\n")
                .filter(function () {
                var _a = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    _a[_i] = arguments[_i];
                }
                var _b = __read(_a, 2), i = _b[1];
                return i !== 1 && i !== 2;
            })
                .join("\n"));
        }
        catch (_a) { }
        return _this;
    }
    return AssertionError;
}(Error));
exports.AssertionError = AssertionError;
var refOfIs = undefined;
/** https://docs.tsafe.dev/assert */
function assert(condition, msg) {
    if (arguments.length === 0) {
        condition = true;
    }
    if (refOfIs !== undefined) {
        refOfIs = undefined;
        return;
    }
    if (!condition) {
        throw new AssertionError(typeof msg === "function" ? msg() : msg);
    }
}
var errorMessage = "Wrong usage of the `is` function refer to https://docs.tsafe.dev/is";
/** https://docs.tsafe.dev/is */
function is(value) {
    var ref = {};
    if (refOfIs !== undefined) {
        refOfIs = undefined;
        throw new Error(errorMessage);
    }
    refOfIs = ref;
    Promise.resolve().then(function () {
        if (refOfIs === ref) {
            throw new Error(errorMessage);
        }
    });
    return null;
}
//# sourceMappingURL=assert.js.map

/***/ }),

/***/ "./node_modules/tsafe/capitalize.js":
/*!******************************************!*\
  !*** ./node_modules/tsafe/capitalize.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.capitalize = capitalize;
/** @see <https://docs.tsafe.dev/capitalize> */
function capitalize(str) {
    return (str.charAt(0).toUpperCase() + str.slice(1));
}
//# sourceMappingURL=capitalize.js.map

/***/ }),

/***/ "./node_modules/tsafe/exclude.js":
/*!***************************************!*\
  !*** ./node_modules/tsafe/exclude.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.exclude = exclude;
/**
 * https://docs.tsafe.dev/exclude
 *
 * Return a function to use as Array.prototype.filter argument
 * to exclude one or many primitive value element from the array.
 * Ex: ([ "a", "b", "c" ] as const).filter(exclude("a")) return ("b" | "c")[]
 * Ex: ([ "a", "b", "c", "d"] as const).filter(exclude(["a", "b"]) gives ("c" | "d")[]
 */
function exclude(target) {
    var test = target instanceof Object
        ? function (element) { return target.indexOf(element) < 0; }
        : function (element) { return element !== target; };
    return function (element) {
        return test(element);
    };
}
//# sourceMappingURL=exclude.js.map

/***/ }),

/***/ "./node_modules/tsafe/flip.js":
/*!************************************!*\
  !*** ./node_modules/tsafe/flip.js ***!
  \************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.flip = flip;
/**
 * Flip the value of a boolean without having to reference it twice
 * after running flip(x.y, "z") x.y.z !== x.y.z,
 * https://docs.tsafe.dev/flip
 */
function flip(object, prop) {
    if (object[prop] === undefined) {
        return;
    }
    return (object[prop] = !object[prop]);
}
//# sourceMappingURL=flip.js.map

/***/ }),

/***/ "./node_modules/tsafe/id.js":
/*!**********************************!*\
  !*** ./node_modules/tsafe/id.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.id = void 0;
/** https://docs.tsafe.dev/id  */
var id = function (x) { return x; };
exports.id = id;
//# sourceMappingURL=id.js.map

/***/ }),

/***/ "./node_modules/tsafe/index.js":
/*!*************************************!*\
  !*** ./node_modules/tsafe/index.js ***!
  \*************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./assert */ "./node_modules/tsafe/assert.js"), exports);
__exportStar(__webpack_require__(/*! ./exclude */ "./node_modules/tsafe/exclude.js"), exports);
__exportStar(__webpack_require__(/*! ./flip */ "./node_modules/tsafe/flip.js"), exports);
__exportStar(__webpack_require__(/*! ./id */ "./node_modules/tsafe/id.js"), exports);
__exportStar(__webpack_require__(/*! ./isPromiseLike */ "./node_modules/tsafe/isPromiseLike.js"), exports);
__exportStar(__webpack_require__(/*! ./objectKeys */ "./node_modules/tsafe/objectKeys.js"), exports);
__exportStar(__webpack_require__(/*! ./typeGuard */ "./node_modules/tsafe/typeGuard.js"), exports);
__exportStar(__webpack_require__(/*! ./isAmong */ "./node_modules/tsafe/isAmong.js"), exports);
__exportStar(__webpack_require__(/*! ./objectEntries */ "./node_modules/tsafe/objectEntries.js"), exports);
__exportStar(__webpack_require__(/*! ./objectFromEntries */ "./node_modules/tsafe/objectFromEntries.js"), exports);
__exportStar(__webpack_require__(/*! ./noUndefined */ "./node_modules/tsafe/noUndefined.js"), exports);
__exportStar(__webpack_require__(/*! ./Reflect */ "./node_modules/tsafe/Reflect.js"), exports);
__exportStar(__webpack_require__(/*! ./capitalize */ "./node_modules/tsafe/capitalize.js"), exports);
__exportStar(__webpack_require__(/*! ./uncapitalize */ "./node_modules/tsafe/uncapitalize.js"), exports);
__exportStar(__webpack_require__(/*! ./symToStr */ "./node_modules/tsafe/symToStr.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/tsafe/isAmong.js":
/*!***************************************!*\
  !*** ./node_modules/tsafe/isAmong.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, exports) {


var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isAmong = isAmong;
/** https://docs.tsafe.dev/isamong */
function isAmong(names, value) {
    var e_1, _a;
    try {
        for (var names_1 = __values(names), names_1_1 = names_1.next(); !names_1_1.done; names_1_1 = names_1.next()) {
            var name_1 = names_1_1.value;
            if (name_1 === value) {
                return true;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (names_1_1 && !names_1_1.done && (_a = names_1.return)) _a.call(names_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return false;
}
//# sourceMappingURL=isAmong.js.map

/***/ }),

/***/ "./node_modules/tsafe/isPromiseLike.js":
/*!*********************************************!*\
  !*** ./node_modules/tsafe/isPromiseLike.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isPromiseLike = isPromiseLike;
function isPromiseLike(o) {
    return typeof o === "object" && o !== null && "then" in o && typeof o.then === "function";
}
//# sourceMappingURL=isPromiseLike.js.map

/***/ }),

/***/ "./node_modules/tsafe/lab/overwriteReadonlyProp.js":
/*!*********************************************************!*\
  !*** ./node_modules/tsafe/lab/overwriteReadonlyProp.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.overwriteReadonlyProp = void 0;
/**
 * Assign a value to a property even if the object is freezed or if the property is not writable
 * Throw if the assignation fail ( for example if the property is non configurable write: false )
 * */
var overwriteReadonlyProp = function (obj, propertyName, value) {
    try {
        obj[propertyName] = value;
    }
    catch (_a) { }
    if (obj[propertyName] === value) {
        return value;
    }
    var errorDefineProperty = undefined;
    var propertyDescriptor = Object.getOwnPropertyDescriptor(obj, propertyName) || {
        "enumerable": true,
        "configurable": true,
    };
    if (!!propertyDescriptor.get) {
        throw new Error("Probably a wrong ides to overwrite ".concat(String(propertyName), " getter"));
    }
    try {
        Object.defineProperty(obj, propertyName, __assign(__assign({}, propertyDescriptor), { value: value }));
    }
    catch (error) {
        errorDefineProperty = error;
    }
    if (obj[propertyName] !== value) {
        throw errorDefineProperty || new Error("Can't assign");
    }
    return value;
};
exports.overwriteReadonlyProp = overwriteReadonlyProp;
//# sourceMappingURL=overwriteReadonlyProp.js.map

/***/ }),

/***/ "./node_modules/tsafe/noUndefined.js":
/*!*******************************************!*\
  !*** ./node_modules/tsafe/noUndefined.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.noUndefined = noUndefined;
/**
 * Removes the enumerable properties whose values are
 * undefined.
 *
 * Example:
 * noUndefined({ "foo": undefined, "bar": 3 }) returns
 * a new object { "bar": 3 }
 */
function noUndefined(obj) {
    var out = {};
    for (var key in obj) {
        if (obj[key] === undefined) {
            continue;
        }
        out[key] = obj[key];
    }
    return out;
}
//# sourceMappingURL=noUndefined.js.map

/***/ }),

/***/ "./node_modules/tsafe/objectEntries.js":
/*!*********************************************!*\
  !*** ./node_modules/tsafe/objectEntries.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.objectEntries = objectEntries;
/** https://docs.tsafe.dev/objectentries */
function objectEntries(o) {
    return Object.entries(o);
}
//# sourceMappingURL=objectEntries.js.map

/***/ }),

/***/ "./node_modules/tsafe/objectFromEntries.js":
/*!*************************************************!*\
  !*** ./node_modules/tsafe/objectFromEntries.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.objectFromEntries = objectFromEntries;
/** https://docs.tsafe.dev/objectFromEntries */
function objectFromEntries(entries) {
    return Object.fromEntries(entries);
}
//# sourceMappingURL=objectFromEntries.js.map

/***/ }),

/***/ "./node_modules/tsafe/objectKeys.js":
/*!******************************************!*\
  !*** ./node_modules/tsafe/objectKeys.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.objectKeys = objectKeys;
/** https://docs.tsafe.dev/objectKeys */
function objectKeys(o) {
    return Object.keys(o);
}
//# sourceMappingURL=objectKeys.js.map

/***/ }),

/***/ "./node_modules/tsafe/symToStr.js":
/*!****************************************!*\
  !*** ./node_modules/tsafe/symToStr.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.symToStr = symToStr;
/** @see <https://docs.tsafe.dev/main/symtostr> */
function symToStr(wrap) {
    // @ts-expect-error: We know better
    return Object.keys(wrap)[0];
}
//# sourceMappingURL=symToStr.js.map

/***/ }),

/***/ "./node_modules/tsafe/typeGuard.js":
/*!*****************************************!*\
  !*** ./node_modules/tsafe/typeGuard.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.typeGuard = typeGuard;
/** https://docs.tsafe.dev/typeguard */
function typeGuard(value, isMatched) {
    return isMatched;
}
//# sourceMappingURL=typeGuard.js.map

/***/ }),

/***/ "./node_modules/tsafe/uncapitalize.js":
/*!********************************************!*\
  !*** ./node_modules/tsafe/uncapitalize.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.uncapitalize = uncapitalize;
/** @see <https://docs.tsafe.dev/capitalize#uncapitalize> */
function uncapitalize(str) {
    return (str.charAt(0).toLowerCase() + str.slice(1));
}
//# sourceMappingURL=uncapitalize.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/index.js":
/*!***********************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/index.js ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenType = exports.TokenParserMode = exports.ParsedElementInfo = exports.ParsedTokenInfo = exports.JsonTypes = exports.utf8 = exports.TokenParserError = exports.TokenParser = exports.TokenizerError = exports.Tokenizer = exports.JSONParser = void 0;
var jsonparser_js_1 = __webpack_require__(/*! ./jsonparser.js */ "./node_modules/@streamparser/json/dist/cjs/jsonparser.js");
Object.defineProperty(exports, "JSONParser", ({ enumerable: true, get: function () { return __importDefault(jsonparser_js_1).default; } }));
var tokenizer_js_1 = __webpack_require__(/*! ./tokenizer.js */ "./node_modules/@streamparser/json/dist/cjs/tokenizer.js");
Object.defineProperty(exports, "Tokenizer", ({ enumerable: true, get: function () { return __importDefault(tokenizer_js_1).default; } }));
Object.defineProperty(exports, "TokenizerError", ({ enumerable: true, get: function () { return tokenizer_js_1.TokenizerError; } }));
var tokenparser_js_1 = __webpack_require__(/*! ./tokenparser.js */ "./node_modules/@streamparser/json/dist/cjs/tokenparser.js");
Object.defineProperty(exports, "TokenParser", ({ enumerable: true, get: function () { return __importDefault(tokenparser_js_1).default; } }));
Object.defineProperty(exports, "TokenParserError", ({ enumerable: true, get: function () { return tokenparser_js_1.TokenParserError; } }));
exports.utf8 = __importStar(__webpack_require__(/*! ./utils/utf-8.js */ "./node_modules/@streamparser/json/dist/cjs/utils/utf-8.js"));
exports.JsonTypes = __importStar(__webpack_require__(/*! ./utils/types/jsonTypes.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/jsonTypes.js"));
exports.ParsedTokenInfo = __importStar(__webpack_require__(/*! ./utils/types/parsedTokenInfo.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/parsedTokenInfo.js"));
exports.ParsedElementInfo = __importStar(__webpack_require__(/*! ./utils/types/parsedElementInfo.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/parsedElementInfo.js"));
var stackElement_js_1 = __webpack_require__(/*! ./utils/types/stackElement.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/stackElement.js");
Object.defineProperty(exports, "TokenParserMode", ({ enumerable: true, get: function () { return stackElement_js_1.TokenParserMode; } }));
var tokenType_js_1 = __webpack_require__(/*! ./utils/types/tokenType.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js");
Object.defineProperty(exports, "TokenType", ({ enumerable: true, get: function () { return __importDefault(tokenType_js_1).default; } }));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/jsonparser.js":
/*!****************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/jsonparser.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tokenizer_js_1 = __importDefault(__webpack_require__(/*! ./tokenizer.js */ "./node_modules/@streamparser/json/dist/cjs/tokenizer.js"));
const tokenparser_js_1 = __importDefault(__webpack_require__(/*! ./tokenparser.js */ "./node_modules/@streamparser/json/dist/cjs/tokenparser.js"));
class JSONParser {
    constructor(opts = {}) {
        this.tokenizer = new tokenizer_js_1.default(opts);
        this.tokenParser = new tokenparser_js_1.default(opts);
        this.tokenizer.onToken = this.tokenParser.write.bind(this.tokenParser);
        this.tokenizer.onEnd = () => {
            if (!this.tokenParser.isEnded)
                this.tokenParser.end();
        };
        this.tokenParser.onError = this.tokenizer.error.bind(this.tokenizer);
        this.tokenParser.onEnd = () => {
            if (!this.tokenizer.isEnded)
                this.tokenizer.end();
        };
    }
    get isEnded() {
        return this.tokenizer.isEnded && this.tokenParser.isEnded;
    }
    write(input) {
        this.tokenizer.write(input);
    }
    end() {
        this.tokenizer.end();
    }
    set onToken(cb) {
        this.tokenizer.onToken = (parsedToken) => {
            cb(parsedToken);
            this.tokenParser.write(parsedToken);
        };
    }
    set onValue(cb) {
        this.tokenParser.onValue = cb;
    }
    set onError(cb) {
        this.tokenizer.onError = cb;
    }
    set onEnd(cb) {
        this.tokenParser.onEnd = () => {
            if (!this.tokenizer.isEnded)
                this.tokenizer.end();
            cb.call(this.tokenParser);
        };
    }
}
exports["default"] = JSONParser;
//# sourceMappingURL=jsonparser.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/tokenizer.js":
/*!***************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/tokenizer.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenizerError = void 0;
const utf_8_js_1 = __webpack_require__(/*! ./utils/utf-8.js */ "./node_modules/@streamparser/json/dist/cjs/utils/utf-8.js");
const bufferedString_js_1 = __webpack_require__(/*! ./utils/bufferedString.js */ "./node_modules/@streamparser/json/dist/cjs/utils/bufferedString.js");
const tokenType_js_1 = __importDefault(__webpack_require__(/*! ./utils/types/tokenType.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js"));
// Tokenizer States
var TokenizerStates;
(function (TokenizerStates) {
    TokenizerStates[TokenizerStates["START"] = 0] = "START";
    TokenizerStates[TokenizerStates["ENDED"] = 1] = "ENDED";
    TokenizerStates[TokenizerStates["ERROR"] = 2] = "ERROR";
    TokenizerStates[TokenizerStates["TRUE1"] = 3] = "TRUE1";
    TokenizerStates[TokenizerStates["TRUE2"] = 4] = "TRUE2";
    TokenizerStates[TokenizerStates["TRUE3"] = 5] = "TRUE3";
    TokenizerStates[TokenizerStates["FALSE1"] = 6] = "FALSE1";
    TokenizerStates[TokenizerStates["FALSE2"] = 7] = "FALSE2";
    TokenizerStates[TokenizerStates["FALSE3"] = 8] = "FALSE3";
    TokenizerStates[TokenizerStates["FALSE4"] = 9] = "FALSE4";
    TokenizerStates[TokenizerStates["NULL1"] = 10] = "NULL1";
    TokenizerStates[TokenizerStates["NULL2"] = 11] = "NULL2";
    TokenizerStates[TokenizerStates["NULL3"] = 12] = "NULL3";
    TokenizerStates[TokenizerStates["STRING_DEFAULT"] = 13] = "STRING_DEFAULT";
    TokenizerStates[TokenizerStates["STRING_AFTER_BACKSLASH"] = 14] = "STRING_AFTER_BACKSLASH";
    TokenizerStates[TokenizerStates["STRING_UNICODE_DIGIT_1"] = 15] = "STRING_UNICODE_DIGIT_1";
    TokenizerStates[TokenizerStates["STRING_UNICODE_DIGIT_2"] = 16] = "STRING_UNICODE_DIGIT_2";
    TokenizerStates[TokenizerStates["STRING_UNICODE_DIGIT_3"] = 17] = "STRING_UNICODE_DIGIT_3";
    TokenizerStates[TokenizerStates["STRING_UNICODE_DIGIT_4"] = 18] = "STRING_UNICODE_DIGIT_4";
    TokenizerStates[TokenizerStates["STRING_INCOMPLETE_CHAR"] = 19] = "STRING_INCOMPLETE_CHAR";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_INITIAL_MINUS"] = 20] = "NUMBER_AFTER_INITIAL_MINUS";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_INITIAL_ZERO"] = 21] = "NUMBER_AFTER_INITIAL_ZERO";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_INITIAL_NON_ZERO"] = 22] = "NUMBER_AFTER_INITIAL_NON_ZERO";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_FULL_STOP"] = 23] = "NUMBER_AFTER_FULL_STOP";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_DECIMAL"] = 24] = "NUMBER_AFTER_DECIMAL";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_E"] = 25] = "NUMBER_AFTER_E";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_E_AND_SIGN"] = 26] = "NUMBER_AFTER_E_AND_SIGN";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_E_AND_DIGIT"] = 27] = "NUMBER_AFTER_E_AND_DIGIT";
    TokenizerStates[TokenizerStates["SEPARATOR"] = 28] = "SEPARATOR";
})(TokenizerStates || (TokenizerStates = {}));
function TokenizerStateToString(tokenizerState) {
    return [
        "START",
        "ENDED",
        "ERROR",
        "TRUE1",
        "TRUE2",
        "TRUE3",
        "FALSE1",
        "FALSE2",
        "FALSE3",
        "FALSE4",
        "NULL1",
        "NULL2",
        "NULL3",
        "STRING_DEFAULT",
        "STRING_AFTER_BACKSLASH",
        "STRING_UNICODE_DIGIT_1",
        "STRING_UNICODE_DIGIT_2",
        "STRING_UNICODE_DIGIT_3",
        "STRING_UNICODE_DIGIT_4",
        "STRING_INCOMPLETE_CHAR",
        "NUMBER_AFTER_INITIAL_MINUS",
        "NUMBER_AFTER_INITIAL_ZERO",
        "NUMBER_AFTER_INITIAL_NON_ZERO",
        "NUMBER_AFTER_FULL_STOP",
        "NUMBER_AFTER_DECIMAL",
        "NUMBER_AFTER_E",
        "NUMBER_AFTER_E_AND_SIGN",
        "NUMBER_AFTER_E_AND_DIGIT",
        "SEPARATOR",
    ][tokenizerState];
}
const defaultOpts = {
    stringBufferSize: 0,
    numberBufferSize: 0,
    separator: undefined,
};
class TokenizerError extends Error {
    constructor(message) {
        super(message);
        // Typescript is broken. This is a workaround
        Object.setPrototypeOf(this, TokenizerError.prototype);
    }
}
exports.TokenizerError = TokenizerError;
class Tokenizer {
    constructor(opts) {
        this.state = 0 /* TokenizerStates.START */;
        this.separatorIndex = 0;
        this.bytes_remaining = 0; // number of bytes remaining in multi byte utf8 char to read after split boundary
        this.bytes_in_sequence = 0; // bytes in multi byte utf8 char to read
        this.char_split_buffer = new Uint8Array(4); // for rebuilding chars split before boundary is reached
        this.encoder = new TextEncoder();
        this.offset = -1;
        opts = Object.assign(Object.assign({}, defaultOpts), opts);
        this.bufferedString =
            opts.stringBufferSize && opts.stringBufferSize > 4
                ? new bufferedString_js_1.BufferedString(opts.stringBufferSize)
                : new bufferedString_js_1.NonBufferedString();
        this.bufferedNumber =
            opts.numberBufferSize && opts.numberBufferSize > 0
                ? new bufferedString_js_1.BufferedString(opts.numberBufferSize)
                : new bufferedString_js_1.NonBufferedString();
        this.separator = opts.separator;
        this.separatorBytes = opts.separator
            ? this.encoder.encode(opts.separator)
            : undefined;
    }
    get isEnded() {
        return this.state === 1 /* TokenizerStates.ENDED */;
    }
    write(input) {
        try {
            let buffer;
            if (input instanceof Uint8Array) {
                buffer = input;
            }
            else if (typeof input === "string") {
                buffer = this.encoder.encode(input);
            }
            else if ((typeof input === "object" && "buffer" in input) ||
                Array.isArray(input)) {
                buffer = Uint8Array.from(input);
            }
            else {
                throw new TypeError("Unexpected type. The `write` function only accepts Arrays, TypedArrays and Strings.");
            }
            for (let i = 0; i < buffer.length; i += 1) {
                const n = buffer[i]; // get current byte from buffer
                switch (this.state) {
                    case 0 /* TokenizerStates.START */:
                        this.offset += 1;
                        if (this.separatorBytes && n === this.separatorBytes[0]) {
                            if (this.separatorBytes.length === 1) {
                                this.state = 0 /* TokenizerStates.START */;
                                this.onToken({
                                    token: tokenType_js_1.default.SEPARATOR,
                                    value: this.separator,
                                    offset: this.offset + this.separatorBytes.length - 1,
                                });
                                continue;
                            }
                            this.state = 28 /* TokenizerStates.SEPARATOR */;
                            continue;
                        }
                        if (n === 32 /* charset.SPACE */ ||
                            n === 10 /* charset.NEWLINE */ ||
                            n === 13 /* charset.CARRIAGE_RETURN */ ||
                            n === 9 /* charset.TAB */) {
                            // whitespace
                            continue;
                        }
                        if (n === 123 /* charset.LEFT_CURLY_BRACKET */) {
                            this.onToken({
                                token: tokenType_js_1.default.LEFT_BRACE,
                                value: "{",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 125 /* charset.RIGHT_CURLY_BRACKET */) {
                            this.onToken({
                                token: tokenType_js_1.default.RIGHT_BRACE,
                                value: "}",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 91 /* charset.LEFT_SQUARE_BRACKET */) {
                            this.onToken({
                                token: tokenType_js_1.default.LEFT_BRACKET,
                                value: "[",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 93 /* charset.RIGHT_SQUARE_BRACKET */) {
                            this.onToken({
                                token: tokenType_js_1.default.RIGHT_BRACKET,
                                value: "]",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 58 /* charset.COLON */) {
                            this.onToken({
                                token: tokenType_js_1.default.COLON,
                                value: ":",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 44 /* charset.COMMA */) {
                            this.onToken({
                                token: tokenType_js_1.default.COMMA,
                                value: ",",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 116 /* charset.LATIN_SMALL_LETTER_T */) {
                            this.state = 3 /* TokenizerStates.TRUE1 */;
                            continue;
                        }
                        if (n === 102 /* charset.LATIN_SMALL_LETTER_F */) {
                            this.state = 6 /* TokenizerStates.FALSE1 */;
                            continue;
                        }
                        if (n === 110 /* charset.LATIN_SMALL_LETTER_N */) {
                            this.state = 10 /* TokenizerStates.NULL1 */;
                            continue;
                        }
                        if (n === 34 /* charset.QUOTATION_MARK */) {
                            this.bufferedString.reset();
                            this.state = 13 /* TokenizerStates.STRING_DEFAULT */;
                            continue;
                        }
                        if (n >= 49 /* charset.DIGIT_ONE */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.reset();
                            this.bufferedNumber.appendChar(n);
                            this.state = 22 /* TokenizerStates.NUMBER_AFTER_INITIAL_NON_ZERO */;
                            continue;
                        }
                        if (n === 48 /* charset.DIGIT_ZERO */) {
                            this.bufferedNumber.reset();
                            this.bufferedNumber.appendChar(n);
                            this.state = 21 /* TokenizerStates.NUMBER_AFTER_INITIAL_ZERO */;
                            continue;
                        }
                        if (n === 45 /* charset.HYPHEN_MINUS */) {
                            this.bufferedNumber.reset();
                            this.bufferedNumber.appendChar(n);
                            this.state = 20 /* TokenizerStates.NUMBER_AFTER_INITIAL_MINUS */;
                            continue;
                        }
                        break;
                    // STRING
                    case 13 /* TokenizerStates.STRING_DEFAULT */:
                        if (n === 34 /* charset.QUOTATION_MARK */) {
                            const string = this.bufferedString.toString();
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.STRING,
                                value: string,
                                offset: this.offset,
                            });
                            this.offset += this.bufferedString.byteLength + 1;
                            continue;
                        }
                        if (n === 92 /* charset.REVERSE_SOLIDUS */) {
                            this.state = 14 /* TokenizerStates.STRING_AFTER_BACKSLASH */;
                            continue;
                        }
                        if (n >= 128) {
                            // Parse multi byte (>=128) chars one at a time
                            if (n >= 194 && n <= 223) {
                                this.bytes_in_sequence = 2;
                            }
                            else if (n <= 239) {
                                this.bytes_in_sequence = 3;
                            }
                            else {
                                this.bytes_in_sequence = 4;
                            }
                            if (this.bytes_in_sequence <= buffer.length - i) {
                                // if bytes needed to complete char fall outside buffer length, we have a boundary split
                                this.bufferedString.appendBuf(buffer, i, i + this.bytes_in_sequence);
                                i += this.bytes_in_sequence - 1;
                                continue;
                            }
                            this.bytes_remaining = i + this.bytes_in_sequence - buffer.length;
                            this.char_split_buffer.set(buffer.subarray(i));
                            i = buffer.length - 1;
                            this.state = 19 /* TokenizerStates.STRING_INCOMPLETE_CHAR */;
                            continue;
                        }
                        if (n >= 32 /* charset.SPACE */) {
                            this.bufferedString.appendChar(n);
                            continue;
                        }
                        break;
                    case 19 /* TokenizerStates.STRING_INCOMPLETE_CHAR */:
                        // check for carry over of a multi byte char split between data chunks
                        // & fill temp buffer it with start of this data chunk up to the boundary limit set in the last iteration
                        this.char_split_buffer.set(buffer.subarray(i, i + this.bytes_remaining), this.bytes_in_sequence - this.bytes_remaining);
                        this.bufferedString.appendBuf(this.char_split_buffer, 0, this.bytes_in_sequence);
                        i = this.bytes_remaining - 1;
                        this.state = 13 /* TokenizerStates.STRING_DEFAULT */;
                        continue;
                    case 14 /* TokenizerStates.STRING_AFTER_BACKSLASH */:
                        const controlChar = utf_8_js_1.escapedSequences[n];
                        if (controlChar) {
                            this.bufferedString.appendChar(controlChar);
                            this.state = 13 /* TokenizerStates.STRING_DEFAULT */;
                            continue;
                        }
                        if (n === 117 /* charset.LATIN_SMALL_LETTER_U */) {
                            this.unicode = "";
                            this.state = 15 /* TokenizerStates.STRING_UNICODE_DIGIT_1 */;
                            continue;
                        }
                        break;
                    case 15 /* TokenizerStates.STRING_UNICODE_DIGIT_1 */:
                    case 16 /* TokenizerStates.STRING_UNICODE_DIGIT_2 */:
                    case 17 /* TokenizerStates.STRING_UNICODE_DIGIT_3 */:
                        if ((n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) ||
                            (n >= 65 /* charset.LATIN_CAPITAL_LETTER_A */ &&
                                n <= 70 /* charset.LATIN_CAPITAL_LETTER_F */) ||
                            (n >= 97 /* charset.LATIN_SMALL_LETTER_A */ &&
                                n <= 102 /* charset.LATIN_SMALL_LETTER_F */)) {
                            this.unicode += String.fromCharCode(n);
                            this.state += 1;
                            continue;
                        }
                        break;
                    case 18 /* TokenizerStates.STRING_UNICODE_DIGIT_4 */:
                        if ((n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) ||
                            (n >= 65 /* charset.LATIN_CAPITAL_LETTER_A */ &&
                                n <= 70 /* charset.LATIN_CAPITAL_LETTER_F */) ||
                            (n >= 97 /* charset.LATIN_SMALL_LETTER_A */ &&
                                n <= 102 /* charset.LATIN_SMALL_LETTER_F */)) {
                            const intVal = parseInt(this.unicode + String.fromCharCode(n), 16);
                            if (this.highSurrogate === undefined) {
                                if (intVal >= 0xd800 && intVal <= 0xdbff) {
                                    //<55296,56319> - highSurrogate
                                    this.highSurrogate = intVal;
                                }
                                else {
                                    this.bufferedString.appendBuf(this.encoder.encode(String.fromCharCode(intVal)));
                                }
                            }
                            else {
                                if (intVal >= 0xdc00 && intVal <= 0xdfff) {
                                    //<56320,57343> - lowSurrogate
                                    this.bufferedString.appendBuf(this.encoder.encode(String.fromCharCode(this.highSurrogate, intVal)));
                                }
                                else {
                                    this.bufferedString.appendBuf(this.encoder.encode(String.fromCharCode(this.highSurrogate)));
                                }
                                this.highSurrogate = undefined;
                            }
                            this.state = 13 /* TokenizerStates.STRING_DEFAULT */;
                            continue;
                        }
                        break;
                    // Number
                    case 20 /* TokenizerStates.NUMBER_AFTER_INITIAL_MINUS */:
                        if (n === 48 /* charset.DIGIT_ZERO */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 21 /* TokenizerStates.NUMBER_AFTER_INITIAL_ZERO */;
                            continue;
                        }
                        if (n >= 49 /* charset.DIGIT_ONE */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 22 /* TokenizerStates.NUMBER_AFTER_INITIAL_NON_ZERO */;
                            continue;
                        }
                        break;
                    case 21 /* TokenizerStates.NUMBER_AFTER_INITIAL_ZERO */:
                        if (n === 46 /* charset.FULL_STOP */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 23 /* TokenizerStates.NUMBER_AFTER_FULL_STOP */;
                            continue;
                        }
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */ ||
                            n === 69 /* charset.LATIN_CAPITAL_LETTER_E */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 25 /* TokenizerStates.NUMBER_AFTER_E */;
                            continue;
                        }
                        i -= 1;
                        this.state = 0 /* TokenizerStates.START */;
                        this.emitNumber();
                        continue;
                    case 22 /* TokenizerStates.NUMBER_AFTER_INITIAL_NON_ZERO */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            continue;
                        }
                        if (n === 46 /* charset.FULL_STOP */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 23 /* TokenizerStates.NUMBER_AFTER_FULL_STOP */;
                            continue;
                        }
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */ ||
                            n === 69 /* charset.LATIN_CAPITAL_LETTER_E */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 25 /* TokenizerStates.NUMBER_AFTER_E */;
                            continue;
                        }
                        i -= 1;
                        this.state = 0 /* TokenizerStates.START */;
                        this.emitNumber();
                        continue;
                    case 23 /* TokenizerStates.NUMBER_AFTER_FULL_STOP */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 24 /* TokenizerStates.NUMBER_AFTER_DECIMAL */;
                            continue;
                        }
                        break;
                    case 24 /* TokenizerStates.NUMBER_AFTER_DECIMAL */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            continue;
                        }
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */ ||
                            n === 69 /* charset.LATIN_CAPITAL_LETTER_E */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 25 /* TokenizerStates.NUMBER_AFTER_E */;
                            continue;
                        }
                        i -= 1;
                        this.state = 0 /* TokenizerStates.START */;
                        this.emitNumber();
                        continue;
                    // @ts-ignore fall through case
                    case 25 /* TokenizerStates.NUMBER_AFTER_E */:
                        if (n === 43 /* charset.PLUS_SIGN */ || n === 45 /* charset.HYPHEN_MINUS */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 26 /* TokenizerStates.NUMBER_AFTER_E_AND_SIGN */;
                            continue;
                        }
                    // Allow cascading
                    case 26 /* TokenizerStates.NUMBER_AFTER_E_AND_SIGN */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 27 /* TokenizerStates.NUMBER_AFTER_E_AND_DIGIT */;
                            continue;
                        }
                        break;
                    case 27 /* TokenizerStates.NUMBER_AFTER_E_AND_DIGIT */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            continue;
                        }
                        i -= 1;
                        this.state = 0 /* TokenizerStates.START */;
                        this.emitNumber();
                        continue;
                    // TRUE
                    case 3 /* TokenizerStates.TRUE1 */:
                        if (n === 114 /* charset.LATIN_SMALL_LETTER_R */) {
                            this.state = 4 /* TokenizerStates.TRUE2 */;
                            continue;
                        }
                        break;
                    case 4 /* TokenizerStates.TRUE2 */:
                        if (n === 117 /* charset.LATIN_SMALL_LETTER_U */) {
                            this.state = 5 /* TokenizerStates.TRUE3 */;
                            continue;
                        }
                        break;
                    case 5 /* TokenizerStates.TRUE3 */:
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */) {
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.TRUE,
                                value: true,
                                offset: this.offset,
                            });
                            this.offset += 3;
                            continue;
                        }
                        break;
                    // FALSE
                    case 6 /* TokenizerStates.FALSE1 */:
                        if (n === 97 /* charset.LATIN_SMALL_LETTER_A */) {
                            this.state = 7 /* TokenizerStates.FALSE2 */;
                            continue;
                        }
                        break;
                    case 7 /* TokenizerStates.FALSE2 */:
                        if (n === 108 /* charset.LATIN_SMALL_LETTER_L */) {
                            this.state = 8 /* TokenizerStates.FALSE3 */;
                            continue;
                        }
                        break;
                    case 8 /* TokenizerStates.FALSE3 */:
                        if (n === 115 /* charset.LATIN_SMALL_LETTER_S */) {
                            this.state = 9 /* TokenizerStates.FALSE4 */;
                            continue;
                        }
                        break;
                    case 9 /* TokenizerStates.FALSE4 */:
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */) {
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.FALSE,
                                value: false,
                                offset: this.offset,
                            });
                            this.offset += 4;
                            continue;
                        }
                        break;
                    // NULL
                    case 10 /* TokenizerStates.NULL1 */:
                        if (n === 117 /* charset.LATIN_SMALL_LETTER_U */) {
                            this.state = 11 /* TokenizerStates.NULL2 */;
                            continue;
                        }
                        break;
                    case 11 /* TokenizerStates.NULL2 */:
                        if (n === 108 /* charset.LATIN_SMALL_LETTER_L */) {
                            this.state = 12 /* TokenizerStates.NULL3 */;
                            continue;
                        }
                        break;
                    case 12 /* TokenizerStates.NULL3 */:
                        if (n === 108 /* charset.LATIN_SMALL_LETTER_L */) {
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.NULL,
                                value: null,
                                offset: this.offset,
                            });
                            this.offset += 3;
                            continue;
                        }
                        break;
                    case 28 /* TokenizerStates.SEPARATOR */:
                        this.separatorIndex += 1;
                        if (!this.separatorBytes ||
                            n !== this.separatorBytes[this.separatorIndex]) {
                            break;
                        }
                        if (this.separatorIndex === this.separatorBytes.length - 1) {
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.SEPARATOR,
                                value: this.separator,
                                offset: this.offset + this.separatorIndex,
                            });
                            this.separatorIndex = 0;
                        }
                        continue;
                    case 1 /* TokenizerStates.ENDED */:
                        if (n === 32 /* charset.SPACE */ ||
                            n === 10 /* charset.NEWLINE */ ||
                            n === 13 /* charset.CARRIAGE_RETURN */ ||
                            n === 9 /* charset.TAB */) {
                            // whitespace
                            continue;
                        }
                }
                throw new TokenizerError(`Unexpected "${String.fromCharCode(n)}" at position "${i}" in state ${TokenizerStateToString(this.state)}`);
            }
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
        }
        catch (err) {
            this.error(err);
        }
    }
    emitNumber() {
        this.onToken({
            token: tokenType_js_1.default.NUMBER,
            value: this.parseNumber(this.bufferedNumber.toString()),
            offset: this.offset,
        });
        this.offset += this.bufferedNumber.byteLength - 1;
    }
    parseNumber(numberStr) {
        return Number(numberStr);
    }
    error(err) {
        if (this.state !== 1 /* TokenizerStates.ENDED */) {
            this.state = 2 /* TokenizerStates.ERROR */;
        }
        this.onError(err);
    }
    end() {
        switch (this.state) {
            case 21 /* TokenizerStates.NUMBER_AFTER_INITIAL_ZERO */:
            case 22 /* TokenizerStates.NUMBER_AFTER_INITIAL_NON_ZERO */:
            case 24 /* TokenizerStates.NUMBER_AFTER_DECIMAL */:
            case 27 /* TokenizerStates.NUMBER_AFTER_E_AND_DIGIT */:
                this.state = 1 /* TokenizerStates.ENDED */;
                this.emitNumber();
                this.onEnd();
                break;
            case 0 /* TokenizerStates.START */:
            case 2 /* TokenizerStates.ERROR */:
            case 28 /* TokenizerStates.SEPARATOR */:
                this.state = 1 /* TokenizerStates.ENDED */;
                this.onEnd();
                break;
            default:
                this.error(new TokenizerError(`Tokenizer ended in the middle of a token (state: ${TokenizerStateToString(this.state)}). Either not all the data was received or the data was invalid.`));
        }
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onToken(parsedToken) {
        // Override me
        throw new TokenizerError('Can\'t emit tokens before the "onToken" callback has been set up.');
    }
    onError(err) {
        // Override me
        throw err;
    }
    onEnd() {
        // Override me
    }
}
exports["default"] = Tokenizer;
//# sourceMappingURL=tokenizer.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/tokenparser.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/tokenparser.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenParserError = void 0;
const tokenType_js_1 = __importDefault(__webpack_require__(/*! ./utils/types/tokenType.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js"));
// Parser States
var TokenParserState;
(function (TokenParserState) {
    TokenParserState[TokenParserState["VALUE"] = 0] = "VALUE";
    TokenParserState[TokenParserState["KEY"] = 1] = "KEY";
    TokenParserState[TokenParserState["COLON"] = 2] = "COLON";
    TokenParserState[TokenParserState["COMMA"] = 3] = "COMMA";
    TokenParserState[TokenParserState["ENDED"] = 4] = "ENDED";
    TokenParserState[TokenParserState["ERROR"] = 5] = "ERROR";
    TokenParserState[TokenParserState["SEPARATOR"] = 6] = "SEPARATOR";
})(TokenParserState || (TokenParserState = {}));
function TokenParserStateToString(state) {
    return ["VALUE", "KEY", "COLON", "COMMA", "ENDED", "ERROR", "SEPARATOR"][state];
}
const defaultOpts = {
    paths: undefined,
    keepStack: true,
    separator: undefined,
};
class TokenParserError extends Error {
    constructor(message) {
        super(message);
        // Typescript is broken. This is a workaround
        Object.setPrototypeOf(this, TokenParserError.prototype);
    }
}
exports.TokenParserError = TokenParserError;
class TokenParser {
    constructor(opts) {
        this.state = 0 /* TokenParserState.VALUE */;
        this.mode = undefined;
        this.key = undefined;
        this.value = undefined;
        this.stack = [];
        opts = Object.assign(Object.assign({}, defaultOpts), opts);
        if (opts.paths) {
            this.paths = opts.paths.map((path) => {
                if (path === undefined || path === "$*")
                    return undefined;
                if (!path.startsWith("$"))
                    throw new TokenParserError(`Invalid selector "${path}". Should start with "$".`);
                const pathParts = path.split(".").slice(1);
                if (pathParts.includes(""))
                    throw new TokenParserError(`Invalid selector "${path}". ".." syntax not supported.`);
                return pathParts;
            });
        }
        this.keepStack = opts.keepStack || false;
        this.separator = opts.separator;
    }
    shouldEmit() {
        if (!this.paths)
            return true;
        return this.paths.some((path) => {
            var _a;
            if (path === undefined)
                return true;
            if (path.length !== this.stack.length)
                return false;
            for (let i = 0; i < path.length - 1; i++) {
                const selector = path[i];
                const key = this.stack[i + 1].key;
                if (selector === "*")
                    continue;
                if (selector !== key)
                    return false;
            }
            const selector = path[path.length - 1];
            if (selector === "*")
                return true;
            return selector === ((_a = this.key) === null || _a === void 0 ? void 0 : _a.toString());
        });
    }
    push() {
        this.stack.push({
            key: this.key,
            value: this.value,
            mode: this.mode,
            emit: this.shouldEmit(),
        });
    }
    pop() {
        const value = this.value;
        let emit;
        ({
            key: this.key,
            value: this.value,
            mode: this.mode,
            emit,
        } = this.stack.pop());
        this.state =
            this.mode !== undefined ? 3 /* TokenParserState.COMMA */ : 0 /* TokenParserState.VALUE */;
        this.emit(value, emit);
    }
    emit(value, emit) {
        if (!this.keepStack &&
            this.value &&
            this.stack.every((item) => !item.emit)) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            delete this.value[this.key];
        }
        if (emit) {
            this.onValue({
                value: value,
                key: this.key,
                parent: this.value,
                stack: this.stack,
            });
        }
        if (this.stack.length === 0) {
            if (this.separator) {
                this.state = 6 /* TokenParserState.SEPARATOR */;
            }
            else if (this.separator === undefined) {
                this.end();
            }
            // else if separator === '', expect next JSON object.
        }
    }
    get isEnded() {
        return this.state === 4 /* TokenParserState.ENDED */;
    }
    write({ token, value }) {
        try {
            if (this.state === 0 /* TokenParserState.VALUE */) {
                if (token === tokenType_js_1.default.STRING ||
                    token === tokenType_js_1.default.NUMBER ||
                    token === tokenType_js_1.default.TRUE ||
                    token === tokenType_js_1.default.FALSE ||
                    token === tokenType_js_1.default.NULL) {
                    if (this.mode === 0 /* TokenParserMode.OBJECT */) {
                        this.value[this.key] = value;
                        this.state = 3 /* TokenParserState.COMMA */;
                    }
                    else if (this.mode === 1 /* TokenParserMode.ARRAY */) {
                        this.value.push(value);
                        this.state = 3 /* TokenParserState.COMMA */;
                    }
                    this.emit(value, this.shouldEmit());
                    return;
                }
                if (token === tokenType_js_1.default.LEFT_BRACE) {
                    this.push();
                    if (this.mode === 0 /* TokenParserMode.OBJECT */) {
                        this.value = this.value[this.key] = {};
                    }
                    else if (this.mode === 1 /* TokenParserMode.ARRAY */) {
                        const val = {};
                        this.value.push(val);
                        this.value = val;
                    }
                    else {
                        this.value = {};
                    }
                    this.mode = 0 /* TokenParserMode.OBJECT */;
                    this.state = 1 /* TokenParserState.KEY */;
                    this.key = undefined;
                    return;
                }
                if (token === tokenType_js_1.default.LEFT_BRACKET) {
                    this.push();
                    if (this.mode === 0 /* TokenParserMode.OBJECT */) {
                        this.value = this.value[this.key] = [];
                    }
                    else if (this.mode === 1 /* TokenParserMode.ARRAY */) {
                        const val = [];
                        this.value.push(val);
                        this.value = val;
                    }
                    else {
                        this.value = [];
                    }
                    this.mode = 1 /* TokenParserMode.ARRAY */;
                    this.state = 0 /* TokenParserState.VALUE */;
                    this.key = 0;
                    return;
                }
                if (this.mode === 1 /* TokenParserMode.ARRAY */ &&
                    token === tokenType_js_1.default.RIGHT_BRACKET &&
                    this.value.length === 0) {
                    this.pop();
                    return;
                }
            }
            if (this.state === 1 /* TokenParserState.KEY */) {
                if (token === tokenType_js_1.default.STRING) {
                    this.key = value;
                    this.state = 2 /* TokenParserState.COLON */;
                    return;
                }
                if (token === tokenType_js_1.default.RIGHT_BRACE &&
                    Object.keys(this.value).length === 0) {
                    this.pop();
                    return;
                }
            }
            if (this.state === 2 /* TokenParserState.COLON */) {
                if (token === tokenType_js_1.default.COLON) {
                    this.state = 0 /* TokenParserState.VALUE */;
                    return;
                }
            }
            if (this.state === 3 /* TokenParserState.COMMA */) {
                if (token === tokenType_js_1.default.COMMA) {
                    if (this.mode === 1 /* TokenParserMode.ARRAY */) {
                        this.state = 0 /* TokenParserState.VALUE */;
                        this.key += 1;
                        return;
                    }
                    /* istanbul ignore else */
                    if (this.mode === 0 /* TokenParserMode.OBJECT */) {
                        this.state = 1 /* TokenParserState.KEY */;
                        return;
                    }
                }
                if ((token === tokenType_js_1.default.RIGHT_BRACE &&
                    this.mode === 0 /* TokenParserMode.OBJECT */) ||
                    (token === tokenType_js_1.default.RIGHT_BRACKET &&
                        this.mode === 1 /* TokenParserMode.ARRAY */)) {
                    this.pop();
                    return;
                }
            }
            if (this.state === 6 /* TokenParserState.SEPARATOR */) {
                if (token === tokenType_js_1.default.SEPARATOR && value === this.separator) {
                    this.state = 0 /* TokenParserState.VALUE */;
                    return;
                }
            }
            throw new TokenParserError(`Unexpected ${tokenType_js_1.default[token]} (${JSON.stringify(value)}) in state ${TokenParserStateToString(this.state)}`);
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
        }
        catch (err) {
            this.error(err);
        }
    }
    error(err) {
        if (this.state !== 4 /* TokenParserState.ENDED */) {
            this.state = 5 /* TokenParserState.ERROR */;
        }
        this.onError(err);
    }
    end() {
        if ((this.state !== 0 /* TokenParserState.VALUE */ &&
            this.state !== 6 /* TokenParserState.SEPARATOR */) ||
            this.stack.length > 0) {
            this.error(new Error(`Parser ended in mid-parsing (state: ${TokenParserStateToString(this.state)}). Either not all the data was received or the data was invalid.`));
        }
        else {
            this.state = 4 /* TokenParserState.ENDED */;
            this.onEnd();
        }
    }
    /* eslint-disable-next-line @typescript-eslint/no-unused-vars */
    onValue(parsedElementInfo) {
        // Override me
        throw new TokenParserError('Can\'t emit data before the "onValue" callback has been set up.');
    }
    onError(err) {
        // Override me
        throw err;
    }
    onEnd() {
        // Override me
    }
}
exports["default"] = TokenParser;
//# sourceMappingURL=tokenparser.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/bufferedString.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/bufferedString.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BufferedString = exports.NonBufferedString = void 0;
class NonBufferedString {
    constructor() {
        this.decoder = new TextDecoder("utf-8");
        this.strings = [];
        this.byteLength = 0;
    }
    appendChar(char) {
        this.strings.push(String.fromCharCode(char));
        this.byteLength += 1;
    }
    appendBuf(buf, start = 0, end = buf.length) {
        this.strings.push(this.decoder.decode(buf.subarray(start, end)));
        this.byteLength += end - start;
    }
    reset() {
        this.strings = [];
        this.byteLength = 0;
    }
    toString() {
        return this.strings.join("");
    }
}
exports.NonBufferedString = NonBufferedString;
class BufferedString {
    constructor(bufferSize) {
        this.decoder = new TextDecoder("utf-8");
        this.bufferOffset = 0;
        this.string = "";
        this.byteLength = 0;
        this.buffer = new Uint8Array(bufferSize);
    }
    appendChar(char) {
        if (this.bufferOffset >= this.buffer.length)
            this.flushStringBuffer();
        this.buffer[this.bufferOffset++] = char;
        this.byteLength += 1;
    }
    appendBuf(buf, start = 0, end = buf.length) {
        const size = end - start;
        if (this.bufferOffset + size > this.buffer.length)
            this.flushStringBuffer();
        this.buffer.set(buf.subarray(start, end), this.bufferOffset);
        this.bufferOffset += size;
        this.byteLength += size;
    }
    flushStringBuffer() {
        this.string += this.decoder.decode(this.buffer.subarray(0, this.bufferOffset));
        this.bufferOffset = 0;
    }
    reset() {
        this.string = "";
        this.bufferOffset = 0;
        this.byteLength = 0;
    }
    toString() {
        this.flushStringBuffer();
        return this.string;
    }
}
exports.BufferedString = BufferedString;
//# sourceMappingURL=bufferedString.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/jsonTypes.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/jsonTypes.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=jsonTypes.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/parsedElementInfo.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/parsedElementInfo.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=parsedElementInfo.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/parsedTokenInfo.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/parsedTokenInfo.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=parsedTokenInfo.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/stackElement.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/stackElement.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenParserMode = void 0;
var TokenParserMode;
(function (TokenParserMode) {
    TokenParserMode[TokenParserMode["OBJECT"] = 0] = "OBJECT";
    TokenParserMode[TokenParserMode["ARRAY"] = 1] = "ARRAY";
})(TokenParserMode || (exports.TokenParserMode = TokenParserMode = {}));
//# sourceMappingURL=stackElement.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenTypeToString = void 0;
var TokenType;
(function (TokenType) {
    TokenType[TokenType["LEFT_BRACE"] = 0] = "LEFT_BRACE";
    TokenType[TokenType["RIGHT_BRACE"] = 1] = "RIGHT_BRACE";
    TokenType[TokenType["LEFT_BRACKET"] = 2] = "LEFT_BRACKET";
    TokenType[TokenType["RIGHT_BRACKET"] = 3] = "RIGHT_BRACKET";
    TokenType[TokenType["COLON"] = 4] = "COLON";
    TokenType[TokenType["COMMA"] = 5] = "COMMA";
    TokenType[TokenType["TRUE"] = 6] = "TRUE";
    TokenType[TokenType["FALSE"] = 7] = "FALSE";
    TokenType[TokenType["NULL"] = 8] = "NULL";
    TokenType[TokenType["STRING"] = 9] = "STRING";
    TokenType[TokenType["NUMBER"] = 10] = "NUMBER";
    TokenType[TokenType["SEPARATOR"] = 11] = "SEPARATOR";
})(TokenType || (TokenType = {}));
function TokenTypeToString(tokenType) {
    return [
        "LEFT_BRACE",
        "RIGHT_BRACE",
        "LEFT_BRACKET",
        "RIGHT_BRACKET",
        "COLON",
        "COMMA",
        "TRUE",
        "FALSE",
        "NULL",
        "STRING",
        "NUMBER",
        "SEPARATOR",
    ][tokenType];
}
exports.TokenTypeToString = TokenTypeToString;
exports["default"] = TokenType;
//# sourceMappingURL=tokenType.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/utf-8.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/utf-8.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.escapedSequences = exports.charset = void 0;
var charset;
(function (charset) {
    charset[charset["BACKSPACE"] = 8] = "BACKSPACE";
    charset[charset["FORM_FEED"] = 12] = "FORM_FEED";
    charset[charset["NEWLINE"] = 10] = "NEWLINE";
    charset[charset["CARRIAGE_RETURN"] = 13] = "CARRIAGE_RETURN";
    charset[charset["TAB"] = 9] = "TAB";
    charset[charset["SPACE"] = 32] = "SPACE";
    charset[charset["EXCLAMATION_MARK"] = 33] = "EXCLAMATION_MARK";
    charset[charset["QUOTATION_MARK"] = 34] = "QUOTATION_MARK";
    charset[charset["NUMBER_SIGN"] = 35] = "NUMBER_SIGN";
    charset[charset["DOLLAR_SIGN"] = 36] = "DOLLAR_SIGN";
    charset[charset["PERCENT_SIGN"] = 37] = "PERCENT_SIGN";
    charset[charset["AMPERSAND"] = 38] = "AMPERSAND";
    charset[charset["APOSTROPHE"] = 39] = "APOSTROPHE";
    charset[charset["LEFT_PARENTHESIS"] = 40] = "LEFT_PARENTHESIS";
    charset[charset["RIGHT_PARENTHESIS"] = 41] = "RIGHT_PARENTHESIS";
    charset[charset["ASTERISK"] = 42] = "ASTERISK";
    charset[charset["PLUS_SIGN"] = 43] = "PLUS_SIGN";
    charset[charset["COMMA"] = 44] = "COMMA";
    charset[charset["HYPHEN_MINUS"] = 45] = "HYPHEN_MINUS";
    charset[charset["FULL_STOP"] = 46] = "FULL_STOP";
    charset[charset["SOLIDUS"] = 47] = "SOLIDUS";
    charset[charset["DIGIT_ZERO"] = 48] = "DIGIT_ZERO";
    charset[charset["DIGIT_ONE"] = 49] = "DIGIT_ONE";
    charset[charset["DIGIT_TWO"] = 50] = "DIGIT_TWO";
    charset[charset["DIGIT_THREE"] = 51] = "DIGIT_THREE";
    charset[charset["DIGIT_FOUR"] = 52] = "DIGIT_FOUR";
    charset[charset["DIGIT_FIVE"] = 53] = "DIGIT_FIVE";
    charset[charset["DIGIT_SIX"] = 54] = "DIGIT_SIX";
    charset[charset["DIGIT_SEVEN"] = 55] = "DIGIT_SEVEN";
    charset[charset["DIGIT_EIGHT"] = 56] = "DIGIT_EIGHT";
    charset[charset["DIGIT_NINE"] = 57] = "DIGIT_NINE";
    charset[charset["COLON"] = 58] = "COLON";
    charset[charset["SEMICOLON"] = 59] = "SEMICOLON";
    charset[charset["LESS_THAN_SIGN"] = 60] = "LESS_THAN_SIGN";
    charset[charset["EQUALS_SIGN"] = 61] = "EQUALS_SIGN";
    charset[charset["GREATER_THAN_SIGN"] = 62] = "GREATER_THAN_SIGN";
    charset[charset["QUESTION_MARK"] = 63] = "QUESTION_MARK";
    charset[charset["COMMERCIAL_AT"] = 64] = "COMMERCIAL_AT";
    charset[charset["LATIN_CAPITAL_LETTER_A"] = 65] = "LATIN_CAPITAL_LETTER_A";
    charset[charset["LATIN_CAPITAL_LETTER_B"] = 66] = "LATIN_CAPITAL_LETTER_B";
    charset[charset["LATIN_CAPITAL_LETTER_C"] = 67] = "LATIN_CAPITAL_LETTER_C";
    charset[charset["LATIN_CAPITAL_LETTER_D"] = 68] = "LATIN_CAPITAL_LETTER_D";
    charset[charset["LATIN_CAPITAL_LETTER_E"] = 69] = "LATIN_CAPITAL_LETTER_E";
    charset[charset["LATIN_CAPITAL_LETTER_F"] = 70] = "LATIN_CAPITAL_LETTER_F";
    charset[charset["LATIN_CAPITAL_LETTER_G"] = 71] = "LATIN_CAPITAL_LETTER_G";
    charset[charset["LATIN_CAPITAL_LETTER_H"] = 72] = "LATIN_CAPITAL_LETTER_H";
    charset[charset["LATIN_CAPITAL_LETTER_I"] = 73] = "LATIN_CAPITAL_LETTER_I";
    charset[charset["LATIN_CAPITAL_LETTER_J"] = 74] = "LATIN_CAPITAL_LETTER_J";
    charset[charset["LATIN_CAPITAL_LETTER_K"] = 75] = "LATIN_CAPITAL_LETTER_K";
    charset[charset["LATIN_CAPITAL_LETTER_L"] = 76] = "LATIN_CAPITAL_LETTER_L";
    charset[charset["LATIN_CAPITAL_LETTER_M"] = 77] = "LATIN_CAPITAL_LETTER_M";
    charset[charset["LATIN_CAPITAL_LETTER_N"] = 78] = "LATIN_CAPITAL_LETTER_N";
    charset[charset["LATIN_CAPITAL_LETTER_O"] = 79] = "LATIN_CAPITAL_LETTER_O";
    charset[charset["LATIN_CAPITAL_LETTER_P"] = 80] = "LATIN_CAPITAL_LETTER_P";
    charset[charset["LATIN_CAPITAL_LETTER_Q"] = 81] = "LATIN_CAPITAL_LETTER_Q";
    charset[charset["LATIN_CAPITAL_LETTER_R"] = 82] = "LATIN_CAPITAL_LETTER_R";
    charset[charset["LATIN_CAPITAL_LETTER_S"] = 83] = "LATIN_CAPITAL_LETTER_S";
    charset[charset["LATIN_CAPITAL_LETTER_T"] = 84] = "LATIN_CAPITAL_LETTER_T";
    charset[charset["LATIN_CAPITAL_LETTER_U"] = 85] = "LATIN_CAPITAL_LETTER_U";
    charset[charset["LATIN_CAPITAL_LETTER_V"] = 86] = "LATIN_CAPITAL_LETTER_V";
    charset[charset["LATIN_CAPITAL_LETTER_W"] = 87] = "LATIN_CAPITAL_LETTER_W";
    charset[charset["LATIN_CAPITAL_LETTER_X"] = 88] = "LATIN_CAPITAL_LETTER_X";
    charset[charset["LATIN_CAPITAL_LETTER_Y"] = 89] = "LATIN_CAPITAL_LETTER_Y";
    charset[charset["LATIN_CAPITAL_LETTER_Z"] = 90] = "LATIN_CAPITAL_LETTER_Z";
    charset[charset["LEFT_SQUARE_BRACKET"] = 91] = "LEFT_SQUARE_BRACKET";
    charset[charset["REVERSE_SOLIDUS"] = 92] = "REVERSE_SOLIDUS";
    charset[charset["RIGHT_SQUARE_BRACKET"] = 93] = "RIGHT_SQUARE_BRACKET";
    charset[charset["CIRCUMFLEX_ACCENT"] = 94] = "CIRCUMFLEX_ACCENT";
    charset[charset["LOW_LINE"] = 95] = "LOW_LINE";
    charset[charset["GRAVE_ACCENT"] = 96] = "GRAVE_ACCENT";
    charset[charset["LATIN_SMALL_LETTER_A"] = 97] = "LATIN_SMALL_LETTER_A";
    charset[charset["LATIN_SMALL_LETTER_B"] = 98] = "LATIN_SMALL_LETTER_B";
    charset[charset["LATIN_SMALL_LETTER_C"] = 99] = "LATIN_SMALL_LETTER_C";
    charset[charset["LATIN_SMALL_LETTER_D"] = 100] = "LATIN_SMALL_LETTER_D";
    charset[charset["LATIN_SMALL_LETTER_E"] = 101] = "LATIN_SMALL_LETTER_E";
    charset[charset["LATIN_SMALL_LETTER_F"] = 102] = "LATIN_SMALL_LETTER_F";
    charset[charset["LATIN_SMALL_LETTER_G"] = 103] = "LATIN_SMALL_LETTER_G";
    charset[charset["LATIN_SMALL_LETTER_H"] = 104] = "LATIN_SMALL_LETTER_H";
    charset[charset["LATIN_SMALL_LETTER_I"] = 105] = "LATIN_SMALL_LETTER_I";
    charset[charset["LATIN_SMALL_LETTER_J"] = 106] = "LATIN_SMALL_LETTER_J";
    charset[charset["LATIN_SMALL_LETTER_K"] = 107] = "LATIN_SMALL_LETTER_K";
    charset[charset["LATIN_SMALL_LETTER_L"] = 108] = "LATIN_SMALL_LETTER_L";
    charset[charset["LATIN_SMALL_LETTER_M"] = 109] = "LATIN_SMALL_LETTER_M";
    charset[charset["LATIN_SMALL_LETTER_N"] = 110] = "LATIN_SMALL_LETTER_N";
    charset[charset["LATIN_SMALL_LETTER_O"] = 111] = "LATIN_SMALL_LETTER_O";
    charset[charset["LATIN_SMALL_LETTER_P"] = 112] = "LATIN_SMALL_LETTER_P";
    charset[charset["LATIN_SMALL_LETTER_Q"] = 113] = "LATIN_SMALL_LETTER_Q";
    charset[charset["LATIN_SMALL_LETTER_R"] = 114] = "LATIN_SMALL_LETTER_R";
    charset[charset["LATIN_SMALL_LETTER_S"] = 115] = "LATIN_SMALL_LETTER_S";
    charset[charset["LATIN_SMALL_LETTER_T"] = 116] = "LATIN_SMALL_LETTER_T";
    charset[charset["LATIN_SMALL_LETTER_U"] = 117] = "LATIN_SMALL_LETTER_U";
    charset[charset["LATIN_SMALL_LETTER_V"] = 118] = "LATIN_SMALL_LETTER_V";
    charset[charset["LATIN_SMALL_LETTER_W"] = 119] = "LATIN_SMALL_LETTER_W";
    charset[charset["LATIN_SMALL_LETTER_X"] = 120] = "LATIN_SMALL_LETTER_X";
    charset[charset["LATIN_SMALL_LETTER_Y"] = 121] = "LATIN_SMALL_LETTER_Y";
    charset[charset["LATIN_SMALL_LETTER_Z"] = 122] = "LATIN_SMALL_LETTER_Z";
    charset[charset["LEFT_CURLY_BRACKET"] = 123] = "LEFT_CURLY_BRACKET";
    charset[charset["VERTICAL_LINE"] = 124] = "VERTICAL_LINE";
    charset[charset["RIGHT_CURLY_BRACKET"] = 125] = "RIGHT_CURLY_BRACKET";
    charset[charset["TILDE"] = 126] = "TILDE";
})(charset || (exports.charset = charset = {}));
exports.escapedSequences = {
    [34 /* charset.QUOTATION_MARK */]: 34 /* charset.QUOTATION_MARK */,
    [92 /* charset.REVERSE_SOLIDUS */]: 92 /* charset.REVERSE_SOLIDUS */,
    [47 /* charset.SOLIDUS */]: 47 /* charset.SOLIDUS */,
    [98 /* charset.LATIN_SMALL_LETTER_B */]: 8 /* charset.BACKSPACE */,
    [102 /* charset.LATIN_SMALL_LETTER_F */]: 12 /* charset.FORM_FEED */,
    [110 /* charset.LATIN_SMALL_LETTER_N */]: 10 /* charset.NEWLINE */,
    [114 /* charset.LATIN_SMALL_LETTER_R */]: 13 /* charset.CARRIAGE_RETURN */,
    [116 /* charset.LATIN_SMALL_LETTER_T */]: 9 /* charset.TAB */,
};
//# sourceMappingURL=utf-8.js.map

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
var exports = __webpack_exports__;
/*!*********************!*\
  !*** ./src/init.ts ***!
  \*********************/

Object.defineProperty(exports, "__esModule", ({ value: true }));
const I18N_1 = __webpack_require__(/*! ./I18N */ "./src/I18N.ts");
window.modI18N = new I18N_1.ModI18N();

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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