﻿using RimWorld;
using System.Collections.Generic;
using Verse;
using Multiplayer.API;
using Verse.AI;

namespace rjw.RMB
{
	/// <summary>
	/// Generator of RMB categories for Biotech Mechanitor
	/// </summary>
	static class RMB_Mechanitor
	{
		public static void AddFloatMenuOptions(Pawn pawn, List<FloatMenuOption> opts, LocalTargetInfo target)
		{
			if (!ModsConfig.BiotechActive)
			{
				return;
			}

			FloatMenuOption opt = GenerateCategoryOption(pawn, target);
			if (opt != null)
				opts.Add(opt);
		}

		private static FloatMenuOption GenerateCategoryOption(Pawn pawn, LocalTargetInfo target)
		{
			if (MechanitorUtility.IsMechanitor(pawn))
			{
				if (target.Pawn?.IsVisiblyPregnant() == true)
				{
					Hediff_MechanoidPregnancy pregnancy = (Hediff_MechanoidPregnancy)target.Pawn.health.hediffSet.GetFirstHediffOfDef(HediffDef.Named("RJW_pregnancy_mech"));
					if (pregnancy != null)
					{
						if (pregnancy.is_checked && !pregnancy.is_hacked)
						{
							return FloatMenuUtility.DecoratePrioritizedTask(new FloatMenuOption("RJW_RMB_HackMechPregnancy".Translate(), delegate ()
							{
								HackMechPregnancy(pawn, target);
							}, MenuOptionPriority.High), pawn, target);
						}
					}
				}
			}
			//else if (pawn.IsColonyMechPlayerControlled)
			//{
				//mechimplant

				//			option = FloatMenuUtility.DecoratePrioritizedTask(new FloatMenuOption("RJW_RMB_Masturbate".Translate(), delegate ()
				//			{
				//				FloatMenuUtility.MakeMenu(GenerateSoloSexPoseOptions(pawn, target), (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
				//			}, MenuOptionPriority.High), pawn, target);
				//			opts.AddDistinct(option);
			//}
			return null;
		}

		[SyncMethod] // Not sure it is needed
		static void HackMechPregnancy(Pawn pawn, LocalTargetInfo target)
		{
			Job job = JobMaker.MakeJob(DefDatabase<JobDef>.GetNamed("RJW_HackMechPregnancy"), target.Pawn);
			pawn.jobs.TryTakeOrderedJob(job, JobTag.Misc);
		}
	}
}