using Verse;
using Verse.AI;

namespace rjw
{
	/// <summary>
	/// Attempts to give a mating job with a Bond to an eligible animal.
	/// </summary>
	public class JobGiver_MateBonded : ThinkNode_JobGiver
	{
		protected override Job TryGiveJob(Pawn animal)
		{
			if (!SexUtility.ReadyForLovin(animal))
				return null;

			if (xxx.is_healthy(animal) && CasualSex_Helper.CanHaveSex(animal))
			{
				//search for desiganted target to sex
				Pawn designated_target = CasualSex_Helper.Find_bond(animal, animal.Map);
				if (designated_target != null)
				{ 
					if (!xxx.is_satisfied(designated_target))
					return JobMaker.MakeJob(xxx.animalMate, designated_target);
				}
			}
			return null;
		}
	}
}