﻿using KTrie;
using rjw.Modules.Interactions.DefModExtensions;
using rjw.Modules.Interactions.Objects;
using rjw.Modules.Shared.Logs;
using System.Collections.Generic;
using System.Runtime.CompilerServices;
using System.Text;
using Verse;

namespace rjw.Modules.Interactions.Exposable
{
	public class HediffWithExtensionExposable : IExposable
	{
		private static ILog _log = LogManager.GetLogger<HediffWithExtensionExposable>();

		public Hediff hediff;

		public ISexPartHediff GenitalPart 
		{ 
			get 
			{
				return hediff as ISexPartHediff;
			} 
		}

		public void ExposeData()
		{
			Scribe_References.Look(ref hediff, nameof(hediff));
		}

		/// <summary>
		/// Dummy method to not break build pending removal of unused submodule
		/// </summary>
		/// <param name="self"></param>
		/// <returns></returns>
		public static ISexPartHediff Convert(HediffWithExtensionExposable self)
		{
			_log.Debug(self.ToString());

			return self.hediff as ISexPartHediff;
		}

		/// <summary>
		/// Dummy method to not break build pending removal of unused submodule
		/// </summary>
		/// <param name="self"></param>
		/// <returns></returns>
		public static HediffWithExtensionExposable Convert(ISexPartHediff self)
		{
			return new HediffWithExtensionExposable()
			{
				hediff = self.AsHediff
			};
		}

		public override string ToString()
		{
			StringBuilder stringBuilder = new StringBuilder();

			stringBuilder.AppendLine($"{nameof(hediff)} = {hediff?.def.defName}");

			return stringBuilder.ToString();
		}
	}
}
