﻿#nullable enable

using RimWorld;
using System.Collections.Generic;
using Verse;
using Verse.AI;
using Multiplayer.API;
using rjw.Modules.Interactions;

namespace rjw.RMB
{
	/// <summary>
	/// Entry point for the RJW right mouse button menu options.
	/// RimWorld uses reflection to find this class by its parent type.
	/// </summary>
	public class RMB_Menu : FloatMenuOptionProvider
	{
		protected override bool Drafted => false;
		protected override bool Undrafted => true;
		protected override bool Multiselect => false;

		public override IEnumerable<FloatMenuOption> GetOptions(FloatMenuContext context)
		{
			Pawn pawn = context.FirstSelectedPawn;
			AcceptanceReport canControlPawn = CanControlPawn(pawn);
			if (!canControlPawn)
			{
				if (RJWSettings.DevMode)
					yield return new FloatMenuOption($"No interactions: {canControlPawn.Reason}", null);

				yield break;
			}

			foreach (Thing target in context.cachedClickedThings)
			{
				if (target is Pawn targetPawn)
				{
					if (!targetPawn.Spawned)
					{
						if (RJWSettings.DevMode)
							yield return new FloatMenuOption($"No interactions for {targetPawn}: Pawn not spawned", null);
						continue;
					}
					if (targetPawn.Drafted)
					{
						if (RJWSettings.DevMode)
							yield return new FloatMenuOption($"No interactions for {targetPawn}: Pawn is drafted", null);
						continue;
					}
					if (targetPawn.IsHiddenFromPlayer())
					{
						if (RJWSettings.DevMode)
							yield return new FloatMenuOption($"No interactions for {targetPawn}: Pawn is hidden", null);
						continue;
					}
					if (!targetPawn.HasComp<CompRJW>())
					{
						if (RJWSettings.DevMode)
							yield return new FloatMenuOption($"No interactions for {targetPawn}: Doesn't have CompRJW", null);
						continue;
					}
				}

				if (!pawn.CanReach(target, PathEndMode.ClosestTouch, Danger.Deadly))
				{
					//option = new FloatMenuOption("CannotReach".Translate(target.Thing.LabelCap, target.Thing) + " (" + "NoPath".Translate() + ")", null);
					continue;
				}

				foreach (FloatMenuOption option in GetOptionsForTarget(pawn, target))
				{
					yield return option;
				}
			}
		}

		/// <summary>
		/// Check if <paramref name="pawn"/> can be controlled by the player
		/// </summary>
		/// <returns>
		/// AcceptanceReport. Reason is an untranslated string and should only be shown in the DevMode
		/// </returns>
		private static AcceptanceReport CanControlPawn(Pawn pawn)
		{
			// If the pawn in question cannot take jobs, don't bother.
			if (pawn.jobs == null)
				return "Cannot take jobs";

			// If the pawn is drafted - quit.
			if (pawn.Drafted)
				return "Drafted";

			// Getting raped - no control
			if (pawn.jobs.curDriver is JobDriver_SexBaseRecieverRaped)
				return "Getting raped";

			//is colonist?, is hospitality colonist/guest?, no control for guests
			if (!pawn.IsFreeColonist || pawn.Faction == null || pawn.GetExtraHomeFaction(null) != null)
				return "Not a colonist";

			//not hero mode or override_control - quit
			if (!(RJWSettings.RPG_hero_control || RJWSettings.override_control))
				return "Enable hero mode or direct control";

			if (!pawn.HasComp<CompRJW>())
				return "Doesn't have CompRJW";

			bool isHero = false;    //is hero
			bool otherPlayerHero = false;    //not owned hero? maybe prison check etc in future

			if (RJWSettings.RPG_hero_control)
			{
				isHero = pawn.IsDesignatedHero();
				otherPlayerHero = isHero && !pawn.IsHeroOwner();
			}
			else if (!RJWSettings.override_control)
				return "Not a hero, direct control disabled";

			//not hero, not override_control - quit
			if (!isHero && !RJWSettings.override_control)
				return "Not a hero";

			//not owned hero - quit
			if (isHero && otherPlayerHero)
				return "Not owned hero";

			if (pawn.IsPrisoner) // Removed slave restrictions - we can draft slaves, so why not control them directly?
				return "Prisoner";

			return true;
		}

		/// <summary>
		/// Create RJW floating menu options
		/// </summary>
		/// <param name="pawn">Selected pawn</param>
		/// <param name="target">Pawn or item player clicked on</param>
		private static IEnumerable<FloatMenuOption> GetOptionsForTarget(Pawn pawn, Thing target)
		{
			if (pawn == target)
			{
				foreach (FloatMenuOption opt in RMB_Masturbate.GetOptions(pawn))
					yield return opt;
			}
			else if (target is Pawn targetPawn)
			{
				foreach (FloatMenuOption opt in RMB_Mechanitor.GetOptions(pawn, targetPawn))
					yield return opt;

				if (xxx.is_human(targetPawn))
				{
					foreach (FloatMenuOption opt in RMB_Sex.GetOptions(pawn, targetPawn))
						yield return opt;
				}

				if (xxx.is_animal(targetPawn))
				{
					foreach (FloatMenuOption opt in RMB_Bestiality.GetOptions(pawn, targetPawn))
						yield return opt;;

					foreach (FloatMenuOption opt in RMB_RapeAnimal.GetOptions(pawn, targetPawn))
						yield return opt;
				}
				else
				{
					foreach (FloatMenuOption opt in RMB_Rape.GetOptions(pawn, targetPawn))
						yield return opt;
				}

				foreach (FloatMenuOption opt in RMB_Socialize.GetOptions(pawn, targetPawn))
					yield return opt;
			}
			else if (target is Corpse corpse)
			{
				foreach (FloatMenuOption opt in RMB_Necro.GetOptions(pawn, corpse))
					yield return opt;
			}
		}

		/// <summary>
		/// Generates sub-menu options for two pawns
		/// </summary>
		/// <param name="pawn">Initiator pawn</param>
		/// <param name="target">Reciever pawn or corpse</param>
		/// <param name="job"></param>
		/// <param name="rape"></param>
		/// <param name="reverse"></param>
		/// <returns>A list of menu options, where each item represents a possible interaction</returns>
		public static IEnumerable<FloatMenuOption> GenerateNonSoloSexRoleOptions(Pawn pawn, LocalTargetInfo target, JobDef job, bool rape, bool reverse = false)
		{
			bool foundInteraction = false;

			Pawn partner = target.Pawn;

			if (target.Thing is Corpse corpse)
			{
				partner = corpse.InnerPawn;
			}

			SexInteractionTag mainTag = SexInteractionTag.Consensual;
			if (xxx.is_animal(partner))
			{
				mainTag = SexInteractionTag.Bestiality;
			}
			else if (rape)
			{
				mainTag = SexInteractionTag.Rape;
			}

			foreach (InteractionDef d in SexUtility.SexInteractions)
			{
				var interaction = new SexInteraction(d);
				if (interaction.Sextype == xxx.rjwSextype.None)
					continue;
				if (interaction.Sextype == xxx.rjwSextype.Masturbation)
					continue;
				if (!interaction.HasInteractionTag(mainTag))
					continue;
				if (reverse != interaction.HasInteractionTag(SexInteractionTag.Reverse))
					continue;

				var props = new SexProps { pawn = pawn, partner = partner, interaction = interaction };
				var resolved = SexInteractionHelper.ResolveInteraction(props);
				if (resolved == null)
					continue;

				string label = interaction.Extension.RMBLabel.CapitalizeFirst();
				if (RJWSettings.DevMode)
					label += $" ( defName: {d.defName} )";

				FloatMenuOption option = new(label, delegate () { HaveSex(pawn, job, target, d, resolved); }, MenuOptionPriority.High);
				yield return FloatMenuUtility.DecoratePrioritizedTask(option, pawn, target);
			}

			if (RJWSettings.DevMode && !foundInteraction)
			{
				yield return new FloatMenuOption("No interactions found", null);
			}
		}

		//multiplayer synch actions

		/// <summary>
		/// Stops current job of the <paramref name="pawn"/> and starts new sex job
		/// </summary>
		/// <param name="pawn"></param>
		/// <param name="jobDef"></param>
		/// <param name="target">Reciever pawn or corpse</param>
		/// <param name="interactionDef">Sex interaction def</param>
		[SyncMethod]
		public static void HaveSex(Pawn pawn, JobDef jobDef, LocalTargetInfo target, InteractionDef interactionDef, SexInteractionResolved? resolved = null)
		{
			Pawn partner;
			if (target.Thing is Corpse corpse)
			{
				partner = corpse.InnerPawn;
			}
			else if (target.Pawn == null || pawn == target.Pawn) // masturbation
			{
				partner = pawn;
			}
			else
			{
				partner = target.Pawn;
			}

			SexInteraction interaction = new SexInteraction(interactionDef);

			bool rape = interaction.HasInteractionTag(SexInteractionTag.Rape);

			Job job;
			if (jobDef == xxx.casual_sex)
			{
				job = new Job(jobDef, target, partner.CurrentBed());
			}
			else if (jobDef == xxx.bestialityForFemale)
			{
				if (target.Pawn?.ownership.OwnedBed == null) //Check if Partner have bed
					job = new Job(jobDef, target, pawn.ownership.OwnedBed); //Go to Pawn bed if partner don't have bed assigned
				else job = new Job(jobDef, target, target.Pawn.ownership.OwnedBed); //If Partner have bed - go to partner
			}
			else if (jobDef == xxx.Masturbate)
			{
				job = new Job(jobDef, pawn, null, target.Cell);
			}
			else
			{
				job = new Job(jobDef, target);
			}

			var SP = new SexProps
			{
				pawn = pawn,
				partner = partner,
				isRape = rape,
				isRapist = rape,
				canBeGuilty = false, //pawn.IsHeroOwner();//TODO: fix for MP someday
				interaction = interaction
			};

			if (resolved != null)
			{
				SP.resolved = resolved;
			}

			pawn.GetRJWPawnData()!.SexProps = SP;
			pawn.jobs.EndCurrentJob(JobCondition.InterruptForced);
			pawn.jobs.TryTakeOrderedJob(job);
		}
	}
}