using RimWorld;
using System.Collections.Generic;
using System.Linq;
using Verse;
using System;
using rjw.Modules.Attraction;

namespace rjw.RMB
{
	/// <summary>
	/// Generator of RMB categories for rape
	/// </summary>
	static class RMB_Rape
	{
		/// <summary>
		/// Create rape and reverse rape options
		/// </summary>
		/// <param name="pawn">Selected pawn</param>
		/// <param name="target">Target of the right click</param>
		public static IEnumerable<FloatMenuOption> GetOptions(Pawn pawn, Pawn target)
		{
			AcceptanceReport canCreateEntries = DoBasicChecks(pawn, target);

			if (!canCreateEntries)
			{
				if (RJWSettings.DevMode && !canCreateEntries.Reason.NullOrEmpty())
					yield return new FloatMenuOption(canCreateEntries.Reason, null);

				yield break;
			}

			canCreateEntries = DoChecks(pawn, target);

			if (!canCreateEntries)
			{
				yield return new FloatMenuOption("RJW_RMB_Rape".Translate(target) + ": " + canCreateEntries.Reason, null);
				yield break;
			}

			FloatMenuOption opt = GenerateCategoryOption(pawn, target);
			if (opt != null)
				yield return opt;

			opt = GenerateCategoryOption(pawn, target, true);
			if (opt != null)
				yield return opt;
		}

		/// <summary>
		/// Check for the things that should be obvious to the player or does not change for particular pawns.
		/// </summary>
		/// <returns>
		/// AcceptanceReport. Reason is an untranslated string and should only be shown in the DevMode
		/// </returns>
		private static AcceptanceReport DoBasicChecks(Pawn pawn, Pawn target)
		{
			if (!RJWSettings.rape_enabled)
			{
				return "No rape: Disabled by the mod settings";
			}

			if (!xxx.can_rape(pawn, true))
			{
				return "No rape: Pawn can't rape";
			}

			if (!xxx.can_be_fucked(target))
			{
				return "No rape: Target can't have sex";
			}

			if (target.HostileTo(pawn) && !target.Downed)
			{
				return "No rape: Hostile must be downed";
			}

			return true;
		}

		/// <summary>
		/// Check for the things that can change for particular pawns.
		/// </summary>
		/// <returns>
		/// AcceptanceReport. Reason is a translated string and should not be null.
		/// </returns>
		private static AcceptanceReport DoChecks(Pawn pawn, Pawn target)
		{
			if (!pawn.IsDesignatedHero() && !pawn.IsHeroOwner())
			{
				if (AttractionUtility.Evaluate(pawn, target, AttractionPurpose.ForRape) < 0.1f)
					return "RJW_RMB_ReasonUnappealingTarget".Translate();
			}

			return true;
		}

		/// <summary>
		/// Generate one FloatMenuOption
		/// </summary>
		/// <param name="pawn"></param>
		/// <param name="target"></param>
		/// <param name="reverse"></param>
		/// <returns>Category-level item that opens a sub-menu on click</returns>
		private static FloatMenuOption GenerateCategoryOption(Pawn pawn, Pawn target, bool reverse = false)
		{
			string text = null;

			if (reverse)
			{
				text = "RJW_RMB_Rape_Reverse".Translate(target);
			}
			else
			{
				text = "RJW_RMB_Rape".Translate(target);
			}

			Action action = null;

			if (target.HostileTo(pawn))
			{
				action = delegate ()
				{
					var validinteractions = RMB_Menu.GenerateNonSoloSexRoleOptions(pawn, target, xxx.RapeEnemy, true, reverse);
					if (validinteractions.Any())
						FloatMenuUtility.MakeMenu(validinteractions, (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
					else
					{
						var messageText = "RJW_RMB_NoValidInteractions".Translate(text);
						Messages.Message(messageText, MessageTypeDefOf.RejectInput, false);
					}
				};
			}
			else if (target.IsDesignatedComfort())
			{
				action = delegate ()
				{
					var validinteractions = RMB_Menu.GenerateNonSoloSexRoleOptions(pawn, target, xxx.RapeCP, true, reverse);
					if (validinteractions.Any())
						FloatMenuUtility.MakeMenu(validinteractions, (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
					else
					{
						var messageText = "RJW_RMB_NoValidInteractions".Translate(text);
						Messages.Message(messageText, MessageTypeDefOf.RejectInput, false);
					}
				};
			}
			else if (xxx.can_get_raped(target) && (xxx.get_vulnerability(target) >= xxx.get_vulnerability(pawn)))
			{
				action = delegate ()
				{
					var validinteractions = RMB_Menu.GenerateNonSoloSexRoleOptions(pawn, target, xxx.RapeRandom, true, reverse);
					if (validinteractions.Any())
						FloatMenuUtility.MakeMenu(validinteractions, (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
					else
					{
						var messageText = "RJW_RMB_NoValidInteractions".Translate(text);
						Messages.Message(messageText, MessageTypeDefOf.RejectInput, false);
					}
				};
			}
			else
			{
				if (RJWSettings.DevMode && !reverse)
				{
					return new FloatMenuOption("No rape: Target not hostile, not CP, can't be raped, or not vulnerable enough", null);
				}

				return null;
			}

			return FloatMenuUtility.DecoratePrioritizedTask(new FloatMenuOption(text, action, MenuOptionPriority.High), pawn, target);
		}
	}
}
