﻿using Verse;
using RimWorld;
using Verse.AI;
using rjw.Modules.Interactions;
using System.Collections.Generic;
using rjw.Modules.Shared.Extensions;

namespace rjw
{
	/// <summary>
	/// data for sex related stuff/outcome
	/// </summary>
	public class SexProps : IExposable
	{
		public Pawn pawn;
		public Pawn partner;
		public bool hasPartner() => partner != null && partner != pawn;
		public InteractionDef dictionaryKey = null;
		public bool usedCondom = false;
		public bool isRape = false;
		public bool isReceiver = false;// as JobDriver_SexBaseReciever
		public bool isRevese = false;// brainfuck with who fucks who, see impregnation for clarity with tags n shit?.     interaction.HasInteractionTag(InteractionTag.Reverse)
		public bool isRapist = false;
		public bool isCoreLovin = false;//vanilla loving, skip some mechanics.  should really clean this up someday
		public bool isWhoring = false;
		public bool isMechImplant = false;
		public bool canBeGuilty = true;// can initiator pawn be counted guilty for percepts, player initiated/rmb actrions = false

		public int orgasms = 0; // The orgasms had by the pawn
		public SexProps()
		{
		}

		public Pawn initiator => isReceiver ? partner : pawn;
		public Pawn recipient => isReceiver ? pawn : partner;
		

		// TODO: replace dictionaryKey (breaking change)
		private InteractionDef interactionDef
		{
			get { return dictionaryKey; }
			set { dictionaryKey = value; }
		}
		private SexInteraction _interaction;
		public SexInteraction interaction {
			get
			{
				if (_interaction == null)
					_interaction = new SexInteraction(interactionDef);
				return _interaction;
			}
			set
			{
				_interaction = value;
				if (value != null)
				{
					interactionDef = value.Def;
				}
			}
		}

		public SexInteractionResolved _resolved;
		public SexInteractionResolved resolved {
			get
			{
				if (_resolved == null)
				{
					if (this.interactionDef == null || this.pawn == null || this.partner == null)
						ModLog.Error($"SexProps could not resolve interaction! Missing data. {this.interactionDef}, {this.pawn}, {this.partner}");
					else
					{
						ModLog.Warning("SexProps forced to try resolve interaction. This should only happen on save load.");
						_resolved = SexInteractionHelper.ResolveInteraction(this);
						if(_resolved == null)
						{
							ModLog.Warning($"SexProps failed to resolve {this.interaction.Def} for {this.initiator.GetName()} -> {this.recipient.GetName()}, using empty interaction.");
							new SexInteractionResolved
							{
								Initiator = this.initiator,
								Recipient = this.recipient,
								Interaction = this.interaction,
								InitiatorParts = new(),
								RecipientParts = new(),
								Penetrations = new()
							};
						}
					}
				}
				return _resolved;
			}
			set
			{
				_resolved = value;
				if (value != null)
				{
					_interaction = value.Interaction;
					interactionDef = value.Interaction.Def;
				}
			}
		}

		private xxx.rjwSextype? _sexType;
		public xxx.rjwSextype sexType { get
			{
				if (_sexType == null)
					_sexType = interaction.Sextype;
				return _sexType ?? xxx.rjwSextype.None;
			}
		}
		
		public bool IsInitiator() => !isReceiver;

		public bool IsSubmissive() => (isReceiver && !isRevese) || (!isReceiver && isRevese);

		public SexProps GetForPartner()
		{
			return new SexProps
			{
				pawn = partner,
				partner = pawn,
				usedCondom = usedCondom,
				isRape = isRape,
				isReceiver = !isReceiver,
				isRevese = isRevese,
				isRapist = isRapist,
				isMechImplant = isMechImplant,
				isCoreLovin = isCoreLovin,
				isWhoring = isWhoring,
				canBeGuilty = canBeGuilty,
				orgasms = orgasms,
				interaction = interaction,
				resolved = resolved
			};
		}

		public void ExposeData()
		{
			Scribe_References.Look(ref pawn, "pawn");
			Scribe_References.Look(ref partner, "partner");
			Scribe_Defs.Look(ref dictionaryKey, "dictionaryKey");
			Scribe_Values.Look(ref usedCondom, "usedCondom");
			Scribe_Values.Look(ref isRape, "isRape");
			Scribe_Values.Look(ref isReceiver, "isReceiver");
			Scribe_Values.Look(ref isRapist, "isRapist");
			Scribe_Values.Look(ref isMechImplant, "isMechImplant");
			Scribe_Values.Look(ref isCoreLovin, "isCoreLovin");
			Scribe_Values.Look(ref isWhoring, "isWhoring");
			Scribe_Values.Look(ref canBeGuilty, "canBeGuilty");
			Scribe_Values.Look(ref orgasms, "orgasms");
		}
	}
}
