﻿using System.Linq;
using Verse;
using HarmonyLib;
using RimWorld;
using System.Collections;
using System.Collections.Generic;
using rjw.Modules.Interactions;

namespace rjw
{

	/// <summary>
	/// Necessary to prevent duplicate stat entries on harvested part, since stats are populated by each recipe that
	/// installs it.
	/// </summary>
	[HarmonyPatch(typeof(MedicalRecipesUtility), nameof(MedicalRecipesUtility.GetMedicalStatsFromRecipeDefs))]
	public static class FixDuplicatePartStats
	{
		class StatDrawEntryEqualityComparer : IEqualityComparer<StatDrawEntry>
		{
			public bool Equals(StatDrawEntry x, StatDrawEntry y) => x.LabelCap == y.LabelCap && x.ValueString == y.ValueString;

			public int GetHashCode(StatDrawEntry entry) => entry.LabelCap.GetHashCode() ^ entry.ValueString.GetHashCode();
		}

		static IEqualityComparer<StatDrawEntry> comparer = new StatDrawEntryEqualityComparer();

		static IEnumerable<StatDrawEntry> Postfix(IEnumerable<StatDrawEntry> recipes) => recipes.Distinct(comparer);
	}

	/// <summary>
	/// Filter out the generic "Remove {0}" operations for the rjw parts because we have custom ones
	/// </summary>
	[HarmonyPatch(typeof(Recipe_RemoveBodyPart), nameof(Recipe_RemoveBodyPart.GetPartsToApplyOn))]
	public static class Patch_FilterVanillaRemovalForRJW
	{
		public static void Postfix(Pawn pawn, ref IEnumerable<BodyPartRecord> __result)
		{
			if (pawn == null || __result == null)
			{
				return;
			}

			LewdParts lp = pawn.GetLewdParts();
			__result = __result.Where(part =>
				!(lp.Penises.Any(x => x.BodyPart == part)
				|| lp.Vaginas.Any(x => x.BodyPart == part)
				|| lp.Breasts.Any(x => x.BodyPart == part)
				|| lp.Udders.Any(x => x.BodyPart == part)
				|| lp.Anuses.Any(x => x.BodyPart == part)
				|| lp.FemaleOvipositors.Any(x => x.BodyPart == part)
				|| lp.MaleOvipositors.Any(x => x.BodyPart == part)));
		}
	}

	/// <summary>
	/// Patch all races into rjw parts recipes 
	/// </summary>
	[StaticConstructorOnStartup]
	public static class MakeAllRacesUseSexPartRecipes
	{
		static MakeAllRacesUseSexPartRecipes()
		{
			//summons carpet bombing

			//inject races into rjw recipes
			foreach (RecipeDef x in	DefDatabase<RecipeDef>.AllDefsListForReading.Where(x => x.IsSurgery && (x.targetsBodyPart || !x.appliedOnFixedBodyParts.NullOrEmpty())))
			{
				if (x.appliedOnFixedBodyParts.Contains(xxx.genitalsDef)
					|| x.appliedOnFixedBodyParts.Contains(xxx.breastsDef)
					|| x.appliedOnFixedBodyParts.Contains(xxx.anusDef)
					|| x.modContentPack?.PackageId == "rim.job.world" 
					|| x.modContentPack?.PackageId == "Safe.Job.World" //*sigh*
					//|| x.modContentPack?.PackageId == "Abraxas.RJW.RaceSupport" // for udders?
					)

					foreach (ThingDef thingDef in DefDatabase<ThingDef>.AllDefs.Where(thingDef =>
							thingDef.race != null && (
							thingDef.race.Humanlike ||
							thingDef.race.Animal
							)))
					{
						//filter out something, probably?
						//if (thingDef.race. == "Human")
						//	continue;

						if (!x.recipeUsers.Contains(thingDef))
						{
							x.recipeUsers.Add(item: thingDef);
							//Log.Message("recipe: " + x.defName + ", thing: " + thingDef.defName);

						}
					}
			}
		}
	}
}
